/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class XmlUtil {
    private static final Logger log = LoggerFactory.getLogger(XmlUtil.class);
    private static final XmlMapper XML_MAPPER = new XmlMapper();

    public String toXml(Object source) {
        if (source == null) {
            return null;
        }
        try {
            return XML_MAPPER.writeValueAsString(source);
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T fromXml(String xml, Class<T> clazz) {
        if (!StringUtils.hasText((String)xml)) {
            return null;
        }
        try {
            return (T)XML_MAPPER.readValue(xml, clazz);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T fromXml(String xml, TypeReference<T> type) {
        if (!StringUtils.hasText((String)xml)) {
            return null;
        }
        try {
            return (T)XML_MAPPER.readValue(xml, type);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        XML_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new JavaTimeModule());
    }
}

