/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscriptions;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Subscription;

public final class ArrayCompositeSubscription
extends AtomicReferenceArray<Subscription>
implements Disposable {
    private static final long serialVersionUID = 2746389416410565408L;

    public ArrayCompositeSubscription(int capacity) {
        super(capacity);
    }

    public boolean setResource(int index, Subscription resource) {
        Subscription o;
        do {
            if ((o = (Subscription)this.get(index)) != SubscriptionHelper.CANCELLED) continue;
            if (resource != null) {
                resource.cancel();
            }
            return false;
        } while (!this.compareAndSet(index, o, resource));
        if (o != null) {
            o.cancel();
        }
        return true;
    }

    public Subscription replaceResource(int index, Subscription resource) {
        Subscription o;
        do {
            if ((o = (Subscription)this.get(index)) != SubscriptionHelper.CANCELLED) continue;
            if (resource != null) {
                resource.cancel();
            }
            return null;
        } while (!this.compareAndSet(index, o, resource));
        return o;
    }

    @Override
    public void dispose() {
        if (this.get(0) != SubscriptionHelper.CANCELLED) {
            int s = this.length();
            for (int i = 0; i < s; ++i) {
                Subscription o = (Subscription)this.get(i);
                if (o == SubscriptionHelper.CANCELLED || (o = (Subscription)this.getAndSet(i, SubscriptionHelper.CANCELLED)) == SubscriptionHelper.CANCELLED || o == null) continue;
                o.cancel();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.get(0) == SubscriptionHelper.CANCELLED;
    }
}

