/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestArgs {
    TestArgs() {
    }

    @Test
    void testArgCheckPass() {
        Args.check((boolean)true, (String)"All is well");
    }

    @Test
    void testArgCheckFail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.check((boolean)false, (String)"Oopsie"));
    }

    @Test
    void testArgNotNullPass() {
        String stuff = "stuff";
        Assertions.assertSame((Object)"stuff", (Object)Args.notNull((Object)"stuff", (String)"Stuff"));
    }

    @Test
    void testArgNotNullFail() {
        Assertions.assertThrows(NullPointerException.class, () -> Args.notNull(null, (String)"Stuff"));
    }

    @Test
    void testArgNotEmptyPass() {
        String stuff = "stuff";
        Assertions.assertSame((Object)"stuff", (Object)Args.notEmpty((CharSequence)"stuff", (String)"Stuff"));
    }

    @Test
    void testArgNotEmptyFail1() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)Args.notEmpty((CharSequence)null, (String)"Stuff");
        });
    }

    @Test
    void testArgNotEmptyFail2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String cfr_ignored_0 = (String)Args.notEmpty((CharSequence)"", (String)"Stuff");
        });
    }

    @Test
    void testArgNotBlankFail1() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)Args.notBlank((CharSequence)null, (String)"Stuff");
        });
    }

    @Test
    void testArgNotBlankFail2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String cfr_ignored_0 = (String)Args.notBlank((CharSequence)"", (String)"Stuff");
        });
    }

    @Test
    void testArgNotBlankFail3() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String cfr_ignored_0 = (String)Args.notBlank((CharSequence)" \t \n\r", (String)"Stuff");
        });
    }

    @Test
    void testArgCollectionNotEmptyPass() {
        List<String> list = Collections.singletonList("stuff");
        Assertions.assertSame(list, (Object)Args.notEmpty(list, (String)"List"));
    }

    @Test
    void testArgCollectionNotEmptyFail1() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            List cfr_ignored_0 = (List)Args.notEmpty((Collection)null, (String)"List");
        });
    }

    @Test
    void testArgCollectionNotEmptyFail2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            List cfr_ignored_0 = (List)Args.notEmpty(Collections.emptyList(), (String)"List");
        });
    }

    @Test
    void testPositiveIntPass() {
        Assertions.assertEquals((int)1, (int)Args.positive((int)1, (String)"Number"));
    }

    @Test
    void testPositiveIntFail1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.positive((int)-1, (String)"Number"));
    }

    @Test
    void testPositiveIntFail2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.positive((int)0, (String)"Number"));
    }

    @Test
    void testPositiveLongPass() {
        Assertions.assertEquals((long)1L, (long)Args.positive((long)1L, (String)"Number"));
    }

    @Test
    void testPositiveTimeValuePass() throws ParseException {
        Timeout timeout = Timeout.parse((String)"1200 MILLISECONDS");
        Assertions.assertEquals((Object)timeout, (Object)Args.positive((TimeValue)timeout, (String)"No Error"));
    }

    @Test
    void testPositiveLongFail1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.positive((long)-1L, (String)"Number"));
    }

    @Test
    void testPositiveLongFail2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.positive((long)0L, (String)"Number"));
    }

    @Test
    void testNotNegativeIntPass1() {
        Assertions.assertEquals((int)1, (int)Args.notNegative((int)1, (String)"Number"));
    }

    @Test
    void testNotNegativeIntPass2() {
        Assertions.assertEquals((int)0, (int)Args.notNegative((int)0, (String)"Number"));
    }

    @Test
    void testNotNegativeIntFail1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.notNegative((int)-1, (String)"Number"));
    }

    @Test
    void testNotNegativeLongPass1() {
        Assertions.assertEquals((long)1L, (long)Args.notNegative((long)1L, (String)"Number"));
    }

    @Test
    void testNotNegativeLongPass2() {
        Assertions.assertEquals((long)0L, (long)Args.notNegative((long)0L, (String)"Number"));
    }

    @Test
    void testNotNegativeLongFail1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.notNegative((long)-1L, (String)"Number"));
    }

    @Test
    void testIntSmallestRangeOK() {
        Args.checkRange((int)0, (int)0, (int)0, (String)"Number");
    }

    @Test
    void testIntSmallestRangeFailLow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.checkRange((int)-1, (int)0, (int)0, (String)"Number"));
    }

    @Test
    void testIntRangeFailLow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.checkRange((int)-101, (int)-100, (int)100, (String)"Number"));
    }

    @Test
    void testIntRangeFailHigh() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.checkRange((int)101, (int)-100, (int)100, (String)"Number"));
    }

    @Test
    void testIntSmallestRangeFailHigh() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.checkRange((int)1, (int)0, (int)0, (String)"Number"));
    }

    @Test
    void testIntFullRangeOK() {
        Args.checkRange((int)0, (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE, (String)"Number");
    }

    @Test
    void testLongSmallestRangeOK() {
        Args.checkRange((long)0L, (long)0L, (long)0L, (String)"Number");
    }

    @Test
    void testLongSmallestRangeFailLow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.checkRange((long)-1L, (long)0L, (long)0L, (String)"Number"));
    }

    @Test
    void testLongRangeFailLow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.checkRange((long)-101L, (long)-100L, (long)100L, (String)"Number"));
    }

    @Test
    void testLongRangeFailHigh() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.checkRange((long)101L, (long)-100L, (long)100L, (String)"Number"));
    }

    @Test
    void testLongSmallestRangeFailHigh() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.checkRange((long)1L, (long)0L, (long)0L, (String)"Number"));
    }

    @Test
    void testLongFullRangeOK() {
        Args.checkRange((long)0L, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE, (String)"Number");
    }

    @Test
    void testIsEmpty() {
        String[] NON_EMPTY_ARRAY = new String[]{"ABG", "NML"};
        List<String> NON_EMPTY_LIST = Arrays.asList(NON_EMPTY_ARRAY);
        HashSet<String> NON_EMPTY_SET = new HashSet<String>(NON_EMPTY_LIST);
        HashMap<String, String> NON_EMPTY_MAP = new HashMap<String, String>();
        NON_EMPTY_MAP.put("ABG", "MNL");
        Assertions.assertTrue((boolean)Args.isEmpty(null));
        Assertions.assertTrue((boolean)Args.isEmpty((Object)""));
        Assertions.assertTrue((boolean)Args.isEmpty((Object)new int[0]));
        Assertions.assertTrue((boolean)Args.isEmpty(Collections.emptyList()));
        Assertions.assertTrue((boolean)Args.isEmpty(Collections.emptySet()));
        Assertions.assertTrue((boolean)Args.isEmpty(Collections.emptyMap()));
        Assertions.assertFalse((boolean)Args.isEmpty((Object)"  "));
        Assertions.assertFalse((boolean)Args.isEmpty((Object)"ab"));
        Assertions.assertFalse((boolean)Args.isEmpty((Object)NON_EMPTY_ARRAY));
        Assertions.assertFalse((boolean)Args.isEmpty(NON_EMPTY_LIST));
        Assertions.assertFalse((boolean)Args.isEmpty(NON_EMPTY_SET));
        Assertions.assertFalse((boolean)Args.isEmpty(NON_EMPTY_MAP));
    }

    @Test
    void testContainsNoBlanks() {
        String stuff = "abg";
        Assertions.assertSame((Object)"abg", (Object)Args.containsNoBlanks((CharSequence)"abg", (String)"abg"));
    }

    @Test
    void check() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Args.check((boolean)false, (String)"Error,", (Object)"ABG"));
    }
}

