/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.routing;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hc.core5.http.impl.routing.PathRoute;
import org.apache.hc.core5.http.impl.routing.UriPathRouter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestUriPathRouter {
    TestUriPathRouter() {
    }

    @Test
    void testBestMatchWildCardMatching() {
        UriPathRouter.BestMatcher matcher = UriPathRouter.BestMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)"*", (Object)0L), new PathRoute((Object)"/one/*", (Object)1L), new PathRoute((Object)"/one/two/*", (Object)2L), new PathRoute((Object)"/one/two/three/*", (Object)3L), new PathRoute((Object)"*.view", (Object)4L), new PathRoute((Object)"*.form", (Object)5L));
        Assertions.assertEquals((long)1L, (Long)((Long)matcher.apply("/one/request", routes)));
        Assertions.assertEquals((long)2L, (Long)((Long)matcher.apply("/one/two/request", routes)));
        Assertions.assertEquals((long)3L, (Long)((Long)matcher.apply("/one/two/three/request", routes)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("default/request", routes)));
        Assertions.assertEquals((long)4L, (Long)((Long)matcher.apply("that.view", routes)));
        Assertions.assertEquals((long)5L, (Long)((Long)matcher.apply("that.form", routes)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("whatever", routes)));
    }

    @Test
    void testBestMatchWildCardMatchingSuffixPrefixPrecedence() {
        UriPathRouter.BestMatcher matcher = UriPathRouter.BestMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)"/ma*", (Object)1L), new PathRoute((Object)"*tch", (Object)2L));
        Assertions.assertEquals((long)1L, (Long)((Long)matcher.apply("/match", routes)));
    }

    @Test
    void testBestMatchWildCardMatchingExactMatch() {
        UriPathRouter.BestMatcher matcher = UriPathRouter.BestMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)"exact", (Object)1L), new PathRoute((Object)"*", (Object)0L));
        Assertions.assertEquals((long)1L, (Long)((Long)matcher.apply("exact", routes)));
    }

    @Test
    void testBestMatchWildCardMatchingNoMatch() {
        UriPathRouter.BestMatcher matcher = UriPathRouter.BestMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)"/this/*", (Object)1L), new PathRoute((Object)"/that/*", (Object)2L));
        Assertions.assertNull((Object)matcher.apply("huh?", routes));
    }

    @Test
    void testOrderedWildCardMatching1() {
        UriPathRouter.OrderedMatcher matcher = UriPathRouter.OrderedMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)"*", (Object)0L), new PathRoute((Object)"/one/*", (Object)1L), new PathRoute((Object)"/one/two/*", (Object)2L), new PathRoute((Object)"/one/two/three/*", (Object)3L), new PathRoute((Object)"*.view", (Object)4L), new PathRoute((Object)"*.form", (Object)5L));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("/one/request", routes)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("/one/two/request", routes)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("/one/two/three/request", routes)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("default/request", routes)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("that.view", routes)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("that.form", routes)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("whatever", routes)));
        List<PathRoute> routes2 = Arrays.asList(new PathRoute((Object)"/one/two/three/*", (Object)3L), new PathRoute((Object)"/one/two/*", (Object)2L), new PathRoute((Object)"/one/*", (Object)1L), new PathRoute((Object)"*.view", (Object)4L), new PathRoute((Object)"*.form", (Object)5L), new PathRoute((Object)"*", (Object)0L));
        Assertions.assertEquals((long)3L, (Long)((Long)matcher.apply("/one/two/three/request", routes2)));
        Assertions.assertEquals((long)2L, (Long)((Long)matcher.apply("/one/two/request", routes2)));
        Assertions.assertEquals((long)1L, (Long)((Long)matcher.apply("/one/request", routes2)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("default/request", routes2)));
        Assertions.assertEquals((long)4L, (Long)((Long)matcher.apply("that.view", routes2)));
        Assertions.assertEquals((long)5L, (Long)((Long)matcher.apply("that.form", routes2)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("whatever", routes2)));
    }

    @Test
    void testOrderedWildCardMatchingSuffixPrefixPrecedence() {
        UriPathRouter.OrderedMatcher matcher = UriPathRouter.OrderedMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)"/ma*", (Object)1L), new PathRoute((Object)"*tch", (Object)2L));
        Assertions.assertEquals((long)1L, (Long)((Long)matcher.apply("/match", routes)));
    }

    @Test
    void testOrderedStarAndExact() {
        UriPathRouter.OrderedMatcher matcher = UriPathRouter.OrderedMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)"*", (Object)0L), new PathRoute((Object)"exact", (Object)1L));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("exact", routes)));
    }

    @Test
    void testOrderedExactAndStar() {
        UriPathRouter.OrderedMatcher matcher = UriPathRouter.OrderedMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)"exact", (Object)1L), new PathRoute((Object)"*", (Object)0L));
        Assertions.assertEquals((long)1L, (Long)((Long)matcher.apply("exact", routes)));
    }

    @Test
    void testRegExMatching() {
        UriPathRouter.RegexMatcher matcher = UriPathRouter.RegexMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)Pattern.compile("/one/two/three/.*"), (Object)3L), new PathRoute((Object)Pattern.compile("/one/two/.*"), (Object)2L), new PathRoute((Object)Pattern.compile("/one/.*"), (Object)1L), new PathRoute((Object)Pattern.compile(".*\\.view"), (Object)4L), new PathRoute((Object)Pattern.compile(".*\\.form"), (Object)5L), new PathRoute((Object)Pattern.compile(".*"), (Object)0L));
        Assertions.assertEquals((long)1L, (Long)((Long)matcher.apply("/one/request", routes)));
        Assertions.assertEquals((long)2L, (Long)((Long)matcher.apply("/one/two/request", routes)));
        Assertions.assertEquals((long)3L, (Long)((Long)matcher.apply("/one/two/three/request", routes)));
        Assertions.assertEquals((long)4L, (Long)((Long)matcher.apply("/that.view", routes)));
        Assertions.assertEquals((long)5L, (Long)((Long)matcher.apply("/that.form", routes)));
        Assertions.assertEquals((long)0L, (Long)((Long)matcher.apply("/default/request", routes)));
    }

    @Test
    void testRegExWildCardMatchingSuffixPrefixPrecedence() {
        UriPathRouter.RegexMatcher matcher = UriPathRouter.RegexMatcher.getInstance();
        List<PathRoute> routes = Arrays.asList(new PathRoute((Object)Pattern.compile("/ma.*"), (Object)1L), new PathRoute((Object)Pattern.compile(".*tch"), (Object)2L));
        Assertions.assertEquals((long)1L, (Long)((Long)matcher.apply("/match", routes)));
    }
}

