/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class FSWALEntry
extends WAL.Entry {
    private final transient long txid;
    private final transient boolean inMemstore;
    private final transient boolean closeRegion;
    private final transient RegionInfo regionInfo;
    private final transient Set<byte[]> familyNames;
    private final transient ServerCall<?> rpcCall;

    FSWALEntry(long txid, WALKeyImpl key, WALEdit edit, RegionInfo regionInfo, boolean inMemstore, ServerCall<?> rpcCall) {
        super(key, edit);
        Set<byte[]> families;
        this.inMemstore = inMemstore;
        this.closeRegion = !inMemstore && edit.isRegionCloseMarker();
        this.regionInfo = regionInfo;
        this.txid = txid;
        this.familyNames = inMemstore ? ((families = edit.getFamilies()) != null ? families : FSWALEntry.collectFamilies(edit.getCells())) : Collections.emptySet();
        this.rpcCall = rpcCall;
        if (rpcCall != null) {
            rpcCall.retainByWAL();
        }
    }

    @VisibleForTesting
    static Set<byte[]> collectFamilies(List<Cell> cells) {
        if (CollectionUtils.isEmpty(cells)) {
            return Collections.emptySet();
        }
        TreeSet<byte[]> set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (Cell cell : cells) {
            if (WALEdit.isMetaEditFamily(cell)) continue;
            set.add(CellUtil.cloneFamily((Cell)cell));
        }
        return set;
    }

    @Override
    public String toString() {
        return "sequence=" + this.txid + ", " + super.toString();
    }

    boolean isInMemStore() {
        return this.inMemstore;
    }

    boolean isCloseRegion() {
        return this.closeRegion;
    }

    RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    long getTxid() {
        return this.txid;
    }

    long stampRegionSequenceId(MultiVersionConcurrencyControl.WriteEntry we) throws IOException {
        long regionSequenceId = we.getWriteNumber();
        if (!this.getEdit().isReplay() && this.inMemstore) {
            for (Cell c : this.getEdit().getCells()) {
                PrivateCellUtil.setSequenceId((Cell)c, (long)regionSequenceId);
            }
        }
        this.getKey().setWriteEntry(we);
        return regionSequenceId;
    }

    Set<byte[]> getFamilyNames() {
        return this.familyNames;
    }

    void release() {
        if (this.rpcCall != null) {
            this.rpcCall.releaseByWAL();
        }
    }
}

