/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.NoRowSetExpectedException;
import org.apache.ignite.sql.ResultSet;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.jetbrains.annotations.Nullable;

public class SyncResultSetAdapter<T>
implements ResultSet<T> {
    private final AsyncResultSet<T> ars;
    private final IteratorImpl<T> it;

    public SyncResultSetAdapter(AsyncResultSet<T> ars) {
        assert (ars != null);
        this.ars = ars;
        this.it = ars.hasRowSet() ? new IteratorImpl<T>(ars) : null;
    }

    @Nullable
    public ResultSetMetadata metadata() {
        return this.ars.metadata();
    }

    public boolean hasRowSet() {
        return this.ars.hasRowSet();
    }

    public long affectedRows() {
        return this.ars.affectedRows();
    }

    public boolean wasApplied() {
        return this.ars.wasApplied();
    }

    public void close() {
        try {
            this.ars.closeAsync().toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw ExceptionUtils.wrap(e);
        }
    }

    public boolean hasNext() {
        if (this.it == null) {
            return false;
        }
        return this.it.hasNext();
    }

    public T next() {
        if (this.it == null) {
            throw new NoRowSetExpectedException();
        }
        return this.it.next();
    }

    private static class IteratorImpl<T>
    implements Iterator<T> {
        private AsyncResultSet<T> curRes;
        private CompletionStage<? extends AsyncResultSet<T>> nextPageStage;
        private Iterator<T> curPage;

        IteratorImpl(AsyncResultSet<T> ars) {
            this.curRes = ars;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            if (this.curPage.hasNext()) {
                return true;
            }
            if (this.nextPageStage != null) {
                try {
                    this.curRes = this.nextPageStage.toCompletableFuture().join();
                }
                catch (CompletionException ex) {
                    throw (IgniteException)ExceptionUtils.unwrapCause(ex);
                }
                this.advance();
                return this.curPage.hasNext();
            }
            return false;
        }

        private void advance() {
            this.curPage = this.curRes.currentPage().iterator();
            this.nextPageStage = this.curRes.hasMorePages() ? this.curRes.fetchNextPage() : null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.curPage.next();
        }
    }
}

