/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleCommon;
import org.apache.ignite.internal.binarytuple.BinaryTupleContainer;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowImpl;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaAware;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaMismatchException;
import org.apache.ignite.internal.schema.SchemaVersionMismatchException;
import org.apache.ignite.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite.internal.schema.marshaller.TupleMarshaller;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypeSpec;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.MarshallerException;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.TupleHelper;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TupleMarshallerImpl
implements TupleMarshaller {
    private static final Object POISON_OBJECT = new Object();
    private final SchemaDescriptor schema;
    private final int keyOnlyFixedLengthColumnSize;
    private final int valueOnlyFixedLengthColumnSize;

    public TupleMarshallerImpl(SchemaDescriptor schema) {
        this.schema = schema;
        this.keyOnlyFixedLengthColumnSize = schema.keyColumns().stream().map(Column::type).filter(type -> type.spec().fixedLength()).mapToInt(NativeType::sizeInBytes).sum();
        this.valueOnlyFixedLengthColumnSize = schema.valueColumns().stream().map(Column::type).filter(type -> type.spec().fixedLength()).mapToInt(NativeType::sizeInBytes).sum();
    }

    @Override
    public int schemaVersion() {
        return this.schema.version();
    }

    @Override
    public Row marshal(Tuple tuple) throws MarshallerException {
        try {
            if (tuple instanceof SchemaAware && tuple instanceof BinaryTupleContainer) {
                SchemaDescriptor tupleSchema = ((SchemaAware)tuple).schema();
                BinaryTupleReader tupleReader = ((BinaryTupleContainer)tuple).binaryTuple();
                if (tupleSchema != null && tupleReader != null) {
                    if (tupleSchema.version() != this.schema.version()) {
                        throw new SchemaVersionMismatchException(this.schema.version(), tupleSchema.version());
                    }
                    if (!TupleMarshallerImpl.binaryTupleRebuildRequired(this.schema)) {
                        TupleMarshallerImpl.validateTuple(tuple, this.schema);
                        BinaryRowImpl binaryRow = new BinaryRowImpl(this.schema.version(), tupleReader.byteBuffer());
                        return Row.wrapBinaryRow((SchemaDescriptor)this.schema, (BinaryRow)binaryRow);
                    }
                }
            }
            TuplePart part = TuplePart.KEY_VALUE;
            ValuesWithStatistics valuesWithStatistics = new ValuesWithStatistics();
            this.gatherStatistics(part, tuple, valuesWithStatistics);
            if (valuesWithStatistics.knownColumns != tuple.columnCount()) {
                throw new SchemaMismatchException(String.format("Tuple doesn't match schema: schemaVersion=%s, extraColumns=%s", this.schema.version(), TupleMarshallerImpl.extraColumnNames(tuple, this.schema)));
            }
            return this.buildRow(part, valuesWithStatistics);
        }
        catch (Exception ex) {
            throw new MarshallerException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public Row marshal(Tuple keyTuple, @Nullable Tuple valTuple) throws MarshallerException {
        try {
            boolean keyOnly;
            ValuesWithStatistics valuesWithStatistics = new ValuesWithStatistics();
            this.gatherStatistics(TuplePart.KEY, keyTuple, valuesWithStatistics);
            if (valuesWithStatistics.knownColumns != keyTuple.columnCount()) {
                throw new SchemaMismatchException(String.format("Key tuple doesn't match schema: schemaVersion=%s, extraColumns=%s", this.schema.version(), TupleMarshallerImpl.extraColumnNames(keyTuple, true, this.schema)));
            }
            boolean bl = keyOnly = valTuple == null;
            if (!keyOnly) {
                this.gatherStatistics(TuplePart.VALUE, valTuple, valuesWithStatistics);
                if (valuesWithStatistics.knownColumns - keyTuple.columnCount() != valTuple.columnCount()) {
                    throw new SchemaMismatchException(String.format("Value tuple doesn't match schema: schemaVersion=%s, extraColumns=%s", this.schema.version(), TupleMarshallerImpl.extraColumnNames(valTuple, false, this.schema)));
                }
            }
            return this.buildRow(keyOnly ? TuplePart.KEY : TuplePart.KEY_VALUE, valuesWithStatistics);
        }
        catch (Exception ex) {
            throw new MarshallerException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public Row marshalKey(Tuple keyTuple) throws MarshallerException {
        try {
            ValuesWithStatistics valuesWithStatistics = new ValuesWithStatistics();
            TuplePart part = TuplePart.KEY;
            this.gatherStatistics(part, keyTuple, valuesWithStatistics);
            if (valuesWithStatistics.knownColumns < keyTuple.columnCount()) {
                throw new SchemaMismatchException("Key tuple contains extra columns: " + String.valueOf(TupleMarshallerImpl.extraColumnNames(keyTuple, true, this.schema)));
            }
            return this.buildRow(part, valuesWithStatistics);
        }
        catch (Exception ex) {
            throw new MarshallerException(ex.getMessage(), (Throwable)ex);
        }
    }

    private Row buildRow(TuplePart part, ValuesWithStatistics values) throws SchemaMismatchException {
        List<Column> columns = part.deriveColumnList(this.schema);
        RowAssembler rowBuilder = new RowAssembler(this.schema.version(), columns, values.estimatedValueSize, false);
        for (Column col : columns) {
            rowBuilder.appendValue(values.value(col.name()));
        }
        return part == TuplePart.KEY ? Row.wrapKeyOnlyBinaryRow((SchemaDescriptor)this.schema, (BinaryRow)rowBuilder.build()) : Row.wrapBinaryRow((SchemaDescriptor)this.schema, (BinaryRow)rowBuilder.build());
    }

    void gatherStatistics(TuplePart part, Tuple tuple, ValuesWithStatistics targetTuple) throws SchemaMismatchException {
        int estimatedValueSize = part.fixedSizeColumnsSize(this.keyOnlyFixedLengthColumnSize, this.valueOnlyFixedLengthColumnSize);
        int knownColumns = 0;
        for (Column col : part.deriveColumnList(this.schema)) {
            NativeType colType = col.type();
            Object val = TupleHelper.valueOrDefault(tuple, col.name(), POISON_OBJECT);
            if (val == POISON_OBJECT && col.positionInKey() != -1) {
                throw new SchemaMismatchException("Missed key column: " + col.name());
            }
            if (val == POISON_OBJECT) {
                val = col.defaultValue();
            } else {
                ++knownColumns;
            }
            col.validate(val);
            if (val != null && !colType.spec().fixedLength()) {
                try {
                    val = TupleMarshallerImpl.shrinkValue(val, col.type());
                    estimatedValueSize += MarshallerUtil.getValueSize((Object)val, (NativeType)colType);
                }
                catch (ClassCastException e) {
                    throw new MarshallerException(UUID.randomUUID(), ErrorGroups.Marshalling.COMMON_ERR, String.format("Invalid value type provided for column [name='%s', expected='%s', actual='%s']", col.name(), col.type().spec().asColumnType().javaClass().getName(), val.getClass().getName()), (Throwable)e);
                }
            }
            targetTuple.values.put(col.name(), val);
        }
        targetTuple.estimatedValueSize += estimatedValueSize;
        targetTuple.knownColumns += knownColumns;
    }

    private static <T> T shrinkValue(T value, NativeType type) {
        if (type.spec() == NativeTypeSpec.DECIMAL) {
            assert (type instanceof DecimalNativeType);
            return (T)BinaryTupleCommon.shrinkDecimal((BigDecimal)((BigDecimal)value), (int)((DecimalNativeType)type).scale());
        }
        return value;
    }

    private static Set<String> extraColumnNames(Tuple tuple, SchemaDescriptor schema) {
        HashSet<String> cols = new HashSet<String>();
        int len = tuple.columnCount();
        for (int i = 0; i < len; ++i) {
            String colName = tuple.columnName(i);
            if (schema.column(colName) != null) continue;
            cols.add(colName);
        }
        return cols;
    }

    private static Set<String> extraColumnNames(Tuple tuple, boolean keyTuple, SchemaDescriptor schema) {
        HashSet<String> cols = new HashSet<String>();
        int len = tuple.columnCount();
        for (int i = 0; i < len; ++i) {
            String colName = tuple.columnName(i);
            Column col = schema.column(colName);
            if (col != null && !(col.positionInKey() != -1 ^ keyTuple)) continue;
            cols.add(colName);
        }
        return cols;
    }

    private static boolean binaryTupleRebuildRequired(SchemaDescriptor schema) {
        return schema.hasTemporalColumns();
    }

    private static void validateTuple(Tuple tuple, SchemaDescriptor schema) {
        for (int i = 0; i < schema.length(); ++i) {
            Column col = schema.column(i);
            Object val = tuple.value(i);
            col.validate(val);
        }
    }

    static enum TuplePart {
        KEY{

            @Override
            int fixedSizeColumnsSize(int keyOnlySize, int valueOnlySize) {
                return keyOnlySize;
            }

            @Override
            List<Column> deriveColumnList(SchemaDescriptor schema) {
                return schema.keyColumns();
            }
        }
        ,
        VALUE{

            @Override
            int fixedSizeColumnsSize(int keyOnlySize, int valueOnlySize) {
                return valueOnlySize;
            }

            @Override
            List<Column> deriveColumnList(SchemaDescriptor schema) {
                return schema.valueColumns();
            }
        }
        ,
        KEY_VALUE{

            @Override
            int fixedSizeColumnsSize(int keyOnlySize, int valueOnlySize) {
                return keyOnlySize + valueOnlySize;
            }

            @Override
            List<Column> deriveColumnList(SchemaDescriptor schema) {
                return schema.columns();
            }
        };


        abstract int fixedSizeColumnsSize(int var1, int var2);

        abstract List<Column> deriveColumnList(SchemaDescriptor var1);
    }

    static class ValuesWithStatistics {
        private final Map<String, Object> values = new HashMap<String, Object>();
        private int estimatedValueSize;
        private int knownColumns;

        ValuesWithStatistics() {
        }

        @Nullable
        Object value(String columnName) {
            return this.values.get(columnName);
        }

        @TestOnly
        int estimatedValueSize() {
            return this.estimatedValueSize;
        }
    }
}

