/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.decorators;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.ignite.internal.cli.call.configuration.JsonString;
import org.apache.ignite.internal.cli.commands.treesitter.highlighter.JsonAnsiHighlighter;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;

public class JsonDecorator
implements Decorator<JsonString, TerminalOutput> {
    private final boolean highlight;

    public JsonDecorator(boolean highlight) {
        this.highlight = highlight;
    }

    @Override
    public TerminalOutput decorate(JsonString json) {
        ObjectMapper mapper = new ObjectMapper();
        return () -> {
            try {
                String text = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(mapper.readValue(json.getValue(), JsonNode.class));
                return this.highlight ? JsonAnsiHighlighter.highlight(text) : text;
            }
            catch (JsonProcessingException e) {
                return json.getValue();
            }
        };
    }
}

