/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.compute;

import io.micronaut.http.annotation.Controller;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.compute.ComputeApi;
import org.apache.ignite.internal.rest.api.compute.JobStatus;
import org.apache.ignite.internal.rest.api.compute.UpdateJobPriorityBody;
import org.apache.ignite.internal.rest.compute.exception.ComputeJobNotFoundException;
import org.apache.ignite.internal.rest.compute.exception.ComputeJobStatusException;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

@Controller
public class ComputeController
implements ComputeApi,
ResourceHolder {
    private IgniteComputeInternal compute;

    public ComputeController(IgniteComputeInternal compute) {
        this.compute = compute;
    }

    public CompletableFuture<Collection<org.apache.ignite.internal.rest.api.compute.JobState>> jobStates() {
        return this.compute.statesAsync().thenApply(states -> states.stream().map(ComputeController::toJobState).collect(Collectors.toList()));
    }

    public CompletableFuture<org.apache.ignite.internal.rest.api.compute.JobState> jobState(UUID jobId) {
        return this.jobState0(jobId);
    }

    public CompletableFuture<Void> updatePriority(UUID jobId, UpdateJobPriorityBody updateJobPriorityBody) {
        return this.compute.changePriorityAsync(jobId, updateJobPriorityBody.priority()).thenCompose(result -> this.handleOperationResult(jobId, (Boolean)result));
    }

    public CompletableFuture<Void> cancelJob(UUID jobId) {
        return this.compute.cancelAsync(jobId).thenCompose(result -> this.handleOperationResult(jobId, (Boolean)result));
    }

    private CompletableFuture<Void> handleOperationResult(UUID jobId, @Nullable Boolean result) {
        if (result == null) {
            return CompletableFuture.failedFuture((Throwable)((Object)new ComputeJobNotFoundException(jobId.toString())));
        }
        if (!result.booleanValue()) {
            return this.jobState0(jobId).thenCompose(state -> CompletableFuture.failedFuture((Throwable)((Object)new ComputeJobStatusException(jobId.toString(), state.status()))));
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<org.apache.ignite.internal.rest.api.compute.JobState> jobState0(UUID jobId) {
        return this.compute.stateAsync(jobId).thenApply(state -> {
            if (state == null) {
                throw new ComputeJobNotFoundException(jobId.toString());
            }
            return ComputeController.toJobState(state);
        });
    }

    private static org.apache.ignite.internal.rest.api.compute.JobState toJobState(JobState jobState) {
        return new org.apache.ignite.internal.rest.api.compute.JobState(jobState.id(), JobStatus.valueOf((String)jobState.status().toString()), jobState.createTime(), jobState.startTime(), jobState.finishTime());
    }

    public void cleanResources() {
        this.compute = null;
    }
}

