/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.membership;

import io.scalecube.cluster.Member;
import io.scalecube.cluster.membership.MemberStatus;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;

final class MembershipRecord
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Member member;
    private MemberStatus status;
    private int incarnation;

    public MembershipRecord() {
    }

    public MembershipRecord(Member member, MemberStatus status, int incarnation) {
        this.member = Objects.requireNonNull(member);
        this.status = Objects.requireNonNull(status);
        this.incarnation = incarnation;
    }

    public Member member() {
        return this.member;
    }

    public MemberStatus status() {
        return this.status;
    }

    public boolean isAlive() {
        return this.status == MemberStatus.ALIVE;
    }

    public boolean isSuspect() {
        return this.status == MemberStatus.SUSPECT;
    }

    public boolean isLeaving() {
        return this.status == MemberStatus.LEAVING;
    }

    public boolean isDead() {
        return this.status == MemberStatus.DEAD;
    }

    public int incarnation() {
        return this.incarnation;
    }

    public boolean isOverrides(MembershipRecord r0) {
        if (r0 == null) {
            return this.isAlive() || this.isLeaving();
        }
        if (!Objects.equals(this.member.id(), r0.member.id())) {
            throw new IllegalArgumentException("Can't compare records for different members");
        }
        if (this.equals(r0)) {
            return false;
        }
        if (r0.isDead()) {
            return false;
        }
        if (this.isDead()) {
            return true;
        }
        if (this.incarnation == r0.incarnation) {
            return this.isSuspect() && (r0.isAlive() || r0.isLeaving());
        }
        return this.incarnation > r0.incarnation;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        MembershipRecord record = (MembershipRecord)that;
        return this.incarnation == record.incarnation && Objects.equals(this.member, record.member) && this.status == record.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.member, this.status, this.incarnation});
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.member);
        out.writeObject((Object)this.status);
        out.writeInt(this.incarnation);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.member = (Member)in.readObject();
        this.status = (MemberStatus)((Object)in.readObject());
        this.incarnation = in.readInt();
    }

    public String toString() {
        return "{m: " + this.member + ", s: " + (Object)((Object)this.status) + ", inc: " + this.incarnation + '}';
    }
}

