/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db.master;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.master.SQLiteMasterColumn;

public class SQLiteMasterQuery {
    private final String combineOperation;
    private final List<String> queries = new ArrayList<String>();
    private final List<String> arguments = new ArrayList<String>();

    private SQLiteMasterQuery(String combineOperation) {
        this.combineOperation = combineOperation;
    }

    public void add(SQLiteMasterColumn column, String value) {
        this.add(column, "=", value);
    }

    public void add(SQLiteMasterColumn column, String operation, String value) {
        this.validateAdd();
        this.queries.add("LOWER(" + CoreSQLUtils.quoteWrap(column.name().toLowerCase()) + ") " + operation + " LOWER(?)");
        this.arguments.add(value);
    }

    public void addIsNull(SQLiteMasterColumn column) {
        this.validateAdd();
        this.queries.add(CoreSQLUtils.quoteWrap(column.name().toLowerCase()) + " IS NULL");
    }

    public void addIsNotNull(SQLiteMasterColumn column) {
        this.validateAdd();
        this.queries.add(CoreSQLUtils.quoteWrap(column.name().toLowerCase()) + " IS NOT NULL");
    }

    private void validateAdd() {
        if (this.combineOperation == null && !this.queries.isEmpty()) {
            throw new IllegalStateException("Query without a combination operation supports only a single query");
        }
    }

    public boolean has() {
        return !this.queries.isEmpty();
    }

    public String buildSQL() {
        StringBuilder sql = new StringBuilder();
        if (this.queries.size() > 1) {
            sql.append("( ");
        }
        for (int i = 0; i < this.queries.size(); ++i) {
            if (i > 0) {
                sql.append(" ");
                sql.append(this.combineOperation);
                sql.append(" ");
            }
            sql.append(this.queries.get(i));
        }
        if (this.queries.size() > 1) {
            sql.append(" )");
        }
        return sql.toString();
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public static SQLiteMasterQuery create() {
        return new SQLiteMasterQuery(null);
    }

    public static SQLiteMasterQuery createOr() {
        return new SQLiteMasterQuery("OR");
    }

    public static SQLiteMasterQuery createAnd() {
        return new SQLiteMasterQuery("AND");
    }

    public static SQLiteMasterQuery create(SQLiteMasterColumn column, String value) {
        SQLiteMasterQuery query = SQLiteMasterQuery.create();
        query.add(column, value);
        return query;
    }

    public static SQLiteMasterQuery create(SQLiteMasterColumn column, String operation, String value) {
        SQLiteMasterQuery query = SQLiteMasterQuery.create();
        query.add(column, operation, value);
        return query;
    }

    public static SQLiteMasterQuery createOr(SQLiteMasterColumn column, Collection<String> values) {
        SQLiteMasterQuery query = SQLiteMasterQuery.createOr();
        for (String value : values) {
            query.add(column, value);
        }
        return query;
    }

    public static SQLiteMasterQuery createOr(SQLiteMasterColumn column, String operation, Collection<String> values) {
        SQLiteMasterQuery query = SQLiteMasterQuery.createOr();
        for (String value : values) {
            query.add(column, operation, value);
        }
        return query;
    }

    public static SQLiteMasterQuery createAnd(SQLiteMasterColumn column, Collection<String> values) {
        SQLiteMasterQuery query = SQLiteMasterQuery.createAnd();
        for (String value : values) {
            query.add(column, value);
        }
        return query;
    }

    public static SQLiteMasterQuery createAnd(SQLiteMasterColumn column, String operation, Collection<String> values) {
        SQLiteMasterQuery query = SQLiteMasterQuery.createAnd();
        for (String value : values) {
            query.add(column, operation, value);
        }
        return query;
    }

    public static SQLiteMasterQuery createTableViewQuery(String tableName) {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("%\"" + tableName + "\"%");
        queries.add("% " + tableName + " %");
        queries.add("%," + tableName + " %");
        queries.add("% " + tableName + ",%");
        queries.add("%," + tableName + ",%");
        queries.add("% " + tableName);
        queries.add("%," + tableName);
        return SQLiteMasterQuery.createOr(SQLiteMasterColumn.SQL, "LIKE", queries);
    }
}

