/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.ArrayEnvelope;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.geometry.SubEnvelope;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.referencing.util.TemporalAccessor;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

public class GeneralEnvelope
extends ArrayEnvelope
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3796799507279068254L;
    private static volatile Field coordinatesField;

    GeneralEnvelope(double[] coordinates) {
        super(coordinates);
    }

    public GeneralEnvelope(DirectPosition lowerCorner, DirectPosition upperCorner) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        super(lowerCorner, upperCorner);
    }

    public GeneralEnvelope(double[] lowerCorner, double[] upperCorner) throws MismatchedDimensionException {
        super(lowerCorner, upperCorner);
    }

    public GeneralEnvelope(int dimension) {
        super(dimension);
    }

    public GeneralEnvelope(CoordinateReferenceSystem crs) {
        super(crs);
    }

    public GeneralEnvelope(Envelope envelope) {
        super(envelope);
    }

    public GeneralEnvelope(GeographicBoundingBox box) {
        super(box);
    }

    public GeneralEnvelope(CharSequence wkt) throws IllegalArgumentException {
        super(wkt);
    }

    public static GeneralEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof GeneralEnvelope) {
            return (GeneralEnvelope)envelope;
        }
        return new GeneralEnvelope(envelope);
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        if (crs != null) {
            ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.getDimension(), (CoordinateReferenceSystem)crs);
            int beginIndex = this.beginIndex();
            int endIndex = this.endIndex();
            int d = this.coordinates.length >>> 1;
            for (int i = beginIndex; i < endIndex; ++i) {
                int j;
                double lower = this.coordinates[i];
                double upper = this.coordinates[i + d];
                if (!(lower > upper) || GeneralEnvelope.isWrapAround(crs, j = i - beginIndex)) continue;
                throw new IllegalStateException(GeneralEnvelope.illegalRange(crs, j, lower, upper));
            }
        }
        this.crs = crs;
    }

    @Override
    public void setRange(int dimension, double lower, double upper) throws IndexOutOfBoundsException {
        int d = this.coordinates.length >>> 1;
        ArgumentChecks.ensureValidIndex((int)d, (int)dimension);
        if (lower > upper && this.crs != null && !GeneralEnvelope.isWrapAround(this.crs, dimension)) {
            throw new IllegalArgumentException(GeneralEnvelope.illegalRange(this.crs, dimension, lower, upper));
        }
        this.coordinates[dimension + d] = upper;
        this.coordinates[dimension] = lower;
    }

    public void setEnvelope(double ... corners) {
        GeneralEnvelope.verifyArrayLength(this.coordinates.length >>> 1, corners);
        GeneralEnvelope.verifyRanges(this.crs, corners);
        System.arraycopy(corners, 0, this.coordinates, 0, this.coordinates.length);
    }

    static void verifyArrayLength(int dimension, double[] corners) {
        if ((corners.length & 1) != 0) {
            throw new IllegalArgumentException(Errors.format((short)118, (Object)corners.length));
        }
        int d = corners.length >>> 1;
        if (d != dimension) {
            throw new MismatchedDimensionException(Errors.format((short)81, (Object)"coordinates", (Object)dimension, (Object)d));
        }
    }

    public void setEnvelope(Envelope envelope) throws MismatchedDimensionException {
        if (envelope == this) {
            return;
        }
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)dimension, (Envelope)envelope);
        int d = this.coordinates.length >>> 1;
        if (envelope instanceof ArrayEnvelope) {
            double[] source = ((ArrayEnvelope)envelope).coordinates;
            int srcOffset = ((ArrayEnvelope)envelope).beginIndex();
            System.arraycopy(source, srcOffset, this.coordinates, beginIndex, dimension);
            System.arraycopy(source, srcOffset + (source.length >>> 1), this.coordinates, beginIndex + d, dimension);
        } else {
            DirectPosition lower = envelope.getLowerCorner();
            DirectPosition upper = envelope.getUpperCorner();
            for (int i = 0; i < dimension; ++i) {
                int iLower = beginIndex + i;
                int iUpper = iLower + d;
                this.coordinates[iLower] = lower.getOrdinate(i);
                this.coordinates[iUpper] = upper.getOrdinate(i);
            }
        }
        CoordinateReferenceSystem envelopeCRS = envelope.getCoordinateReferenceSystem();
        if (envelopeCRS != null) {
            this.crs = envelopeCRS;
            assert (this.crs.getCoordinateSystem().getDimension() == this.getDimension()) : this.crs;
            assert (envelope.getClass() != this.getClass() || this.equals(envelope)) : envelope;
        }
    }

    public void setToInfinite() {
        int beginIndex = this.beginIndex();
        int endIndex = this.endIndex();
        int d = this.coordinates.length >>> 1;
        Arrays.fill(this.coordinates, beginIndex, endIndex, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.coordinates, beginIndex + d, endIndex + d, Double.POSITIVE_INFINITY);
    }

    public void setToNaN() {
        Arrays.fill(this.coordinates, Double.NaN);
        assert (this.isAllNaN()) : this;
    }

    public boolean setTimeRange(Instant startTime, Instant endTime) {
        TemporalAccessor t = TemporalAccessor.of(this.crs, 0);
        if (t != null) {
            double lower = t.timeCRS.toValue(startTime);
            double upper = t.timeCRS.toValue(endTime);
            if (Double.isNaN(lower)) {
                lower = Double.NEGATIVE_INFINITY;
            }
            if (Double.isNaN(upper)) {
                upper = Double.POSITIVE_INFINITY;
            }
            this.setRange(t.dimension, lower, upper);
            return true;
        }
        return false;
    }

    public void translate(double ... vector) {
        ArgumentChecks.ensureNonNull((String)"vector", (Object)vector);
        int beginIndex = this.beginIndex();
        ArgumentChecks.ensureDimensionMatches((String)"vector", (int)(this.endIndex() - beginIndex), (double[])vector);
        int upperIndex = beginIndex + (this.coordinates.length >>> 1);
        for (int i = 0; i < vector.length; ++i) {
            double t = vector[i];
            int n = beginIndex + i;
            this.coordinates[n] = this.coordinates[n] + t;
            int n2 = upperIndex + i;
            this.coordinates[n2] = this.coordinates[n2] + t;
        }
    }

    final void addSimple(double[] array, int offset) {
        int d = this.coordinates.length >>> 1;
        for (int i = 0; i < d; ++i) {
            double value = array[offset + i];
            if (value < this.coordinates[i]) {
                this.coordinates[i] = value;
            }
            if (!(value > this.coordinates[i + d])) continue;
            this.coordinates[i + d] = value;
        }
    }

    public void add(DirectPosition position) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"position", (Object)position);
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        ArgumentChecks.ensureDimensionMatches((String)"position", (int)dimension, (DirectPosition)position);
        assert (GeneralEnvelope.assertEquals(this.crs, position.getCoordinateReferenceSystem())) : position;
        int d = this.coordinates.length >>> 1;
        for (int i = 0; i < dimension; ++i) {
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            double value = position.getOrdinate(i);
            double max = this.coordinates[iUpper];
            double min = this.coordinates[iLower];
            if (!MathFunctions.isNegative((double)(max - min))) {
                if (value < min) {
                    this.coordinates[iLower] = value;
                }
                if (!(value > max)) continue;
                this.coordinates[iUpper] = value;
                continue;
            }
            this.addToClosest(iLower, value, max, min);
        }
        assert (this.contains(position) || this.isEmpty() || GeneralEnvelope.hasNaN(position)) : position;
    }

    private void addToClosest(int i, double value, double left, double right) {
        if ((left = value - left) > 0.0 && (right -= value) > 0.0) {
            if (right > left) {
                i += this.coordinates.length >>> 1;
            }
            this.coordinates[i] = value;
        }
    }

    public void add(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)dimension, (Envelope)envelope);
        assert (GeneralEnvelope.assertEquals(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        DirectPosition lower = envelope.getLowerCorner();
        DirectPosition upper = envelope.getUpperCorner();
        int d = this.coordinates.length >>> 1;
        for (int i = 0; i < dimension; ++i) {
            double right;
            double left;
            boolean sp1;
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            double min0 = this.coordinates[iLower];
            double max0 = this.coordinates[iUpper];
            double min1 = lower.getOrdinate(i);
            double max1 = upper.getOrdinate(i);
            boolean sp0 = MathFunctions.isNegative((double)(max0 - min0));
            if (sp0 == (sp1 = MathFunctions.isNegative((double)(max1 - min1)))) {
                if (min1 < min0) {
                    this.coordinates[iLower] = min1;
                }
                if (max1 > max0) {
                    this.coordinates[iUpper] = max1;
                }
                if (!sp0 || GeneralEnvelope.isNegativeUnsafe(this.coordinates[iUpper] - this.coordinates[iLower])) {
                    continue;
                }
            } else if (sp0) {
                if (max1 <= max0 || min1 >= min0) continue;
                left = min1 - max0;
                right = min0 - max1;
                if (left > 0.0 || right > 0.0) {
                    if (left > right) {
                        this.coordinates[iLower] = min1;
                    }
                    if (!(right > left)) continue;
                    this.coordinates[iUpper] = max1;
                    continue;
                }
            } else {
                if (max0 <= max1 || min0 >= min1) {
                    this.coordinates[iLower] = min1;
                    this.coordinates[iUpper] = max1;
                    continue;
                }
                left = min0 - max1;
                right = min1 - max0;
                if (left > 0.0 || right > 0.0) {
                    if (left > right) {
                        this.coordinates[iUpper] = max1;
                    }
                    if (!(right > left)) continue;
                    this.coordinates[iLower] = min1;
                    continue;
                }
            }
            if (sp0) {
                this.coordinates[iLower] = 0.0;
                this.coordinates[iUpper] = -0.0;
                continue;
            }
            this.coordinates[iLower] = Double.NEGATIVE_INFINITY;
            this.coordinates[iUpper] = Double.POSITIVE_INFINITY;
        }
        assert (this.contains(envelope) || this.isEmpty() || GeneralEnvelope.hasNaN(envelope)) : this;
    }

    public void intersect(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)dimension, (Envelope)envelope);
        assert (GeneralEnvelope.assertEquals(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        DirectPosition lower = envelope.getLowerCorner();
        DirectPosition upper = envelope.getUpperCorner();
        int d = this.coordinates.length >>> 1;
        block5: for (int i = 0; i < dimension; ++i) {
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            double min0 = this.coordinates[iLower];
            double max0 = this.coordinates[iUpper];
            double min1 = lower.getOrdinate(i);
            double span0 = max0 - min0;
            double max1 = upper.getOrdinate(i);
            double span1 = max1 - min1;
            if (MathFunctions.isSameSign((double)span0, (double)span1)) {
                if ((min1 > max0 || max1 < min0) && !GeneralEnvelope.isNegativeUnsafe(span0)) {
                    this.coordinates[iUpper] = Double.NaN;
                    this.coordinates[iLower] = Double.NaN;
                    continue;
                }
            } else {
                if (!Double.isNaN(span0) && !Double.isNaN(span1)) {
                    int intersect = 0;
                    if (GeneralEnvelope.isNegativeUnsafe(span0)) {
                        if (min1 <= max0) {
                            intersect = 1;
                            this.coordinates[iLower] = min1;
                        }
                        if (max1 >= min0) {
                            intersect |= 2;
                            this.coordinates[iUpper] = max1;
                        }
                    } else {
                        if (min0 <= max1) {
                            intersect = 1;
                        }
                        if (max0 >= min1) {
                            intersect |= 2;
                        }
                    }
                    switch (intersect) {
                        default: {
                            throw new AssertionError(intersect);
                        }
                        case 1: {
                            if (!(max1 < max0)) continue block5;
                            this.coordinates[iUpper] = max1;
                            break;
                        }
                        case 2: {
                            if (!(min1 > min0)) continue block5;
                            this.coordinates[iLower] = min1;
                            break;
                        }
                        case 0: 
                        case 3: {
                            double max;
                            double min;
                            double cycle = GeneralEnvelope.getCycle(GeneralEnvelope.getAxis(this.crs, i));
                            if (span1 >= cycle || MathFunctions.isNegativeZero((double)span1)) {
                                min = min0;
                                max = max0;
                            } else if (span0 >= cycle || MathFunctions.isNegativeZero((double)span0)) {
                                min = min1;
                                max = max1;
                            } else {
                                min = Double.NaN;
                                max = Double.NaN;
                            }
                            this.coordinates[iLower] = min;
                            this.coordinates[iUpper] = max;
                            break;
                        }
                    }
                    continue;
                }
                if (MathFunctions.isNegative((double)span0) || MathFunctions.isNegative((double)span1)) continue;
            }
            if (min1 > min0) {
                this.coordinates[iLower] = min1;
            }
            if (!(max1 < max0)) continue;
            this.coordinates[iUpper] = max1;
        }
        assert (this.isEmpty() || GeneralEnvelope.hasNaN(envelope) || AbstractEnvelope.castOrCopy(envelope).contains(this)) : this;
    }

    public boolean normalize() {
        if (this.crs == null) {
            return false;
        }
        int beginIndex = this.beginIndex();
        return this.normalize(this.crs.getCoordinateSystem(), beginIndex, this.endIndex() - beginIndex, null);
    }

    final boolean normalize(CoordinateSystem cs, int beginIndex, int count, Iterator<Integer> dimensions) {
        boolean changed = false;
        int d = this.coordinates.length >>> 1;
        for (int j = 0; j < count; ++j) {
            double cycle;
            int i = dimensions != null ? dimensions.next() : j;
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            CoordinateSystemAxis axis = cs.getAxis(i);
            double minimum = axis.getMinimumValue();
            double maximum = axis.getMaximumValue();
            RangeMeaning rm = axis.getRangeMeaning();
            if (RangeMeaning.EXACT.equals((Object)rm)) {
                if (this.coordinates[iLower] < minimum) {
                    this.coordinates[iLower] = minimum;
                    changed = true;
                }
                if (!(this.coordinates[iUpper] > maximum)) continue;
                this.coordinates[iUpper] = maximum;
                changed = true;
                continue;
            }
            if (!RangeMeaning.WRAPAROUND.equals((Object)rm) || !((cycle = maximum - minimum) > 0.0) || !(cycle < Double.POSITIVE_INFINITY)) continue;
            double o2 = this.coordinates[iUpper];
            double o1 = this.coordinates[iLower];
            if (Math.abs(o2 - o1) >= cycle) {
                if (o1 == minimum && o2 == maximum) continue;
                if (o1 % cycle == 0.0 && o2 % cycle == 0.0) {
                    this.coordinates[iLower] = 0.0;
                    this.coordinates[iUpper] = -0.0;
                } else {
                    this.coordinates[iLower] = minimum;
                    this.coordinates[iUpper] = maximum;
                }
                changed = true;
                continue;
            }
            o1 = Math.floor((o1 - minimum) / cycle) * cycle;
            o2 = Math.floor((o2 - minimum) / cycle) * cycle;
            if (o1 != 0.0) {
                int n = iLower;
                this.coordinates[n] = this.coordinates[n] - o1;
                changed = true;
            }
            if (o2 == 0.0) continue;
            int n = iUpper;
            this.coordinates[n] = this.coordinates[n] - o2;
            changed = true;
        }
        return changed;
    }

    public boolean simplify() throws IllegalStateException {
        return this.apply(WraparoundMethod.EXPAND);
    }

    public boolean wraparound(WraparoundMethod method) throws IllegalStateException {
        switch (method) {
            case EXPAND: 
            case CONTIGUOUS: 
            case CONTIGUOUS_LOWER: 
            case CONTIGUOUS_UPPER: {
                return this.apply(method);
            }
            case NORMALIZE: {
                return this.normalize();
            }
            case NONE: {
                return false;
            }
        }
        throw new IllegalArgumentException(Errors.format((short)45, (Object)"method", (Object)((Object)method)));
    }

    private boolean apply(WraparoundMethod method) throws IllegalStateException {
        boolean changed = false;
        int d = this.coordinates.length >>> 1;
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        for (int i = 0; i < dimension; ++i) {
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            double upper = this.coordinates[iUpper];
            double lower = this.coordinates[iLower];
            if (!MathFunctions.isNegative((double)(upper - lower))) continue;
            CoordinateSystemAxis axis = GeneralEnvelope.getAxis(this.crs, i);
            if (GeneralEnvelope.isWrapAround(axis)) {
                double cycle;
                changed = true;
                double minimum = axis.getMinimumValue();
                double maximum = axis.getMaximumValue();
                if (method != WraparoundMethod.EXPAND && Double.isFinite(cycle = maximum - minimum)) {
                    boolean up;
                    cycle *= Math.ceil((lower - upper) / cycle);
                    boolean bl = up = method == WraparoundMethod.CONTIGUOUS_UPPER;
                    if (!up && method != WraparoundMethod.CONTIGUOUS_LOWER) {
                        boolean bl2 = up = upper - minimum <= maximum - lower;
                    }
                    if (up) {
                        int n = iUpper;
                        this.coordinates[n] = this.coordinates[n] + cycle;
                        continue;
                    }
                    int n = iLower;
                    this.coordinates[n] = this.coordinates[n] - cycle;
                    continue;
                }
                this.coordinates[iLower] = minimum;
                this.coordinates[iUpper] = maximum;
                continue;
            }
            throw new IllegalStateException(Errors.format((short)57, (Object)lower, (Object)upper, (Object)(axis != null ? axis.getName() : Integer.valueOf(i))));
        }
        return changed;
    }

    public GeneralEnvelope horizontal() throws IllegalStateException {
        Object name;
        if (this.crs == null) {
            throw new IllegalStateException(Errors.format((short)157));
        }
        int tgtDim = 2;
        int dimension = this.getDimension();
        if (dimension >= 2) {
            int i;
            SingleCRS singleCRS = CRS.getHorizontalComponent(this.crs);
            if (singleCRS == this.crs) {
                return this;
            }
            if (singleCRS != null && (i = AxisDirections.indexOfColinear(this.crs.getCoordinateSystem(), singleCRS.getCoordinateSystem())) >= 0) {
                GeneralEnvelope sub = this.subEnvelope(i, i + 2);
                sub.setCoordinateReferenceSystem((CoordinateReferenceSystem)singleCRS);
                return sub;
            }
        }
        if ((name = IdentifiedObjects.getDisplayName((IdentifiedObject)this.crs, null)) == null) {
            name = Integer.toString(dimension) + "D";
        }
        throw new IllegalStateException(Errors.format((short)201, (Object)name));
    }

    public GeneralEnvelope subEnvelope(int beginIndex, int endIndex) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndexRange((int)(this.coordinates.length >>> 1), (int)beginIndex, (int)endIndex);
        return new SubEnvelope(this.coordinates, beginIndex, endIndex);
    }

    public GeneralEnvelope clone() {
        try {
            Field field = coordinatesField;
            if (field == null) {
                coordinatesField = field = GeneralDirectPosition.getCoordinatesField(ArrayEnvelope.class);
            }
            GeneralEnvelope e = (GeneralEnvelope)super.clone();
            field.set(e, this.coordinates.clone());
            return e;
        }
        catch (CloneNotSupportedException | ReflectiveOperationException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

