/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import mil.nga.crs.CRSException;
import mil.nga.crs.common.UnitType;
import mil.nga.crs.operation.OperationType;

public enum OperationParameters {
    ANGLE_FROM_RECTIFIED_TO_SKEW_GRID(8814, "angle from rectified to skew grid", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, "rectified grid angle"),
    AZIMUTH_OF_INITIAL_LINE(8813, "azimuth of initial line", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, "azimuth"),
    CO_LATITUDE_OF_CONE_AXIS(1036, "co-latitude of cone axis", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, new String[0]),
    EASTING_AT_FALSE_ORIGIN(8826, "easting at false origin", OperationType.MAP_PROJECTION, UnitType.LENGTHUNIT, "false easting"),
    EASTING_AT_PROJECTION_CENTRE(8816, "easting at projection centre", OperationType.MAP_PROJECTION, UnitType.LENGTHUNIT, "false easting"),
    ELLIPSOIDAL_HEIGHT_DIFFERENCE_FILE(1058, "Ellipsoidal height difference file", OperationType.COORDINATE, new String[0]),
    FALSE_EASTING(8806, "false easting", OperationType.MAP_PROJECTION, UnitType.LENGTHUNIT, new String[0]),
    FALSE_NORTHING(8807, "false northing", OperationType.MAP_PROJECTION, UnitType.LENGTHUNIT, new String[0]),
    LATITUDE_AND_LONGITUDE_DIFFERENCE_FILE(8656, "Latitude and longitude difference file", OperationType.COORDINATE, new String[0]),
    LATITUDE_DIFFERENCE_FILE(8657, "Latitude difference file", OperationType.COORDINATE, new String[0]),
    LATITUDE_OF_1ST_STANDARD_PARALLEL(8823, "latitude of 1st standard parallel", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, "standard parallel 1"),
    LATITUDE_OF_2ND_STANDARD_PARALLEL(8824, "latitude of 2nd standard parallel", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, "standard parallel 2"),
    LATITUDE_OF_FALSE_ORIGIN(8821, "latitude of false origin", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, "latitude of origin"),
    LATITUDE_OF_NATURAL_ORIGIN(8801, "latitude of natural origin", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, "latitude of origin", "latitude of center"),
    LATITUDE_OF_PROJECTION_CENTRE(8811, "latitude of projection centre", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, new String[0]),
    LATITUDE_OF_PSEUDO_STANDARD_PARALLEL(8818, "latitude of pseudo standard parallel", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, new String[0]),
    LONGITUDE_DIFFERENCE_FILE(8658, "Longitude difference file", OperationType.COORDINATE, new String[0]),
    LONGITUDE_OF_FALSE_ORIGIN(8822, "longitude of false origin", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, "longitude of origin", "longitude of center", "central meridian"),
    LONGITUDE_OF_NATURAL_ORIGIN(8802, "longitude of natural origin", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, "longitude of origin", "longitude of center", "central meridian"),
    LONGITUDE_OF_ORIGIN(8833, "longitude of origin", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, new String[0]),
    LONGITUDE_OF_PROJECTION_CENTRE(8812, "longitude of projection centre", OperationType.MAP_PROJECTION, UnitType.ANGLEUNIT, new String[0]),
    NORTHING_AT_FALSE_ORIGIN(8827, "northing at false origin", OperationType.MAP_PROJECTION, UnitType.LENGTHUNIT, "false northing"),
    NORTHING_AT_PROJECTION_CENTRE(8817, "northing at projection centre", OperationType.MAP_PROJECTION, UnitType.LENGTHUNIT, "false northing"),
    ORDINATE_1_OF_EVALUATION_POINT(8617, "Ordinate 1 of evaluation point", OperationType.COORDINATE, new String[0]),
    ORDINATE_2_OF_EVALUATION_POINT(8618, "Ordinate 2 of evaluation point", OperationType.COORDINATE, new String[0]),
    ORDINATE_3_OF_EVALUATION_POINT(8667, "Ordinate 3 of evaluation point", OperationType.COORDINATE, new String[0]),
    SCALE_DIFFERENCE(8611, "Scale difference", OperationType.COORDINATE, "dS", "ppm"),
    SCALE_FACTOR_AT_NATURAL_ORIGIN(8805, "scale factor at natural origin", OperationType.MAP_PROJECTION, UnitType.SCALEUNIT, "scale factor"),
    SCALE_FACTOR_ON_INITIAL_LINE(8815, "scale factor on initial line", OperationType.MAP_PROJECTION, UnitType.SCALEUNIT, "scale factor"),
    SCALE_FACTOR_ON_PSEUDO_STANDARD_PARALLEL(8819, "scale factor on pseudo standard parallel", OperationType.MAP_PROJECTION, UnitType.SCALEUNIT, new String[0]),
    VERTICAL_OFFSET(8603, "Vertical Offset", OperationType.COORDINATE, "dH"),
    X_AXIS_ROTATION(8608, "X-axis rotation", OperationType.COORDINATE, "rX", "eX"),
    X_AXIS_TRANSLATION(8605, "X-axis translation", OperationType.COORDINATE, "dX", "tX"),
    Y_AXIS_ROTATION(8609, "Y-axis rotation", OperationType.COORDINATE, "rY", "eY"),
    Y_AXIS_TRANSLATION(8606, "Y-axis translation", OperationType.COORDINATE, "dY", "tY"),
    Z_AXIS_ROTATION(8610, "Z-axis rotation", OperationType.COORDINATE, "rZ", "eZ"),
    Z_AXIS_TRANSLATION(8607, "Z-axis translation", OperationType.COORDINATE, "dZ", "tZ");

    private static final Map<String, Set<OperationParameters>> aliasParameters;
    private static final Map<Integer, OperationParameters> codeParameters;
    private final int code;
    private final String name;
    private final OperationType operationType;
    private final Set<String> aliases = new LinkedHashSet<String>();
    private final UnitType unitType;

    private OperationParameters(int code, String name, OperationType operationType, String ... aliases) {
        this(code, name, operationType, (UnitType)null, aliases);
    }

    private OperationParameters(int code, String name, OperationType operationType, UnitType unitType, String ... aliases) {
        this.code = code;
        this.name = name;
        this.operationType = operationType;
        this.unitType = unitType;
        this.addAlias(name);
        for (String alias : aliases) {
            this.addAlias(alias);
        }
    }

    private void addAlias(String alias) {
        this.aliases.add(alias);
        this.aliases.add(alias.replaceAll(" ", "_"));
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public static OperationParameters getParameter(String name) {
        OperationParameters parameter = null;
        Set<OperationParameters> parameters = OperationParameters.getParameters(name);
        if (parameters != null && !parameters.isEmpty()) {
            parameter = parameters.iterator().next();
        }
        return parameter;
    }

    public static Set<OperationParameters> getParameters(String name) {
        Set<OperationParameters> parameters = null;
        if (name != null) {
            parameters = aliasParameters.get(name.toLowerCase());
        }
        return parameters;
    }

    public static OperationParameters getParameter(int code) {
        return codeParameters.get(code);
    }

    static {
        aliasParameters = new HashMap<String, Set<OperationParameters>>();
        codeParameters = new HashMap<Integer, OperationParameters>();
        for (OperationParameters parameter : OperationParameters.values()) {
            for (String alias : parameter.aliases) {
                String aliasLowerCase = alias.toLowerCase();
                Set<OperationParameters> parameterSet = aliasParameters.get(aliasLowerCase);
                if (parameterSet == null) {
                    parameterSet = new HashSet<OperationParameters>();
                    aliasParameters.put(aliasLowerCase, parameterSet);
                }
                parameterSet.add(parameter);
            }
            int code = parameter.getCode();
            if (codeParameters.containsKey(code)) {
                throw new CRSException("Duplicate configured Operation Parameter code: " + code);
            }
            codeParameters.put(code, parameter);
        }
    }
}

