/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergBuild {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergBuild.class);
    private static final String VERSION_PROPERTIES_FILE = "/iceberg-build.properties";
    private static final String UNKNOWN_DEFAULT = "unknown";
    private static volatile boolean isLoaded = false;
    private static String shortId;
    private static String commitId;
    private static String branch;
    private static List<String> tags;
    private static String version;
    private static String fullVersion;

    private IcebergBuild() {
    }

    public static void loadBuildInfo() {
        Properties buildProperties = new Properties();
        try (InputStream is = IcebergBuild.readResource(VERSION_PROPERTIES_FILE);){
            buildProperties.load(is);
        }
        catch (Exception e) {
            LOG.warn("Failed to load version properties from {}", (Object)VERSION_PROPERTIES_FILE, (Object)e);
        }
        shortId = buildProperties.getProperty("git.commit.id.abbrev", UNKNOWN_DEFAULT);
        commitId = buildProperties.getProperty("git.commit.id", UNKNOWN_DEFAULT);
        branch = buildProperties.getProperty("git.branch", UNKNOWN_DEFAULT);
        String tagList = buildProperties.getProperty("git.tags", "");
        tags = !tagList.isEmpty() ? ImmutableList.copyOf((Iterable)Splitter.on((String)",").split((CharSequence)tagList)) : ImmutableList.of();
        version = buildProperties.getProperty("git.build.version", UNKNOWN_DEFAULT);
        fullVersion = String.format("Apache Iceberg %s (commit %s)", version, commitId);
    }

    public static String gitCommitId() {
        IcebergBuild.ensureLoaded();
        return commitId;
    }

    public static String gitCommitShortId() {
        IcebergBuild.ensureLoaded();
        return shortId;
    }

    public static String gitBranch() {
        IcebergBuild.ensureLoaded();
        return branch;
    }

    public static List<String> gitTags() {
        IcebergBuild.ensureLoaded();
        return tags;
    }

    public static String version() {
        IcebergBuild.ensureLoaded();
        return version;
    }

    public static String fullVersion() {
        IcebergBuild.ensureLoaded();
        return fullVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureLoaded() {
        if (isLoaded) return;
        Class<IcebergBuild> clazz = IcebergBuild.class;
        synchronized (IcebergBuild.class) {
            if (isLoaded) return;
            IcebergBuild.loadBuildInfo();
            isLoaded = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static InputStream readResource(String resourceName) throws IOException {
        return Resources.asByteSource((URL)Resources.getResource(IcebergBuild.class, (String)resourceName)).openStream();
    }
}

