/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Privileges;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.SecurableObjects;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.BaseMetalake;
import org.apache.gravitino.meta.CatalogEntity;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.meta.SchemaVersion;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.meta.TagEntity;
import org.apache.gravitino.meta.TopicEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.storage.relational.po.CatalogPO;
import org.apache.gravitino.storage.relational.po.ExtendedGroupPO;
import org.apache.gravitino.storage.relational.po.ExtendedUserPO;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.gravitino.storage.relational.po.FilesetVersionPO;
import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.gravitino.storage.relational.po.GroupRoleRelPO;
import org.apache.gravitino.storage.relational.po.MetalakePO;
import org.apache.gravitino.storage.relational.po.OwnerRelPO;
import org.apache.gravitino.storage.relational.po.RolePO;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.gravitino.storage.relational.po.SecurableObjectPO;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.po.TagMetadataObjectRelPO;
import org.apache.gravitino.storage.relational.po.TagPO;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.gravitino.storage.relational.po.UserRoleRelPO;
import org.apache.gravitino.utils.PrincipalUtils;

public class POConverters {
    private static final long INIT_VERSION = 1L;
    private static final long DEFAULT_DELETED_AT = 0L;

    private POConverters() {
    }

    public static MetalakePO initializeMetalakePOWithVersion(BaseMetalake baseMetalake) {
        try {
            return MetalakePO.builder().withMetalakeId(baseMetalake.id()).withMetalakeName(baseMetalake.name()).withMetalakeComment(baseMetalake.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(baseMetalake.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)baseMetalake.auditInfo())).withSchemaVersion(JsonUtils.anyFieldMapper().writeValueAsString((Object)baseMetalake.getVersion())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static MetalakePO updateMetalakePOWithVersion(MetalakePO oldMetalakePO, BaseMetalake newMetalake) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldMetalakePO.getLastVersion();
        try {
            return MetalakePO.builder().withMetalakeId(newMetalake.id()).withMetalakeName(newMetalake.name()).withMetalakeComment(newMetalake.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newMetalake.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newMetalake.auditInfo())).withSchemaVersion(JsonUtils.anyFieldMapper().writeValueAsString((Object)newMetalake.getVersion())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static BaseMetalake fromMetalakePO(MetalakePO metalakePO) {
        try {
            return BaseMetalake.builder().withId(metalakePO.getMetalakeId()).withName(metalakePO.getMetalakeName()).withComment(metalakePO.getMetalakeComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(metalakePO.getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(metalakePO.getAuditInfo(), AuditInfo.class)).withVersion((SchemaVersion)((Object)JsonUtils.anyFieldMapper().readValue(metalakePO.getSchemaVersion(), SchemaVersion.class))).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<BaseMetalake> fromMetalakePOs(List<MetalakePO> metalakePOs) {
        return metalakePOs.stream().map(POConverters::fromMetalakePO).collect(Collectors.toList());
    }

    public static CatalogPO initializeCatalogPOWithVersion(CatalogEntity catalogEntity, Long metalakeId) {
        try {
            return CatalogPO.builder().withCatalogId(catalogEntity.id()).withCatalogName(catalogEntity.name()).withMetalakeId(metalakeId).withType(catalogEntity.getType().name()).withProvider(catalogEntity.getProvider()).withCatalogComment(catalogEntity.getComment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(catalogEntity.getProperties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)catalogEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static CatalogPO updateCatalogPOWithVersion(CatalogPO oldCatalogPO, CatalogEntity newCatalog, Long metalakeId) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldCatalogPO.getLastVersion();
        try {
            return CatalogPO.builder().withCatalogId(newCatalog.id()).withCatalogName(newCatalog.name()).withMetalakeId(metalakeId).withType(newCatalog.getType().name()).withProvider(newCatalog.getProvider()).withCatalogComment(newCatalog.getComment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newCatalog.getProperties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newCatalog.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static CatalogEntity fromCatalogPO(CatalogPO catalogPO, Namespace namespace) {
        try {
            return CatalogEntity.builder().withId(catalogPO.getCatalogId()).withName(catalogPO.getCatalogName()).withNamespace(namespace).withType(Catalog.Type.valueOf((String)catalogPO.getType())).withProvider(catalogPO.getProvider()).withComment(catalogPO.getCatalogComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(catalogPO.getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(catalogPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<CatalogEntity> fromCatalogPOs(List<CatalogPO> catalogPOs, Namespace namespace) {
        return catalogPOs.stream().map(catalogPO -> POConverters.fromCatalogPO(catalogPO, namespace)).collect(Collectors.toList());
    }

    public static SchemaPO initializeSchemaPOWithVersion(SchemaEntity schemaEntity, SchemaPO.Builder builder) {
        try {
            return builder.withSchemaId(schemaEntity.id()).withSchemaName(schemaEntity.name()).withSchemaComment(schemaEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(schemaEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)schemaEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static SchemaPO updateSchemaPOWithVersion(SchemaPO oldSchemaPO, SchemaEntity newSchema) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldSchemaPO.getLastVersion();
        try {
            return SchemaPO.builder().withSchemaId(oldSchemaPO.getSchemaId()).withSchemaName(newSchema.name()).withMetalakeId(oldSchemaPO.getMetalakeId()).withCatalogId(oldSchemaPO.getCatalogId()).withSchemaComment(newSchema.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newSchema.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newSchema.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static SchemaEntity fromSchemaPO(SchemaPO schemaPO, Namespace namespace) {
        try {
            return SchemaEntity.builder().withId(schemaPO.getSchemaId()).withName(schemaPO.getSchemaName()).withNamespace(namespace).withComment(schemaPO.getSchemaComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(schemaPO.getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(schemaPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<SchemaEntity> fromSchemaPOs(List<SchemaPO> schemaPOs, Namespace namespace) {
        return schemaPOs.stream().map(schemaPO -> POConverters.fromSchemaPO(schemaPO, namespace)).collect(Collectors.toList());
    }

    public static TablePO initializeTablePOWithVersion(TableEntity tableEntity, TablePO.Builder builder) {
        try {
            return builder.withTableId(tableEntity.id()).withTableName(tableEntity.name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)tableEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TablePO updateTablePOWithVersion(TablePO oldTablePO, TableEntity newTable) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldTablePO.getLastVersion();
        try {
            return TablePO.builder().withTableId(oldTablePO.getTableId()).withTableName(newTable.name()).withMetalakeId(oldTablePO.getMetalakeId()).withCatalogId(oldTablePO.getCatalogId()).withSchemaId(oldTablePO.getSchemaId()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newTable.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TableEntity fromTablePO(TablePO tablePO, Namespace namespace) {
        try {
            return TableEntity.builder().withId(tablePO.getTableId()).withName(tablePO.getTableName()).withNamespace(namespace).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(tablePO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<TableEntity> fromTablePOs(List<TablePO> tablePOs, Namespace namespace) {
        return tablePOs.stream().map(tablePO -> POConverters.fromTablePO(tablePO, namespace)).collect(Collectors.toList());
    }

    public static FilesetPO initializeFilesetPOWithVersion(FilesetEntity filesetEntity, FilesetPO.Builder builder) {
        try {
            FilesetVersionPO filesetVersionPO = FilesetVersionPO.builder().withMetalakeId(builder.getFilesetMetalakeId()).withCatalogId(builder.getFilesetCatalogId()).withSchemaId(builder.getFilesetSchemaId()).withFilesetId(filesetEntity.id()).withVersion(1L).withFilesetComment(filesetEntity.comment()).withStorageLocation(filesetEntity.storageLocation()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(filesetEntity.properties())).withDeletedAt(0L).build();
            return builder.withFilesetId(filesetEntity.id()).withFilesetName(filesetEntity.name()).withType(filesetEntity.filesetType().name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)filesetEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).withFilesetVersionPO(filesetVersionPO).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static FilesetPO updateFilesetPOWithVersion(FilesetPO oldFilesetPO, FilesetEntity newFileset, boolean needUpdateVersion) {
        try {
            FilesetVersionPO newFilesetVersionPO;
            Long currentVersion;
            Long lastVersion = oldFilesetPO.getLastVersion();
            if (needUpdateVersion) {
                Long l = lastVersion;
                Long l2 = lastVersion = Long.valueOf(lastVersion + 1L);
                currentVersion = lastVersion;
                newFilesetVersionPO = FilesetVersionPO.builder().withMetalakeId(oldFilesetPO.getMetalakeId()).withCatalogId(oldFilesetPO.getCatalogId()).withSchemaId(oldFilesetPO.getSchemaId()).withFilesetId(newFileset.id()).withVersion(currentVersion).withFilesetComment(newFileset.comment()).withStorageLocation(newFileset.storageLocation()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newFileset.properties())).withDeletedAt(0L).build();
            } else {
                currentVersion = oldFilesetPO.getCurrentVersion();
                newFilesetVersionPO = oldFilesetPO.getFilesetVersionPO();
            }
            return FilesetPO.builder().withFilesetId(newFileset.id()).withFilesetName(newFileset.name()).withMetalakeId(oldFilesetPO.getMetalakeId()).withCatalogId(oldFilesetPO.getCatalogId()).withSchemaId(oldFilesetPO.getSchemaId()).withType(newFileset.filesetType().name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newFileset.auditInfo())).withCurrentVersion(currentVersion).withLastVersion(lastVersion).withDeletedAt(0L).withFilesetVersionPO(newFilesetVersionPO).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static boolean checkFilesetVersionNeedUpdate(FilesetVersionPO oldFilesetVersionPO, FilesetEntity newFileset) {
        if (!StringUtils.equals((CharSequence)oldFilesetVersionPO.getFilesetComment(), (CharSequence)newFileset.comment()) || !StringUtils.equals((CharSequence)oldFilesetVersionPO.getStorageLocation(), (CharSequence)newFileset.storageLocation())) {
            return true;
        }
        try {
            Map oldProperties = (Map)JsonUtils.anyFieldMapper().readValue(oldFilesetVersionPO.getProperties(), Map.class);
            if (oldProperties == null) {
                return newFileset.properties() != null;
            }
            return !oldProperties.equals(newFileset.properties());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static FilesetEntity fromFilesetPO(FilesetPO filesetPO, Namespace namespace) {
        try {
            return FilesetEntity.builder().withId(filesetPO.getFilesetId()).withName(filesetPO.getFilesetName()).withNamespace(namespace).withComment(filesetPO.getFilesetVersionPO().getFilesetComment()).withFilesetType(Fileset.Type.valueOf((String)filesetPO.getType())).withStorageLocation(filesetPO.getFilesetVersionPO().getStorageLocation()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(filesetPO.getFilesetVersionPO().getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(filesetPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static TopicEntity fromTopicPO(TopicPO topicPO, Namespace namespace) {
        try {
            return TopicEntity.builder().withId(topicPO.getTopicId()).withName(topicPO.getTopicName()).withNamespace(namespace).withComment(topicPO.getComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(topicPO.getProperties(), Map.class)).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(topicPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<FilesetEntity> fromFilesetPOs(List<FilesetPO> filesetPOs, Namespace namespace) {
        return filesetPOs.stream().map(filesetPO -> POConverters.fromFilesetPO(filesetPO, namespace)).collect(Collectors.toList());
    }

    public static List<TopicEntity> fromTopicPOs(List<TopicPO> topicPOs, Namespace namespace) {
        return topicPOs.stream().map(topicPO -> POConverters.fromTopicPO(topicPO, namespace)).collect(Collectors.toList());
    }

    public static TopicPO initializeTopicPOWithVersion(TopicEntity topicEntity, TopicPO.Builder builder) {
        try {
            return builder.withTopicId(topicEntity.id()).withTopicName(topicEntity.name()).withComment(topicEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(topicEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)topicEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TopicPO updateTopicPOWithVersion(TopicPO oldTopicPO, TopicEntity newEntity) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldTopicPO.getLastVersion();
        try {
            return TopicPO.builder().withTopicId(oldTopicPO.getTopicId()).withTopicName(newEntity.name()).withMetalakeId(oldTopicPO.getMetalakeId()).withCatalogId(oldTopicPO.getCatalogId()).withSchemaId(oldTopicPO.getSchemaId()).withComment(newEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newEntity.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static UserPO initializeUserPOWithVersion(UserEntity userEntity, UserPO.Builder builder) {
        try {
            return builder.withUserId(userEntity.id()).withUserName(userEntity.name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)userEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static UserPO updateUserPOWithVersion(UserPO oldUserPO, UserEntity newUser) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldUserPO.getLastVersion();
        try {
            return UserPO.builder().withUserId(oldUserPO.getUserId()).withUserName(newUser.name()).withMetalakeId(oldUserPO.getMetalakeId()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newUser.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static UserEntity fromUserPO(UserPO userPO, List<RolePO> rolePOs, Namespace namespace) {
        try {
            List<String> roleNames = rolePOs.stream().map(RolePO::getRoleName).collect(Collectors.toList());
            List<Long> roleIds = rolePOs.stream().map(RolePO::getRoleId).collect(Collectors.toList());
            UserEntity.Builder builder = UserEntity.builder().withId(userPO.getUserId()).withName(userPO.getUserName()).withNamespace(namespace).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(userPO.getAuditInfo(), AuditInfo.class));
            if (!roleNames.isEmpty()) {
                builder.withRoleNames(roleNames);
            }
            if (!roleIds.isEmpty()) {
                builder.withRoleIds(roleIds);
            }
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static UserEntity fromExtendedUserPO(ExtendedUserPO userPO, Namespace namespace) {
        try {
            List roleIdsFromJson;
            List<Long> roleIds;
            List roleNamesFromJson;
            List<String> roleNames;
            UserEntity.Builder builder = UserEntity.builder().withId(userPO.getUserId()).withName(userPO.getUserName()).withNamespace(namespace).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(userPO.getAuditInfo(), AuditInfo.class));
            if (StringUtils.isNotBlank((CharSequence)userPO.getRoleNames()) && !(roleNames = (roleNamesFromJson = (List)JsonUtils.anyFieldMapper().readValue(userPO.getRoleNames(), List.class)).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList())).isEmpty()) {
                builder.withRoleNames(roleNames);
            }
            if (StringUtils.isNotBlank((CharSequence)userPO.getRoleIds()) && !(roleIds = (roleIdsFromJson = (List)JsonUtils.anyFieldMapper().readValue(userPO.getRoleIds(), List.class)).stream().filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList())).isEmpty()) {
                builder.withRoleIds(roleIds);
            }
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static GroupEntity fromGroupPO(GroupPO groupPO, List<RolePO> rolePOs, Namespace namespace) {
        try {
            List<String> roleNames = rolePOs.stream().map(RolePO::getRoleName).collect(Collectors.toList());
            List<Long> roleIds = rolePOs.stream().map(RolePO::getRoleId).collect(Collectors.toList());
            GroupEntity.Builder builder = GroupEntity.builder().withId(groupPO.getGroupId()).withName(groupPO.getGroupName()).withNamespace(namespace).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(groupPO.getAuditInfo(), AuditInfo.class));
            if (!roleNames.isEmpty()) {
                builder.withRoleNames(roleNames);
            }
            if (!roleIds.isEmpty()) {
                builder.withRoleIds(roleIds);
            }
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static GroupEntity fromExtendedGroupPO(ExtendedGroupPO groupPO, Namespace namespace) {
        try {
            List roleIdsFromJson;
            List<Long> roleIds;
            List roleNamesFromJson;
            List<String> roleNames;
            GroupEntity.Builder builder = GroupEntity.builder().withId(groupPO.getGroupId()).withName(groupPO.getGroupName()).withNamespace(namespace).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(groupPO.getAuditInfo(), AuditInfo.class));
            if (StringUtils.isNotBlank((CharSequence)groupPO.getRoleNames()) && !(roleNames = (roleNamesFromJson = (List)JsonUtils.anyFieldMapper().readValue(groupPO.getRoleNames(), List.class)).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList())).isEmpty()) {
                builder.withRoleNames(roleNames);
            }
            if (StringUtils.isNotBlank((CharSequence)groupPO.getRoleIds()) && !(roleIds = (roleIdsFromJson = (List)JsonUtils.anyFieldMapper().readValue(groupPO.getRoleIds(), List.class)).stream().filter(Objects::nonNull).map(String::valueOf).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList())).isEmpty()) {
                builder.withRoleIds(roleIds);
            }
            return builder.build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static List<UserRoleRelPO> initializeUserRoleRelsPOWithVersion(UserEntity userEntity, List<Long> roleIds) {
        try {
            ArrayList userRoleRelPOs = Lists.newArrayList();
            for (Long roleId : roleIds) {
                UserRoleRelPO roleRelPO = UserRoleRelPO.builder().withUserId(userEntity.id()).withRoleId(roleId).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)userEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
                userRoleRelPOs.add(roleRelPO);
            }
            return userRoleRelPOs;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static RolePO initializeRolePOWithVersion(RoleEntity roleEntity, RolePO.Builder builder) {
        try {
            return builder.withRoleId(roleEntity.id()).withRoleName(roleEntity.name()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(roleEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)roleEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static GroupPO initializeGroupPOWithVersion(GroupEntity groupEntity, GroupPO.Builder builder) {
        try {
            return builder.withGroupId(groupEntity.id()).withGroupName(groupEntity.name()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)groupEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static GroupPO updateGroupPOWithVersion(GroupPO oldGroupPO, GroupEntity newGroup) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldGroupPO.getLastVersion();
        try {
            return GroupPO.builder().withGroupId(oldGroupPO.getGroupId()).withGroupName(newGroup.name()).withMetalakeId(oldGroupPO.getMetalakeId()).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newGroup.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static List<GroupRoleRelPO> initializeGroupRoleRelsPOWithVersion(GroupEntity groupEntity, List<Long> roleIds) {
        try {
            ArrayList groupRoleRelPOS = Lists.newArrayList();
            for (Long roleId : roleIds) {
                GroupRoleRelPO roleRelPO = GroupRoleRelPO.builder().withGroupId(groupEntity.id()).withRoleId(roleId).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)groupEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
                groupRoleRelPOS.add(roleRelPO);
            }
            return groupRoleRelPOS;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static SecurableObject fromSecurableObjectPO(String fullName, SecurableObjectPO securableObjectPO, MetadataObject.Type type) {
        try {
            List privilegeNames = (List)JsonUtils.anyFieldMapper().readValue(securableObjectPO.getPrivilegeNames(), List.class);
            List privilegeConditions = (List)JsonUtils.anyFieldMapper().readValue(securableObjectPO.getPrivilegeConditions(), List.class);
            ArrayList privileges = Lists.newArrayList();
            for (int index = 0; index < privilegeNames.size(); ++index) {
                if (Privilege.Condition.ALLOW.name().equals(privilegeConditions.get(index))) {
                    privileges.add(Privileges.allow((String)((String)privilegeNames.get(index))));
                    continue;
                }
                privileges.add(Privileges.deny((String)((String)privilegeNames.get(index))));
            }
            return SecurableObjects.parse((String)fullName, (MetadataObject.Type)type, (List)privileges);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static RoleEntity fromRolePO(RolePO rolePO, List<SecurableObject> securableObjects, Namespace namespace) {
        try {
            return RoleEntity.builder().withId(rolePO.getRoleId()).withName(rolePO.getRoleName()).withNamespace(namespace).withProperties((Map)JsonUtils.anyFieldMapper().readValue(rolePO.getProperties(), Map.class)).withSecurableObjects(securableObjects).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(rolePO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static SecurableObjectPO.Builder initializeSecurablePOBuilderWithVersion(long roleId, SecurableObject securableObject, String type) {
        try {
            SecurableObjectPO.Builder builder = SecurableObjectPO.builder();
            builder.withRoleId(roleId).withType(type).withPrivilegeConditions(JsonUtils.anyFieldMapper().writeValueAsString(securableObject.privileges().stream().map(Privilege::condition).map(Enum::name).collect(Collectors.toList()))).withPrivilegeNames(JsonUtils.anyFieldMapper().writeValueAsString(securableObject.privileges().stream().map(Privilege::name).map(Enum::name).collect(Collectors.toList()))).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L);
            return builder;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static RolePO updateRolePOWithVersion(RolePO oldRolePO, RoleEntity newRole) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldRolePO.getLastVersion();
        try {
            return RolePO.builder().withRoleId(oldRolePO.getRoleId()).withRoleName(newRole.name()).withMetalakeId(oldRolePO.getMetalakeId()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newRole.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newRole.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TagEntity fromTagPO(TagPO tagPO, Namespace namespace) {
        try {
            return TagEntity.builder().withId(tagPO.getTagId()).withName(tagPO.getTagName()).withNamespace(namespace).withComment(tagPO.getComment()).withProperties((Map)JsonUtils.anyFieldMapper().readValue(tagPO.getProperties(), Map.class)).withAuditInfo((Audit)JsonUtils.anyFieldMapper().readValue(tagPO.getAuditInfo(), AuditInfo.class)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json object:", e);
        }
    }

    public static TagPO initializeTagPOWithVersion(TagEntity tagEntity, TagPO.Builder builder) {
        try {
            return builder.withTagId(tagEntity.id()).withTagName(tagEntity.name()).withComment(tagEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(tagEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)tagEntity.auditInfo())).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TagPO updateTagPOWithVersion(TagPO oldTagPO, TagEntity newEntity) {
        Long lastVersion;
        Long nextVersion = lastVersion = oldTagPO.getLastVersion();
        try {
            return TagPO.builder().withTagId(oldTagPO.getTagId()).withTagName(newEntity.name()).withMetalakeId(oldTagPO.getMetalakeId()).withComment(newEntity.comment()).withProperties(JsonUtils.anyFieldMapper().writeValueAsString(newEntity.properties())).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)newEntity.auditInfo())).withCurrentVersion(nextVersion).withLastVersion(nextVersion).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static TagMetadataObjectRelPO initializeTagMetadataObjectRelPOWithVersion(Long tagId, Long metadataObjectId, String metadataObjectType) {
        try {
            AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
            return TagMetadataObjectRelPO.builder().withTagId(tagId).withMetadataObjectId(metadataObjectId).withMetadataObjectType(metadataObjectType).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)auditInfo)).withCurrentVersion(1L).withLastVersion(1L).withDeletedAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }

    public static OwnerRelPO initializeOwnerRelPOsWithVersion(Long metalakeId, String ownerType, Long ownerId, String metadataObjectType, Long metadataObjectId) {
        try {
            AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
            return OwnerRelPO.builder().withMetalakeId(metalakeId).withOwnerId(ownerId).withOwnerType(ownerType).withMetadataObjectId(metadataObjectId).withMetadataObjectType(metadataObjectType).withAuditIfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)auditInfo)).withCurrentVersion(1L).withLastVersion(1L).withDeleteAt(0L).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize json object:", e);
        }
    }
}

