/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.TransformerException;
import java.security.ProtectionDomain;
import java.util.Map;
import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.ClassReader;
import org.eclipse.persistence.asm.ClassVisitor;
import org.eclipse.persistence.asm.ClassWriter;
import org.eclipse.persistence.asm.EclipseLinkClassReader;
import org.eclipse.persistence.asm.SerialVersionUIDAdder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassWeaver;
import org.eclipse.persistence.internal.jpa.weaving.ComputeClassWriter;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;

public class PersistenceWeaver
implements ClassTransformer {
    protected Map<String, ClassDetails> classDetailsMap;

    public PersistenceWeaver(Map<String, ClassDetails> classDetailsMap) {
        this.classDetailsMap = classDetailsMap;
    }

    public void clear() {
        this.classDetailsMap = null;
    }

    public Map<String, ClassDetails> getClassDetailsMap() {
        return this.classDetailsMap;
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws TransformerException {
        boolean shouldLogFinest;
        SessionLog log;
        block22: {
            log = AbstractSessionLog.getLog();
            shouldLogFinest = log.shouldLog(1, "weaver");
            Map<String, ClassDetails> classDetailsMap = this.classDetailsMap;
            if (classDetailsMap == null) {
                return null;
            }
            try {
                ClassDetails classDetails = classDetailsMap.get(Helper.toSlashedClassName((String)className));
                if (classDetails != null) {
                    if (shouldLogFinest) {
                        log.log(1, "weaver", "begin_weaving_class", (Object)className);
                    }
                    ClassReader classReader = null;
                    try {
                        classReader = ASMFactory.createClassReader((byte[])classfileBuffer);
                    }
                    catch (IllegalArgumentException iae) {
                        classReader = new EclipseLinkClassReader(classfileBuffer);
                    }
                    String reflectiveIntrospectionProperty = PrivilegedAccessHelper.getSystemProperty((String)"eclipselink.weaving.reflective-introspection");
                    ClassWriter classWriter = null;
                    if (reflectiveIntrospectionProperty != null) {
                        classWriter = ASMFactory.createClassWriter((int)ClassWriter.valueInt((String)"COMPUTE_FRAMES"));
                    } else {
                        classWriter = new ComputeClassWriter(loader, ClassWriter.valueInt((String)"COMPUTE_FRAMES"));
                        classWriter.setCustomClassWriterInImpl(classWriter);
                    }
                    ClassWeaver classWeaver = new ClassWeaver((ClassVisitor)classWriter, classDetails);
                    SerialVersionUIDAdder sv = ASMFactory.createSerialVersionUIDAdder((ClassVisitor)classWeaver);
                    classReader.accept((ClassVisitor)sv, 0);
                    if (classWeaver.alreadyWeaved) {
                        if (shouldLogFinest) {
                            log.log(1, "weaver", "end_weaving_class", (Object)className);
                        }
                        return null;
                    }
                    if (classWeaver.weaved) {
                        byte[] bytes = classWriter.toByteArray();
                        String outputPath = PrivilegedAccessHelper.getSystemProperty((String)"eclipselink.weaving.output.path", (String)"");
                        if (!outputPath.equals("")) {
                            Helper.outputClassFile((String)className, (byte[])bytes, (String)outputPath);
                        }
                        if (shouldLogFinest) {
                            if (classWeaver.weavedPersistenceEntity) {
                                log.log(1, "weaver", "weaved_persistenceentity", (Object)className);
                            }
                            if (classWeaver.weavedChangeTracker) {
                                log.log(1, "weaver", "weaved_changetracker", (Object)className);
                            }
                            if (classWeaver.weavedLazy) {
                                log.log(1, "weaver", "weaved_lazy", (Object)className);
                            }
                            if (classWeaver.weavedFetchGroups) {
                                log.log(1, "weaver", "weaved_fetchgroups", (Object)className);
                            }
                            if (classWeaver.weavedRest) {
                                log.log(1, "weaver", "weaved_rest", (Object)className);
                            }
                            log.log(1, "weaver", "end_weaving_class", (Object)className);
                        }
                        return bytes;
                    }
                    if (shouldLogFinest) {
                        log.log(1, "weaver", "end_weaving_class", (Object)className);
                    }
                    break block22;
                }
                if (shouldLogFinest) {
                    log.log(1, "weaver", "transform_missing_class_details", (Object)className);
                }
            }
            catch (Throwable exception) {
                if (!log.shouldLog(6, "weaver")) break block22;
                log.log(6, "weaver", "exception_while_weaving", new Object[]{className, exception.getLocalizedMessage()});
                if (!shouldLogFinest) break block22;
                log.logThrowable(1, "weaver", exception);
            }
        }
        if (shouldLogFinest) {
            log.log(1, "weaver", "transform_existing_class_bytes", (Object)className);
        }
        return null;
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

