/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.provider.ducument;

import com.usthe.sureness.provider.DefaultAccount;
import com.usthe.sureness.provider.SurenessAccount;
import com.usthe.sureness.provider.SurenessAccountProvider;
import com.usthe.sureness.provider.ducument.DocumentResourceAccess;
import com.usthe.sureness.provider.ducument.DocumentResourceEntity;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentAccountProvider
implements SurenessAccountProvider {
    private static final Logger logger = LoggerFactory.getLogger(DocumentAccountProvider.class);
    private static final String CREDENTIAL = "credential";
    private static final String SALT = "salt";
    private static final String ROLE = "role";
    private DocumentResourceEntity entity;

    @Override
    public SurenessAccount loadAccount(String appId) {
        if (appId == null) {
            return null;
        }
        try {
            if (this.entity == null) {
                this.entity = DocumentResourceAccess.loadConfig();
            }
            Optional<Map> mapOptional = this.entity.getAccount().stream().filter(map -> appId.equals(map.get("appId"))).findFirst();
            DefaultAccount.Builder builder = new DefaultAccount.Builder(appId);
            if (mapOptional.isPresent()) {
                Map accountMap = mapOptional.get();
                if (accountMap.get(CREDENTIAL) != null) {
                    builder.setPassword(String.valueOf(accountMap.get(CREDENTIAL)));
                }
                if (accountMap.get(SALT) != null) {
                    builder.setSalt(String.valueOf(accountMap.get(SALT)));
                }
                if (accountMap.get(ROLE) != null) {
                    builder.setOwnRoles((List)accountMap.get(ROLE));
                }
                builder.setDisabledAccount(Boolean.FALSE).setExcessiveAttempts(Boolean.FALSE);
                return builder.build();
            }
        }
        catch (IOException e) {
            logger.error("load config data from yaml file error: ", (Throwable)e);
        }
        return null;
    }
}

