/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import org.springframework.util.Assert;

@FunctionalInterface
public interface SpanExporters
extends Iterable<SpanExporter> {
    public List<SpanExporter> list();

    @Override
    default public Iterator<SpanExporter> iterator() {
        return this.list().iterator();
    }

    @Override
    default public Spliterator<SpanExporter> spliterator() {
        return this.list().spliterator();
    }

    public static SpanExporters of(SpanExporter ... spanExporters) {
        return SpanExporters.of(Arrays.asList(spanExporters));
    }

    public static SpanExporters of(Collection<? extends SpanExporter> spanExporters) {
        Assert.notNull(spanExporters, (String)"SpanExporters must not be null");
        List<? extends SpanExporter> copy = List.copyOf(spanExporters);
        return () -> copy;
    }
}

