/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client;

import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.topic.TopicValidator;

public class Validators {
    public static final int CHARACTER_MAX_LENGTH = 255;
    public static final int TOPIC_MAX_LENGTH = 127;

    public static void checkGroup(String group) throws MQClientException {
        if (UtilAll.isBlank((String)group)) {
            throw new MQClientException("the specified group is blank", null);
        }
        if (group.length() > 255) {
            throw new MQClientException("the specified group is longer than group max length 255.", null);
        }
        if (TopicValidator.isTopicOrGroupIllegal((String)group)) {
            throw new MQClientException(String.format("the specified group[%s] contains illegal characters, allowing only %s", group, "^[%|a-zA-Z0-9_-]+$"), null);
        }
    }

    public static void checkMessage(Message msg, DefaultMQProducer defaultMQProducer) throws MQClientException {
        if (null == msg) {
            throw new MQClientException(13, "the message is null");
        }
        Validators.checkTopic(msg.getTopic());
        Validators.isNotAllowedSendTopic(msg.getTopic());
        if (null == msg.getBody()) {
            throw new MQClientException(13, "the message body is null");
        }
        if (0 == msg.getBody().length) {
            throw new MQClientException(13, "the message body length is zero");
        }
        if (msg.getBody().length > defaultMQProducer.getMaxMessageSize()) {
            throw new MQClientException(13, "the message body size over max value, MAX: " + defaultMQProducer.getMaxMessageSize());
        }
    }

    public static void checkTopic(String topic) throws MQClientException {
        if (UtilAll.isBlank((String)topic)) {
            throw new MQClientException("The specified topic is blank", null);
        }
        if (topic.length() > 127) {
            throw new MQClientException(String.format("The specified topic is longer than topic max length %d.", 127), null);
        }
        if (TopicValidator.isTopicOrGroupIllegal((String)topic)) {
            throw new MQClientException(String.format("The specified topic[%s] contains illegal characters, allowing only %s", topic, "^[%|a-zA-Z0-9_-]+$"), null);
        }
    }

    public static void isSystemTopic(String topic) throws MQClientException {
        if (TopicValidator.isSystemTopic((String)topic)) {
            throw new MQClientException(String.format("The topic[%s] is conflict with system topic.", topic), null);
        }
    }

    public static void isNotAllowedSendTopic(String topic) throws MQClientException {
        if (TopicValidator.isNotAllowedSendTopic((String)topic)) {
            throw new MQClientException(String.format("Sending message to topic[%s] is forbidden.", topic), null);
        }
    }
}

