/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.util.concurrent.CancellationException;
import org.apache.http.client.methods.HttpRequestBase;

public class Cancellable {
    static final Cancellable NO_OP = new Cancellable(null){

        @Override
        public void cancel() {
        }

        @Override
        void runIfNotCancelled(Runnable runnable) {
            throw new UnsupportedOperationException();
        }
    };
    private final HttpRequestBase httpRequest;

    static Cancellable fromRequest(HttpRequestBase httpRequest) {
        return new Cancellable(httpRequest);
    }

    private Cancellable(HttpRequestBase httpRequest) {
        this.httpRequest = httpRequest;
    }

    public synchronized void cancel() {
        this.httpRequest.abort();
    }

    synchronized void runIfNotCancelled(Runnable runnable) {
        if (this.httpRequest.isAborted()) {
            throw Cancellable.newCancellationException();
        }
        runnable.run();
    }

    static CancellationException newCancellationException() {
        return new CancellationException("request was cancelled");
    }
}

