/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.server.porcessor;

import com.xiaomi.data.push.context.AgentContext;
import com.xiaomi.data.push.rpc.common.RemotingHelper;
import com.xiaomi.data.push.rpc.netty.AgentChannel;
import com.xiaomi.data.push.rpc.netty.NettyRequestProcessor;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.model.meta.AppLogMeta;
import org.apache.ozhera.log.api.model.vo.PingReq;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.server.common.ServerConstant;
import org.apache.ozhera.log.server.common.Version;
import org.apache.ozhera.log.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(PingProcessor.class);
    public static Map<String, Long> agentHeartTimeStampMap = new ConcurrentHashMap<String, Long>(1024);
    private static Version version = new Version();
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS");

    public RemotingCommand processRequest(ChannelHandlerContext channelHandlerContext, RemotingCommand remotingCommand) {
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr((Channel)channelHandlerContext.channel());
        RemotingCommand response = RemotingCommand.createResponseCommand((int)1002);
        String body = new String(remotingCommand.getBody());
        PingReq pr = (PingReq)Constant.GSON.fromJson(body, PingReq.class);
        AgentChannel ch = (AgentChannel)AgentContext.ins().map.get(remoteAddress);
        if (null != ch) {
            ch.setIp(pr.getIp());
        }
        String requestBody = String.format("%s->%s->%s:%s->%s", version.toString(), this.dateTimeFormatter.format(LocalDateTime.now()), NetUtil.getLocalIp(), ServerConstant.SERVER_PORT, remoteAddress);
        response.setBody(requestBody.getBytes());
        if (null != pr && StringUtils.isNotBlank((CharSequence)pr.getIp())) {
            agentHeartTimeStampMap.put(pr.getIp(), Instant.now().toEpochMilli());
        }
        if (pr.getMessage().equals("load")) {
            AppLogMeta meta = new AppLogMeta();
            meta.setAppName("log-manager");
            meta.setAppId(Long.valueOf(ThreadLocalRandom.current().nextLong()));
            response.setBody(Constant.GSON.toJson((Object)meta).getBytes());
        }
        return response;
    }

    public boolean rejectRequest() {
        return false;
    }
}

