/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.file.listener;

import com.xiaomi.mone.file.LogFile2;
import com.xiaomi.mone.file.ReadEvent;
import com.xiaomi.mone.file.ReadListener;
import com.xiaomi.mone.file.common.SafeRun;
import com.xiaomi.mone.file.event.EventListener;
import com.xiaomi.mone.file.event.EventType;
import com.xiaomi.mone.file.event.FileEvent;
import com.xiaomi.mone.file.listener.OzHeraReadListener;
import com.xiaomi.mone.file.ozhera.HeraFileMonitor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMonitorListener
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultMonitorListener.class);
    private HeraFileMonitor monitor;
    private Consumer<ReadEvent> consumer;
    private Map<Object, ReadListener> readListenerMap = new ConcurrentHashMap<Object, ReadListener>();
    private ExecutorService pool = Executors.newVirtualThreadPerTaskExecutor();

    public DefaultMonitorListener(HeraFileMonitor monitor, Consumer<ReadEvent> consumer) {
        this.monitor = monitor;
        this.consumer = consumer;
    }

    @Override
    public void onEvent(FileEvent event) {
        OzHeraReadListener ozHeraReadListener;
        LogFile2 logFile;
        if (event.getType().equals((Object)EventType.init)) {
            log.info("log file:{}", (Object)event.getFileName());
            logFile = new LogFile2(event.getFileName());
            ozHeraReadListener = new OzHeraReadListener(this.monitor, logFile, this.consumer);
            this.readListenerMap.put(event.getFileKey(), ozHeraReadListener);
            this.pool.submit(() -> {
                logFile.setListener(ozHeraReadListener);
                SafeRun.run(logFile::readLine);
            });
        }
        if (event.getType().equals((Object)EventType.rename)) {
            log.info("rename:{} {}", event.getFileKey(), (Object)event.getFileName());
            this.monitor.getMap().remove(event.getFileKey());
        }
        if (event.getType().equals((Object)EventType.delete)) {
            log.info("delete:{}", (Object)event.getFileName());
            this.readListenerMap.remove(event.getFileKey());
        }
        if (event.getType().equals((Object)EventType.empty)) {
            log.info("empty:{}", (Object)event.getFileName());
            this.monitor.getMap().get(event.getFileKey()).getPointer().set(-1L);
        }
        if (event.getType().equals((Object)EventType.create)) {
            log.info("create:{}", (Object)event.getFileName());
            logFile = new LogFile2(event.getFileName(), 0L, 0L);
            ozHeraReadListener = new OzHeraReadListener(this.monitor, logFile, this.consumer);
            this.readListenerMap.put(event.getFileKey(), ozHeraReadListener);
            this.pool.submit(() -> {
                logFile.setListener(ozHeraReadListener);
                SafeRun.run(logFile::readLine);
            });
        }
    }

    @Override
    public void remove(Object fileKey) {
        this.readListenerMap.remove(fileKey);
    }

    @Override
    public void stop() {
        List<ReadListener> readListenerList = this.getReadListenerList();
        for (ReadListener readListener : readListenerList) {
            OzHeraReadListener ozHeraReadListener = (OzHeraReadListener)readListener;
            ozHeraReadListener.getLogFile().shutdown();
        }
    }

    public List<ReadListener> getReadListenerList() {
        return this.readListenerMap.values().stream().toList();
    }
}

