/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.filter;

import com.xiaomi.mone.tpc.login.anno.ArgCheck;
import com.xiaomi.mone.tpc.login.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.mone.tpc.login.vo.BaseParam;
import com.xiaomi.mone.tpc.login.vo.MoneTpcContext;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ArgCheckFilter {
    private static final Logger log = LoggerFactory.getLogger(ArgCheckFilter.class);
    private Supplier<Object> noUserReturn;
    private Supplier<Object> argErrReturn;
    private Function<Throwable, Object> excpReturn;

    public ArgCheckFilter(Supplier<Object> noUserReturn, Supplier<Object> argErrReturn, Function<Throwable, Object> excpReturn) {
        if (noUserReturn == null || argErrReturn == null || excpReturn == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        this.noUserReturn = noUserReturn;
        this.argErrReturn = argErrReturn;
        this.excpReturn = excpReturn;
    }

    @Pointcut(value="@annotation(com.xiaomi.mone.tpc.login.anno.ArgCheck)")
    public void argCheck() {
    }

    @Around(value="argCheck()")
    public Object doAround(ProceedingJoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ArgCheck argCheck = method.getAnnotation(ArgCheck.class);
        boolean findUser = false;
        AuthUserVo authUserVo = null;
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg instanceof BaseParam) {
                    BaseParam baseParam = (BaseParam)arg;
                    if (!argCheck.allowArgUser()) {
                        baseParam.setAccount(null);
                        baseParam.setUserType(null);
                    }
                    if ((authUserVo = UserUtil.getUser()) != null) {
                        baseParam.setAccount(authUserVo.getAccount());
                        baseParam.setUserType(authUserVo.getUserType());
                    }
                    if (argCheck.checkUser()) {
                        if (StringUtils.isBlank((CharSequence)baseParam.getAccount()) || UserTypeEnum.getEnum(baseParam.getUserType()) == null) {
                            log.info("\u63a5\u53e3{}\u8bf7\u6c42\u53c2\u6570{},\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)method.getName(), arg);
                            return this.noUserReturn.get();
                        }
                        findUser = true;
                    }
                } else if (arg instanceof MoneTpcContext) {
                    MoneTpcContext context = (MoneTpcContext)arg;
                    if (!argCheck.allowArgUser()) {
                        context.setAccount(null);
                        context.setUserType(null);
                    }
                    if ((authUserVo = UserUtil.getUser()) != null) {
                        context.setAccount(authUserVo.getAccount());
                        context.setUserType(authUserVo.getUserType());
                    }
                    if (argCheck.checkUser()) {
                        if (StringUtils.isBlank((CharSequence)context.getAccount()) || UserTypeEnum.getEnum(context.getUserType()) == null) {
                            log.info("\u63a5\u53e3{}\u8bf7\u6c42\u53c2\u6570{},\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)method.getName(), arg);
                            return this.noUserReturn.get();
                        }
                        findUser = true;
                    }
                }
                if (!(arg instanceof com.xiaomi.mone.tpc.login.vo.ArgCheck)) continue;
                log.info("\u63a5\u53e3{}\u8bf7\u6c42\u53c2\u6570{}", (Object)method.getName(), arg);
                if (((com.xiaomi.mone.tpc.login.vo.ArgCheck)arg).argCheck()) continue;
                log.warn("\u7528\u6237\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25; arg={}", arg);
                return this.argErrReturn.get();
            }
        }
        if (!findUser && argCheck.checkUser() && (authUserVo = UserUtil.getUser()) == null) {
            log.info("\u63a5\u53e3{}\u8bf7\u6c42\u53c2\u6570{},\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)method.getName());
            return this.noUserReturn.get();
        }
        try {
            Object result = joinPoint.proceed();
            log.info("\u63a5\u53e3{}\u8bf7\u6c42\u54cd\u5e94{}", (Object)method.getName(), result);
            return result;
        }
        catch (Throwable e) {
            log.error("\u63a5\u53e3{}\u8bf7\u6c42\u5f02\u5e38e={}", (Object)method.getName(), (Object)e.toString());
            return this.excpReturn.apply(e);
        }
    }
}

