/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.vo;

import com.xiaomi.mone.tpc.login.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.login.util.SignUtil;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MoneTpcContext
implements Serializable {
    private String sysName;
    private String sysSign;
    private String userToken;
    private long reqTime;
    private String account;
    private Integer userType;
    private Map<String, String> extMap;

    public static MoneTpcContext create(String sysName, String token, String userToken, Object param) throws Throwable {
        String dataSign;
        long now = System.currentTimeMillis();
        MoneTpcContext context = new MoneTpcContext();
        context.sysName = sysName;
        context.reqTime = now;
        context.userToken = userToken;
        StringBuilder sysSignBuilder = new StringBuilder();
        sysSignBuilder.append(sysName).append(token).append(now);
        if (StringUtils.isNotBlank((CharSequence)userToken)) {
            sysSignBuilder.append(userToken);
        }
        if (StringUtils.isNotBlank((CharSequence)(dataSign = SignUtil.getDataSign(param)))) {
            sysSignBuilder.append(dataSign);
        }
        context.sysSign = sysSignBuilder.toString();
        return context;
    }

    public static MoneTpcContext create(String account, UserTypeEnum userType) throws Throwable {
        long now = System.currentTimeMillis();
        MoneTpcContext context = new MoneTpcContext();
        context.account = account;
        context.userType = userType.getCode();
        return context;
    }

    public String getFullAccount() {
        return UserUtil.getFullAccount(this.account, this.userType);
    }

    public boolean parseFullAccount(String fullAccount) {
        AuthUserVo userVo = UserUtil.parseFullAccount(fullAccount);
        if (userVo == null) {
            return false;
        }
        this.account = userVo.getAccount();
        this.userType = userVo.getUserType();
        return true;
    }

    public void addExt(String key, String value) {
        if (this.extMap == null) {
            this.extMap = new HashMap<String, String>();
        }
        this.extMap.put(key, value);
    }

    public String getExt(String key) {
        if (this.extMap == null) {
            return null;
        }
        return this.extMap.get(key);
    }

    public AuthUserVo buildAuthUserVo() {
        AuthUserVo userVo = new AuthUserVo();
        userVo.setAccount(this.account);
        userVo.setUserType(this.userType);
        return userVo;
    }

    public String getSysName() {
        return this.sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysSign() {
        return this.sysSign;
    }

    public void setSysSign(String sysSign) {
        this.sysSign = sysSign;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public long getReqTime() {
        return this.reqTime;
    }

    public void setReqTime(long reqTime) {
        this.reqTime = reqTime;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String toString() {
        return "MoneTpcContext{sysName='" + this.sysName + "', sysSign='" + this.sysSign + "', userToken='" + this.userToken + "', reqTime=" + this.reqTime + ", account='" + this.account + "', userType=" + this.userType + ", extMap=" + String.valueOf(this.extMap) + "}";
    }
}

