/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.controller;

import com.xiaomi.youpin.docean.anno.Controller;
import com.xiaomi.youpin.docean.anno.RequestMapping;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.model.Pair;
import org.apache.ozhera.log.manager.model.bo.SpacePartitionBalance;
import org.apache.ozhera.log.manager.model.page.PageInfo;
import org.apache.ozhera.log.manager.model.vo.MachinePartitionParam;
import org.apache.ozhera.log.manager.model.vo.SpaceIpParam;
import org.apache.ozhera.log.manager.service.StreamPartitionService;

@Controller
public class StreamPartitionController {
    @Resource
    private StreamPartitionService streamPartitionService;

    @RequestMapping(path="/stream/space/stream/key/list")
    public Result<PageInfo<Pair<String, String>>> queryStreamList(MachinePartitionParam partitionParam) {
        if (StringUtils.isEmpty((CharSequence)partitionParam.getMachineRoom())) {
            return Result.failParam((String)"machineRoom \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success(this.streamPartitionService.queryStreamList(partitionParam));
    }

    @RequestMapping(path="/stream/key/partition/list")
    public Result<PageInfo<Pair<Long, String>>> queryIpPartitionBalance(MachinePartitionParam partitionParam) {
        if (StringUtils.isEmpty((CharSequence)partitionParam.getMachineRoom())) {
            return Result.failParam((String)"machineRoom \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)partitionParam.getUniqueKey())) {
            return Result.failParam((String)"uniqueKey \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success(this.streamPartitionService.queryIpPartitionBalance(partitionParam));
    }

    @RequestMapping(path="/stream/key/space/delete")
    public Result<?> delSpaceToIp(SpaceIpParam param) {
        if (null == param || StringUtils.isEmpty((CharSequence)param.getUniqueKey()) || Objects.isNull(param.getSpaceId())) {
            return Result.failParam((String)"\u53c2\u6570\u662f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success((Object)this.streamPartitionService.delSpaceToIp(param));
    }

    @RequestMapping(path="/stream/key/space/add")
    public Result<?> addSpaceToIp(SpaceIpParam param) {
        if (null == param || CollectionUtils.isEmpty(param.getSpaceIds()) || CollectionUtils.isEmpty(param.getUniqueKeys())) {
            return Result.failParam((String)"\u53c2\u6570\u662f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success((Object)this.streamPartitionService.addSpaceToIp(param));
    }

    @RequestMapping(path="/stream/key/space/list")
    public Result<List<Pair<String, Long>>> findUnIncludedSpaceList(SpaceIpParam param) {
        if (null == param || StringUtils.isEmpty((CharSequence)param.getMachineRoom())) {
            return Result.failParam((String)"machineRoom \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)param.getUniqueKey())) {
            return Result.failParam((String)"\u53c2\u6570uniqueKey\u662f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success(this.streamPartitionService.findUnIncludedSpaceList(param));
    }

    @RequestMapping(path="/stream/space/list")
    public Result<PageInfo<SpacePartitionBalance>> querySpacePartitionBalance(MachinePartitionParam partitionParam) {
        if (StringUtils.isEmpty((CharSequence)partitionParam.getMachineRoom())) {
            return Result.failParam((String)"machineRoom \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success(this.streamPartitionService.querySpacePartitionBalance(partitionParam));
    }

    @RequestMapping(path="/stream/space/key/list")
    public Result<List<Pair<String, String>>> queryAllUniqueKeyList(SpaceIpParam param) {
        if (null == param || StringUtils.isEmpty((CharSequence)param.getMachineRoom())) {
            return Result.failParam((String)"machineRoom \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(param.getSpaceId())) {
            return Result.failParam((String)"spaceId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success(this.streamPartitionService.queryAllUniqueKeyList(param));
    }
}

