/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.common.Es;
import org.apache.ozhera.log.manager.common.Utils;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.mapper.MilogEsClusterMapper;
import org.apache.ozhera.log.manager.mapper.MilogEsIndexMapper;
import org.apache.ozhera.log.manager.model.dto.EsInfoDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.model.pojo.MilogEsIndexDO;
import org.apache.ozhera.log.manager.model.vo.CreateIndexTemplatePropertyCommand;
import org.apache.ozhera.log.manager.model.vo.CreateOrUpdateLogStoreCmd;
import org.apache.ozhera.log.manager.model.vo.UpdateIndexTemplateCommand;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class EsIndexTemplate {
    private static final Logger log = LoggerFactory.getLogger(EsIndexTemplate.class);
    @Resource
    private EsCluster esCluster;
    @Resource
    private MilogEsIndexMapper esIndexMapper;
    @Resource
    private MilogEsClusterMapper milogEsClusterMapper;

    public boolean createIndexTemplate(CreateOrUpdateLogStoreCmd command) throws IOException {
        if (this.existTemplate(command.getEsIndex())) {
            return false;
        }
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(command.getEsIndex());
        request.patterns(Arrays.asList(command.getEsIndex() + "*"));
        request.alias(new Alias(command.getEsIndex()));
        request.order(20);
        request.version(Integer.valueOf(0));
        this.buildSetting(request, command);
        this.buildMapping(request, command);
        EsService esService = this.esCluster.getEsService(null);
        return esService.createIndexTemplate(request) && this.createIndex(command.getEsIndex());
    }

    public boolean createIndex(String indexName) throws IOException {
        if (!this.existTemplate(indexName)) {
            return false;
        }
        CreateIndexRequest request = new CreateIndexRequest(indexName + Es.indexPostfix());
        EsService esService = this.esCluster.getEsService(null);
        CreateIndexResponse response = esService.createIndex(request);
        return response.isAcknowledged();
    }

    public void buildSetting(PutIndexTemplateRequest request, CreateOrUpdateLogStoreCmd command) {
    }

    public void buildSetting(PutIndexTemplateRequest request, UpdateIndexTemplateCommand updateIndexTemplateCommand) {
    }

    public void buildMapping(PutIndexTemplateRequest request, CreateOrUpdateLogStoreCmd command) {
        String[] keyArray = command.getKeyList().split(",");
        String[] keyTypeArray = command.getColumnTypeList().split(",");
        HashMap mapping = new HashMap();
        HashMap properties = new HashMap();
        for (int i = 0; i < keyArray.length; ++i) {
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("type", keyTypeArray[i]);
            properties.put(keyArray[i], property);
        }
        mapping.put("properties", properties);
        request.mapping(mapping);
    }

    public void buildMapping(PutIndexTemplateRequest request, UpdateIndexTemplateCommand updateIndexTemplateCommand) {
        List<CreateIndexTemplatePropertyCommand> propertyList = updateIndexTemplateCommand.getPropertyList();
        if (propertyList == null || propertyList.isEmpty()) {
            return;
        }
        HashMap mapping = new HashMap();
        HashMap properties = new HashMap();
        for (CreateIndexTemplatePropertyCommand p : propertyList) {
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("type", p.getType());
            properties.put(p.getName(), property);
        }
        mapping.put("properties", properties);
        request.mapping(mapping);
    }

    public boolean existTemplate(String templateName) throws IOException {
        if (StringUtils.isEmpty((String)templateName)) {
            return false;
        }
        IndexTemplatesExistRequest request = new IndexTemplatesExistRequest(new String[]{templateName});
        EsService esService = this.esCluster.getEsService(null);
        return esService.existsTemplate(request);
    }

    public String getAreaTypeIndex(String area, Integer logType) {
        MilogEsClusterDO cluster = this.esCluster.getByArea4China(area);
        if (cluster == null) {
            return "";
        }
        return this.getClusterTypeIndex(cluster.getId(), logType);
    }

    public String getRegionTypeIndex(String region, Integer logType) {
        MilogEsClusterDO esClusterDO = this.esCluster.getByRegion(region);
        if (esClusterDO == null) {
            return "";
        }
        return this.getClusterTypeIndex(esClusterDO.getId(), logType);
    }

    public String getClusterTypeIndex(Long esClusterId, Integer logType) {
        if (esClusterId == null || logType == null) {
            return "";
        }
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("cluster_id", esClusterId);
        params.put("log_type", logType);
        List indexList = this.esIndexMapper.selectByMap(params);
        return this.indexChooseAlgo(indexList);
    }

    private String indexChooseAlgo(List<MilogEsIndexDO> indexList) {
        return this.randomChoose(indexList);
    }

    private String randomChoose(List<MilogEsIndexDO> indexList) {
        if (indexList == null || indexList.isEmpty()) {
            return "";
        }
        return indexList.get(new Random().nextInt(indexList.size())).getIndexName();
    }

    public EsInfoDTO getEsInfo(String machineRoom, Integer logType) {
        MilogEsClusterDO cluster = StringUtils.isEmpty((String)machineRoom) ? this.esCluster.getCurEsCluster() : this.esCluster.getByArea4China(machineRoom);
        if (cluster == null) {
            return null;
        }
        String index = this.getClusterTypeIndex(cluster.getId(), logType);
        return new EsInfoDTO(cluster.getId(), index);
    }

    public EsInfoDTO getEsInfo(Long clusterId, Integer logType, String exIndex) {
        Optional<MilogEsIndexDO> doOptional;
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"cluster_id", (Object)clusterId)).eq((Object)"log_type", (Object)logType);
        List milogEsIndexDOS = this.esIndexMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)milogEsIndexDOS)) {
            MilogEsClusterDO milogEsClusterDO = (MilogEsClusterDO)this.milogEsClusterMapper.selectById(clusterId);
            throw new MilogManageException(String.format("ES:%s,log type:%s The index does not exist, go to the Resource Management page to configure it first", milogEsClusterDO.getName(), LogTypeEnum.queryNameByType((Integer)logType)));
        }
        if (StringUtils.isNotEmpty((String)exIndex) && (doOptional = milogEsIndexDOS.stream().filter(indexDO -> Objects.equals(exIndex, indexDO.getIndexName())).findFirst()).isPresent()) {
            return new EsInfoDTO(doOptional.get().getClusterId(), exIndex);
        }
        String indexName = this.indexChooseAlgo(milogEsIndexDOS);
        return new EsInfoDTO(clusterId, indexName);
    }

    public EsInfoDTO getEsInfoOtherDept(Long clusterId, Integer logType, String exIndex) {
        Optional<MilogEsIndexDO> doOptional;
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"cluster_id", (Object)clusterId)).eq((Object)"log_type", (Object)logType);
        List milogEsIndexDOS = this.esIndexMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)milogEsIndexDOS)) {
            MilogEsClusterDO milogEsClusterDO = (MilogEsClusterDO)this.milogEsClusterMapper.selectById(clusterId);
            throw new MilogManageException(String.format("ES:%s,log type:%s The index does not exist, go to the Resource Management page to configure it first", milogEsClusterDO.getName(), LogTypeEnum.queryNameByType((Integer)logType)));
        }
        if (StringUtils.isNotEmpty((String)exIndex) && (doOptional = milogEsIndexDOS.stream().filter(indexDO -> Objects.equals(exIndex, indexDO.getIndexName())).findFirst()).isPresent()) {
            return new EsInfoDTO(doOptional.get().getClusterId(), exIndex);
        }
        MilogEsIndexDO milogEsIndexDO = (MilogEsIndexDO)milogEsIndexDOS.get(Utils.getRandomNum(milogEsIndexDOS.size()));
        return new EsInfoDTO(clusterId, milogEsIndexDO.getIndexName());
    }
}

