/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain.analyse;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.ozhera.log.manager.domain.analyse.AggrCalcuStrategy;
import org.apache.ozhera.log.manager.model.bo.CalcuAggrParam;
import org.apache.ozhera.log.manager.model.dto.LogAnalyseDataDTO;
import org.apache.ozhera.log.manager.model.dto.LogAnalyseDataDateDTO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

@Service
public class DateGroupStrategy
implements AggrCalcuStrategy {
    @Override
    public AggregationBuilder getAggr(CalcuAggrParam param) {
        Long startTime = param.getStartTime() / 1000L * 1000L;
        Long endTime = param.getEndTime() / 1000L * 1000L;
        int interval = (int)Math.ceil((double)((endTime - startTime) / 1000L) / Double.parseDouble(param.getGraphParam()));
        String offset = startTime % (long)(interval * 1000) + "ms";
        DateHistogramAggregationBuilder dateGroupAggs = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"dateAggs").field("timestamp")).minDocCount(0L).offset(offset).format("yyyy-MM-dd HH:mm:ss")).timeZone(TimeZone.getTimeZone("GMT+8").toZoneId())).fixedInterval(new DateHistogramInterval(interval + "s")).extendedBounds(new LongBounds(startTime, Long.valueOf(endTime - 1000L)));
        TermsAggregationBuilder topAggs = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"fieldAggs").size(4).field(param.getBead())).executionHint("map");
        dateGroupAggs.subAggregation((AggregationBuilder)topAggs);
        return dateGroupAggs;
    }

    @Override
    public LogAnalyseDataDTO formatRes(SearchResponse response) {
        if (response == null || response.getAggregations() == null) {
            return null;
        }
        Histogram dateAggs = (Histogram)response.getAggregations().get("dateAggs");
        if (dateAggs == null) {
            return null;
        }
        LinkedHashMap ferryMap = new LinkedHashMap();
        HashSet<String> termKeySet = new HashSet<String>();
        for (int i = 0; i < dateAggs.getBuckets().size(); ++i) {
            Histogram.Bucket bucket = (Histogram.Bucket)dateAggs.getBuckets().get(i);
            ParsedStringTerms filedAggs = (ParsedStringTerms)bucket.getAggregations().get("fieldAggs");
            if (filedAggs == null) {
                return null;
            }
            HashMap<String, String> ferryTermMap = new HashMap<String, String>();
            for (int j = 0; j < filedAggs.getBuckets().size(); ++j) {
                Terms.Bucket filedAggsBucket = (Terms.Bucket)filedAggs.getBuckets().get(j);
                ferryTermMap.put(filedAggsBucket.getKeyAsString(), String.valueOf(filedAggsBucket.getDocCount()));
                termKeySet.add(filedAggsBucket.getKeyAsString());
            }
            ferryMap.put(bucket.getKeyAsString(), ferryTermMap);
        }
        ArrayList<List<String>> date = new ArrayList<List<String>>();
        for (Map.Entry entry : ferryMap.entrySet()) {
            ArrayList<String> ferryDate = new ArrayList<String>();
            ferryDate.add((String)entry.getKey());
            for (String term : termKeySet) {
                ferryDate.add(((Map)entry.getValue()).containsKey(term) ? (String)((Map)entry.getValue()).get(term) : "0");
            }
            date.add(ferryDate);
        }
        return new LogAnalyseDataDateDTO(date, termKeySet);
    }
}

