/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Service;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.log.api.enums.MiddlewareEnum;
import org.apache.ozhera.log.manager.common.Utils;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.dao.MilogAppMiddlewareRelDao;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.model.pojo.MilogAppMiddlewareRel;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.MilogAppMiddlewareRelService;
import org.apache.ozhera.log.manager.service.MqConfigService;
import org.apache.ozhera.log.manager.service.impl.HeraAppServiceImpl;
import org.apache.ozhera.log.manager.service.impl.KafkaMqConfigService;
import org.apache.ozhera.log.manager.service.impl.RocketMqConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogAppMiddlewareRelServiceImpl
implements MilogAppMiddlewareRelService {
    private static final Logger log = LoggerFactory.getLogger(MilogAppMiddlewareRelServiceImpl.class);
    @Resource
    private MilogAppMiddlewareRelDao milogAppMiddlewareRelDao;
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    @Resource
    private HeraAppServiceImpl heraAppService;
    @Resource
    private MilogLogTailDao milogLogtailDao;
    private MqConfigService mqConfigService;
    @Resource
    private MilogAppMiddlewareRelDao middlewareRelDao;

    @Override
    public void bindingTailConfigRel(Long tailId, Long milogAppId, Long middlewareConfigId, String topicName) {
        MilogMiddlewareConfig wareConfig = this.queryMiddlewareConfig(middlewareConfigId);
        if (null != wareConfig) {
            middlewareConfigId = wareConfig.getId();
            this.instantiateMqConfigSubClass(MiddlewareEnum.queryByCode((Integer)wareConfig.getType()));
            AppBaseInfo appBaseInfo = this.heraAppService.queryById(milogAppId);
            MilogAppMiddlewareRel.Config config = new MilogAppMiddlewareRel.Config();
            if (StringUtils.isEmpty((CharSequence)topicName)) {
                config = this.mqConfigService.generateConfig(wareConfig.getAk(), wareConfig.getSk(), wareConfig.getNameServer(), wareConfig.getServiceUrl(), wareConfig.getAuthorization(), wareConfig.getOrgId(), wareConfig.getTeamId(), Long.valueOf(appBaseInfo.getBindId()), appBaseInfo.getAppName(), appBaseInfo.getPlatformName(), tailId);
            } else {
                config.setTopic(topicName);
                config.setPartitionCnt(1);
            }
            MilogLogTailDo milogLogtailDo = this.milogLogtailDao.queryById(tailId);
            String tag = Utils.createTag(milogLogtailDo.getSpaceId(), milogLogtailDo.getStoreId(), milogLogtailDo.getId());
            config.setTag(tag);
            config.setConsumerGroup("subGroup_" + tag);
            this.milogAppMiddlewareRelDao.insertUpdate(this.generateMiddlewareRel(tailId, milogAppId, middlewareConfigId, config));
        } else {
            log.error("The middleware configuration for the current environment is empty,tailId:{},milogAppId:{},middlewareConfigId:{}", new Object[]{tailId, milogAppId, middlewareConfigId});
        }
    }

    @Override
    public void defaultBindingAppTailConfigRel(Long id, Long milogAppId, Long middleWareId, String topicName, Integer batchSendSize) {
        MilogAppMiddlewareRel.Config config;
        MilogLogTailDo logTailDo = this.milogLogtailDao.queryById(id);
        MilogMiddlewareConfig wareConfig = this.milogMiddlewareConfigDao.queryById(middleWareId);
        if (null != wareConfig) {
            if (StringUtils.isEmpty((CharSequence)topicName)) {
                List<String> commonTagTopicNames = Utils.generateCommonTagTopicName("");
                this.instantiateMqConfigSubClass(MiddlewareEnum.queryByCode((Integer)wareConfig.getType()));
                AppBaseInfo appBaseInfo = this.heraAppService.queryById(milogAppId);
                topicName = this.mqConfigService.generateSimpleTopicName(id, appBaseInfo.getAppName());
            }
            config = new MilogAppMiddlewareRel.Config();
            config.setTopic(topicName);
            config.setPartitionCnt(1);
            String tag = Utils.createTag(logTailDo.getSpaceId(), logTailDo.getStoreId(), id);
            config.setConsumerGroup(String.format("%s_%s", "group", tag));
            config.setTag(tag);
            if (null != batchSendSize) {
                config.setBatchSendSize(batchSendSize);
            }
        } else {
            log.error("If the current organization does not have MQ configuration information configured, configure the message configuration information of the current organization,tailId\uff1a{},storeId:{},middleWareId:{}", new Object[]{id, milogAppId, middleWareId});
            throw new MilogManageException("If the current organization does not configure MQ configuration information, configure the resource configuration information of the current department");
        }
        this.handleTailMqRel(id, milogAppId, wareConfig, config);
    }

    private String findLeastUsedCommonTopic(List<String> existTopics) {
        List commonTopics = existTopics.stream().filter(s -> s.startsWith("common_mq_miLog")).sorted((a, b) -> this.middlewareRelDao.queryCountByTopicName((String)a).compareTo(this.middlewareRelDao.queryCountByTopicName((String)b))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(commonTopics)) {
            return (String)commonTopics.get(0);
        }
        return "";
    }

    private void handleTailMqRel(Long tailId, Long milogAppId, MilogMiddlewareConfig wareConfig, MilogAppMiddlewareRel.Config config) {
        MilogLogTailDo milogLogtailDo = this.milogLogtailDao.queryById(tailId);
        String tag = Utils.createTag(milogLogtailDo.getSpaceId(), milogLogtailDo.getStoreId(), milogLogtailDo.getId());
        config.setTag(tag);
        config.setConsumerGroup("subGroup_" + tag);
        MilogAppMiddlewareRel milogAppMiddlewareRel = this.generateMiddlewareRel(tailId, milogAppId, wareConfig.getId(), config);
        this.milogAppMiddlewareRelDao.insertUpdate(milogAppMiddlewareRel);
    }

    private MilogAppMiddlewareRel generateMiddlewareRel(Long tailId, Long milogAppId, Long configId, MilogAppMiddlewareRel.Config config) {
        MilogAppMiddlewareRel milogAppMiddlewareRel = new MilogAppMiddlewareRel();
        milogAppMiddlewareRel.setMilogAppId(milogAppId);
        milogAppMiddlewareRel.setMiddlewareId(configId);
        milogAppMiddlewareRel.setTailId(tailId);
        milogAppMiddlewareRel.setConfig(config);
        milogAppMiddlewareRel.setCtime(Instant.now().toEpochMilli());
        milogAppMiddlewareRel.setUtime(Instant.now().toEpochMilli());
        if (StringUtils.isEmpty((CharSequence)MoneUserContext.getCurrentUser().getUser())) {
            MilogLogTailDo milogLogTailDo = this.milogLogtailDao.queryById(tailId);
            milogAppMiddlewareRel.setCreator(milogLogTailDo.getCreator());
            milogAppMiddlewareRel.setUpdater(milogLogTailDo.getUpdater());
        } else {
            milogAppMiddlewareRel.setCreator(MoneUserContext.getCurrentUser().getUser());
            milogAppMiddlewareRel.setUpdater(MoneUserContext.getCurrentUser().getUser());
        }
        return milogAppMiddlewareRel;
    }

    public MilogMiddlewareConfig queryMiddlewareConfig(Long middlewareConfigId) {
        MilogMiddlewareConfig wareConfig = null != middlewareConfigId ? this.milogMiddlewareConfigDao.queryById(middlewareConfigId) : this.milogMiddlewareConfigDao.queryDefaultMiddlewareConfig();
        return wareConfig;
    }

    private void instantiateMqConfigSubClass(MiddlewareEnum middlewareEnum) {
        switch (middlewareEnum) {
            case ROCKETMQ: {
                this.mqConfigService = (MqConfigService)Ioc.ins().getBean(RocketMqConfigService.class);
                break;
            }
            case KAFKA: {
                this.mqConfigService = (MqConfigService)Ioc.ins().getBean(KafkaMqConfigService.class);
            }
        }
    }
}

