/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.statement;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.EsOperatorEnum;
import org.apache.ozhera.log.api.enums.EsOperatorMatchEnum;
import org.apache.ozhera.log.manager.common.utils.ManagerUtil;
import org.apache.ozhera.log.manager.service.statement.AndAllStatementMatchParse;
import org.apache.ozhera.log.manager.service.statement.MustNotStatementMatchParse;
import org.apache.ozhera.log.manager.service.statement.MustStatementMatchParse;
import org.apache.ozhera.log.manager.service.statement.NotAllStatementMatchParse;
import org.apache.ozhera.log.manager.service.statement.OperatorData;
import org.apache.ozhera.log.manager.service.statement.OperatorSlice;
import org.apache.ozhera.log.manager.service.statement.OrAllStatementMatchParse;
import org.apache.ozhera.log.manager.service.statement.OrStatementMatchParse;
import org.apache.ozhera.log.manager.service.statement.QueryEntity;
import org.apache.ozhera.log.manager.service.statement.StatementMatchParse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class StatementMatchParseFactory {
    private static final String LOG_LEVEL_KEY = "level";
    private static final String NOT_MATCH_KEY = " not ";
    private static final String AND_MATCH_KEY = " and ";
    private static final String OR_MATCH_KEY = " or ";
    public static final String DOUBLE_QUOTATION_MARK_SEPARATOR = "\"";
    private static Map<EsOperatorEnum, Map<EsOperatorMatchEnum, StatementMatchParse>> operateMatchMap = Maps.newHashMap();

    public static BoolQueryBuilder getStatementMatchParseQueryBuilder(String message, List<String> keyPrefixList) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        List<OperatorSlice> operatorSliceList = StatementMatchParseFactory.analyseTransformOs(message, keyPrefixList);
        List<OperatorData> operatorDataList = StatementMatchParseFactory.sliceTransformOd(operatorSliceList);
        for (OperatorData operatorData : operatorDataList) {
            BoolQueryBuilder queryBuilder = StatementMatchParseFactory.getSplitQueryBuilder(keyPrefixList, operatorData);
            boolQueryBuilder.filter((QueryBuilder)queryBuilder);
        }
        return boolQueryBuilder;
    }

    private static List<OperatorData> sliceTransformOd(List<OperatorSlice> operatorSliceList) {
        ArrayList operatorSlices = Lists.newArrayList();
        Map<EsOperatorEnum, List<OperatorSlice>> operatorEnumListMap = operatorSliceList.stream().collect(Collectors.groupingBy(OperatorSlice::getOperatorEnum));
        for (Map.Entry<EsOperatorEnum, List<OperatorSlice>> enumListEntry : operatorEnumListMap.entrySet()) {
            operatorSlices.add(OperatorData.builder().operatorEnum(enumListEntry.getKey()).messageList(enumListEntry.getValue().stream().map(OperatorSlice::getMessage).collect(Collectors.toList())).build());
        }
        return operatorSlices;
    }

    private static BoolQueryBuilder getSplitQueryBuilder(List<String> keyPerfixList, OperatorData operatorSlice) {
        ArrayList allMatchEntities = Lists.newArrayList();
        ArrayList kvMatchEntities = Lists.newArrayList();
        StatementMatchParseFactory.filterMatchEntities(keyPerfixList, operatorSlice, kvMatchEntities, allMatchEntities);
        Map<EsOperatorMatchEnum, StatementMatchParse> matchParseMap = operateMatchMap.get(operatorSlice.getOperatorEnum());
        BoolQueryBuilder allMatchBuilder = new BoolQueryBuilder();
        BoolQueryBuilder kvMatchBuilder = new BoolQueryBuilder();
        if (CollectionUtils.isNotEmpty((Collection)allMatchEntities)) {
            allMatchBuilder = matchParseMap.get(((QueryEntity)allMatchEntities.get(0)).getMatchEnum()).matchBuild(allMatchEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)kvMatchEntities)) {
            kvMatchBuilder = matchParseMap.get(((QueryEntity)kvMatchEntities.get(0)).getMatchEnum()).matchBuild(kvMatchEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)allMatchEntities) && CollectionUtils.isNotEmpty((Collection)kvMatchEntities)) {
            allMatchBuilder.filter((QueryBuilder)kvMatchBuilder);
            return allMatchBuilder;
        }
        if (CollectionUtils.isNotEmpty((Collection)allMatchEntities) && CollectionUtils.isEmpty((Collection)kvMatchEntities)) {
            return allMatchBuilder;
        }
        if (CollectionUtils.isEmpty((Collection)allMatchEntities) && CollectionUtils.isNotEmpty((Collection)kvMatchEntities)) {
            return kvMatchBuilder;
        }
        return allMatchBuilder;
    }

    private static void filterMatchEntities(List<String> keyPerfixList, OperatorData operatorSlice, List<QueryEntity> kvMatchEntities, List<QueryEntity> allMatchEntities) {
        for (String message : operatorSlice.getMessageList()) {
            String kvPrefix = ManagerUtil.MatchKVPrefix(message, keyPerfixList);
            if (StringUtils.isNotBlank((CharSequence)kvPrefix)) {
                String field = StringUtils.substringBefore((String)kvPrefix, (String)":");
                String fieldValue = StrUtil.trimStart((CharSequence)StringUtils.substringAfter((String)message, (String)":"));
                kvMatchEntities.add(QueryEntity.builder().field(field).fieldValue(fieldValue).matchEnum(EsOperatorMatchEnum.KV_MATCH_OPERATOR).build());
                continue;
            }
            allMatchEntities.add(QueryEntity.builder().fieldValue(StrUtil.trimStart((CharSequence)message)).matchEnum(EsOperatorMatchEnum.ALL_MATCH_OPERATOR).build());
        }
    }

    public static List<OperatorSlice> analyseTransformOs(String message, List<String> keyPrefixList) {
        ArrayList operatorSlices = Lists.newArrayList();
        String kvPrefix = ManagerUtil.MatchKVPrefix(message, keyPrefixList);
        String[] msgArrays = StringUtils.substringsBetween((String)message, (String)DOUBLE_QUOTATION_MARK_SEPARATOR, (String)DOUBLE_QUOTATION_MARK_SEPARATOR);
        if (StringUtils.isBlank((CharSequence)kvPrefix) && null != msgArrays && msgArrays.length == 1) {
            StatementMatchParseFactory.handleAndLogic(message, operatorSlices);
            return operatorSlices;
        }
        if (message.contains(AND_MATCH_KEY)) {
            StatementMatchParseFactory.handleAndLogic(message, operatorSlices);
        } else if (message.contains(NOT_MATCH_KEY)) {
            StatementMatchParseFactory.handleNotLogic(message, operatorSlices);
        } else if (message.contains(OR_MATCH_KEY)) {
            StatementMatchParseFactory.operatorSlicesAdd(operatorSlices, message, EsOperatorEnum.OR_OPERATOR);
        } else {
            StatementMatchParseFactory.buildOperatorToSlices(operatorSlices, EsOperatorEnum.AND_OPERATOR, message);
        }
        return operatorSlices;
    }

    private static void handleAndLogic(String message, List<OperatorSlice> operatorSlices) {
        List<String> andList = StatementMatchParseFactory.splitBySeparator(message, AND_MATCH_KEY);
        for (String andPer : andList) {
            int i;
            List<String> matchList;
            if (!andPer.contains(NOT_MATCH_KEY) && !andPer.contains(OR_MATCH_KEY)) {
                StatementMatchParseFactory.buildOperatorToSlices(operatorSlices, EsOperatorEnum.AND_OPERATOR, andPer);
                continue;
            }
            if (andPer.contains(NOT_MATCH_KEY) && !andPer.contains(OR_MATCH_KEY)) {
                if (andPer.startsWith(NOT_MATCH_KEY)) {
                    StatementMatchParseFactory.operatorSlicesAdd(operatorSlices, andPer, EsOperatorEnum.NOT_OPERATOR);
                    continue;
                }
                matchList = StatementMatchParseFactory.splitBySeparator(andPer, EsOperatorEnum.NOT_OPERATOR.getCode());
                for (i = 0; i < matchList.size(); ++i) {
                    if (i == 0) {
                        StatementMatchParseFactory.buildOperatorToSlices(operatorSlices, EsOperatorEnum.AND_OPERATOR, matchList.get(i));
                        continue;
                    }
                    StatementMatchParseFactory.buildOperatorToSlices(operatorSlices, EsOperatorEnum.NOT_OPERATOR, matchList.get(i));
                }
                continue;
            }
            if (andPer.contains(NOT_MATCH_KEY) || !andPer.contains(OR_MATCH_KEY)) continue;
            if (andPer.startsWith(OR_MATCH_KEY)) {
                StatementMatchParseFactory.operatorSlicesAdd(operatorSlices, andPer, EsOperatorEnum.OR_OPERATOR);
                continue;
            }
            matchList = StatementMatchParseFactory.splitBySeparator(andPer, EsOperatorEnum.OR_OPERATOR.getCode());
            for (i = 0; i < matchList.size(); ++i) {
                if (i == 0) {
                    StatementMatchParseFactory.buildOperatorToSlices(operatorSlices, EsOperatorEnum.AND_OPERATOR, matchList.get(i));
                    continue;
                }
                StatementMatchParseFactory.buildOperatorToSlices(operatorSlices, EsOperatorEnum.OR_OPERATOR, matchList.get(i));
            }
        }
    }

    private static void handleNotLogic(String message, List<OperatorSlice> operatorSlices) {
        List<String> notList = StatementMatchParseFactory.splitBySeparator(message, NOT_MATCH_KEY);
        for (int i = 0; i < notList.size(); ++i) {
            String notPer = notList.get(i);
            if (notList.size() > 1 && i == 0) {
                if (!notPer.contains(OR_MATCH_KEY)) {
                    StatementMatchParseFactory.buildOperatorToSlices(operatorSlices, EsOperatorEnum.AND_OPERATOR, notPer);
                    continue;
                }
                StatementMatchParseFactory.operatorSlicesAdd(operatorSlices, notPer, EsOperatorEnum.OR_OPERATOR);
                continue;
            }
            if (!notPer.contains(OR_MATCH_KEY)) {
                StatementMatchParseFactory.buildOperatorToSlices(operatorSlices, EsOperatorEnum.NOT_OPERATOR, notPer);
                continue;
            }
            StatementMatchParseFactory.operatorSlicesAdd(operatorSlices, notPer, EsOperatorEnum.OR_OPERATOR);
        }
    }

    public static List<String> splitBySeparator(String message, String separator) {
        ArrayList sparMsgLists = Lists.newArrayList();
        while (StringUtils.isNotBlank((CharSequence)message)) {
            int startIndex = 0;
            int endIndex = message.startsWith(DOUBLE_QUOTATION_MARK_SEPARATOR) ? message.indexOf(separator, message.indexOf(DOUBLE_QUOTATION_MARK_SEPARATOR, 1)) : message.indexOf(separator);
            if (endIndex == -1) {
                endIndex = message.length();
            }
            sparMsgLists.add(StringUtils.substring((String)message, (int)startIndex, (int)endIndex));
            message = StringUtils.substring((String)message, (int)(endIndex + separator.length()));
        }
        return sparMsgLists.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private static void operatorSlicesAdd(List<OperatorSlice> operatorSlices, String message, EsOperatorEnum operatorEnum) {
        List<String> matchList = StatementMatchParseFactory.splitBySeparator(message, operatorEnum.getCode());
        for (String matchPer : matchList) {
            StatementMatchParseFactory.buildOperatorToSlices(operatorSlices, operatorEnum, matchPer);
        }
    }

    private static void buildOperatorToSlices(List<OperatorSlice> operatorSlices, EsOperatorEnum operatorEnum, String matchPer) {
        operatorSlices.add(OperatorSlice.builder().operatorEnum(operatorEnum).message(matchPer).build());
    }

    static {
        HashMap andOperateMap = Maps.newHashMap();
        andOperateMap.put(EsOperatorMatchEnum.ALL_MATCH_OPERATOR, new AndAllStatementMatchParse());
        andOperateMap.put(EsOperatorMatchEnum.KV_MATCH_OPERATOR, new MustStatementMatchParse());
        HashMap notOperateMap = Maps.newHashMap();
        notOperateMap.put(EsOperatorMatchEnum.ALL_MATCH_OPERATOR, new NotAllStatementMatchParse());
        notOperateMap.put(EsOperatorMatchEnum.KV_MATCH_OPERATOR, new MustNotStatementMatchParse());
        HashMap orOperateMap = Maps.newHashMap();
        orOperateMap.put(EsOperatorMatchEnum.ALL_MATCH_OPERATOR, new OrAllStatementMatchParse());
        orOperateMap.put(EsOperatorMatchEnum.KV_MATCH_OPERATOR, new OrStatementMatchParse());
        operateMatchMap.put(EsOperatorEnum.AND_OPERATOR, andOperateMap);
        operateMatchMap.put(EsOperatorEnum.NOT_OPERATOR, notOperateMap);
        operateMatchMap.put(EsOperatorEnum.OR_OPERATOR, orOperateMap);
    }
}

