/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.beanmapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import org.mapstruct.ap.internal.model.beanmapping.AbstractReference;
import org.mapstruct.ap.internal.model.beanmapping.PropertyEntry;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;

public class SourceReference
extends AbstractReference {
    private SourceReference(Parameter sourceParameter, List<PropertyEntry> sourcePropertyEntries, boolean isValid) {
        super(sourceParameter, sourcePropertyEntries, isValid);
    }

    public SourceReference pop() {
        if (this.getPropertyEntries().size() > 1) {
            ArrayList<PropertyEntry> newPropertyEntries = new ArrayList<PropertyEntry>(this.getPropertyEntries().subList(1, this.getPropertyEntries().size()));
            return new SourceReference(this.getParameter(), newPropertyEntries, this.isValid());
        }
        return null;
    }

    public List<SourceReference> push(TypeFactory typeFactory, FormattingMessager messager, Method method) {
        ArrayList<SourceReference> result = new ArrayList<SourceReference>();
        PropertyEntry deepestProperty = this.getDeepestProperty();
        if (deepestProperty != null) {
            Type type = deepestProperty.getType();
            Map<String, Accessor> newDeepestReadAccessors = type.getPropertyReadAccessors();
            for (Map.Entry<String, Accessor> newDeepestReadAccessorEntry : newDeepestReadAccessors.entrySet()) {
                String newFullName = deepestProperty.getFullName() + "." + newDeepestReadAccessorEntry.getKey();
                SourceReference sourceReference = new BuilderFromMapping().sourceName(newFullName).method(method).messager(messager).typeFactory(typeFactory).build();
                result.add(sourceReference);
            }
        }
        return result;
    }

    public static class BuilderFromSourceReference {
        private Parameter sourceParameter;
        private SourceReference sourceReference;

        public BuilderFromSourceReference sourceReference(SourceReference sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public BuilderFromSourceReference sourceParameter(Parameter sourceParameter) {
            this.sourceParameter = sourceParameter;
            return this;
        }

        public SourceReference build() {
            return new SourceReference(this.sourceParameter, this.sourceReference.getPropertyEntries(), true);
        }
    }

    public static class BuilderFromProperty {
        private String name;
        private Accessor readAccessor;
        private Accessor presenceChecker;
        private Type type;
        private Parameter sourceParameter;

        public BuilderFromProperty name(String name) {
            this.name = name;
            return this;
        }

        public BuilderFromProperty readAccessor(Accessor readAccessor) {
            this.readAccessor = readAccessor;
            return this;
        }

        public BuilderFromProperty presenceChecker(Accessor presenceChecker) {
            this.presenceChecker = presenceChecker;
            return this;
        }

        public BuilderFromProperty type(Type type) {
            this.type = type;
            return this;
        }

        public BuilderFromProperty sourceParameter(Parameter sourceParameter) {
            this.sourceParameter = sourceParameter;
            return this;
        }

        public SourceReference build() {
            ArrayList<PropertyEntry> sourcePropertyEntries = new ArrayList<PropertyEntry>();
            if (this.readAccessor != null) {
                sourcePropertyEntries.add(PropertyEntry.forSourceReference(new String[]{this.name}, this.readAccessor, this.presenceChecker, this.type));
            }
            return new SourceReference(this.sourceParameter, sourcePropertyEntries, true);
        }
    }

    public static class BuilderFromMapping {
        private Method method;
        private FormattingMessager messager = null;
        private TypeFactory typeFactory;
        private boolean isForwarded = false;
        private Method templateMethod = null;
        private String sourceName;
        private AnnotationMirror annotationMirror;
        private AnnotationValue sourceAnnotationValue;

        public BuilderFromMapping messager(FormattingMessager messager) {
            this.messager = messager;
            return this;
        }

        public BuilderFromMapping mapping(MappingOptions mapping) {
            this.sourceName = mapping.getSourceName();
            this.annotationMirror = mapping.getMirror();
            this.sourceAnnotationValue = mapping.getSourceAnnotationValue();
            if (mapping.getInheritContext() != null) {
                this.isForwarded = mapping.getInheritContext().isForwarded();
                this.templateMethod = mapping.getInheritContext().getTemplateMethod();
            }
            return this;
        }

        public BuilderFromMapping method(Method method) {
            this.method = method;
            return this;
        }

        public BuilderFromMapping typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public BuilderFromMapping sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public SourceReference build() {
            if (this.sourceName == null) {
                return null;
            }
            Objects.requireNonNull(this.messager);
            String sourceNameTrimmed = this.sourceName.trim();
            if (!this.sourceName.equals(sourceNameTrimmed)) {
                this.messager.printMessage((Element)this.method.getExecutable(), this.annotationMirror, this.sourceAnnotationValue, Message.PROPERTYMAPPING_WHITESPACE_TRIMMED, this.sourceName, sourceNameTrimmed);
            }
            String[] segments = sourceNameTrimmed.split("\\.");
            SourceReference result = new SourceReference(null, new ArrayList(), false);
            if (this.method.getSourceParameters().size() > 1) {
                Parameter parameter = this.fetchMatchingParameterFromFirstSegment(segments);
                if (parameter != null) {
                    result = this.buildFromMultipleSourceParameters(segments, parameter);
                }
            } else {
                Parameter parameter = this.method.getSourceParameters().get(0);
                result = this.buildFromSingleSourceParameters(segments, parameter);
            }
            return result;
        }

        private SourceReference buildFromSingleSourceParameters(String[] segments, Parameter parameter) {
            boolean foundEntryMatch;
            String[] propertyNames = segments;
            List<PropertyEntry> entries = this.matchWithSourceAccessorTypes(parameter.getType(), propertyNames);
            boolean bl = foundEntryMatch = entries.size() == propertyNames.length;
            if (!foundEntryMatch) {
                if (this.getSourceParameterFromMethodOrTemplate(segments[0]) != null) {
                    propertyNames = Arrays.copyOfRange(segments, 1, segments.length);
                    entries = this.matchWithSourceAccessorTypes(parameter.getType(), propertyNames);
                    foundEntryMatch = entries.size() == propertyNames.length;
                } else {
                    parameter = null;
                }
            }
            if (!foundEntryMatch) {
                this.reportErrorOnNoMatch(parameter, propertyNames, entries);
            }
            return new SourceReference(parameter, entries, foundEntryMatch);
        }

        private SourceReference buildFromMultipleSourceParameters(String[] segments, Parameter parameter) {
            boolean foundEntryMatch;
            String[] propertyNames = new String[]{};
            List<PropertyEntry> entries = new ArrayList<PropertyEntry>();
            if (segments.length > 1 && parameter != null) {
                propertyNames = Arrays.copyOfRange(segments, 1, segments.length);
                entries = this.matchWithSourceAccessorTypes(parameter.getType(), propertyNames);
                foundEntryMatch = entries.size() == propertyNames.length;
            } else {
                foundEntryMatch = true;
            }
            if (!foundEntryMatch) {
                this.reportErrorOnNoMatch(parameter, propertyNames, entries);
            }
            return new SourceReference(parameter, entries, foundEntryMatch);
        }

        private Parameter fetchMatchingParameterFromFirstSegment(String[] segments) {
            String parameterName;
            Parameter parameter = null;
            if (segments.length > 0 && (parameter = this.getSourceParameterFromMethodOrTemplate(parameterName = segments[0])) == null) {
                this.reportMappingError(Message.PROPERTYMAPPING_INVALID_PARAMETER_NAME, parameterName, Strings.join(this.method.getSourceParameters(), ", ", Parameter::getName));
            }
            return parameter;
        }

        private Parameter getSourceParameterFromMethodOrTemplate(String parameterName) {
            Parameter result = null;
            if (this.isForwarded) {
                Parameter parameter = Parameter.getSourceParameter(this.templateMethod.getParameters(), parameterName);
                if (parameter != null) {
                    for (Parameter sourceParameter : this.method.getSourceParameters()) {
                        if (!sourceParameter.getType().isAssignableTo(parameter.getType())) continue;
                        if (result == null) {
                            result = sourceParameter;
                            continue;
                        }
                        result = Parameter.getSourceParameter(this.method.getParameters(), parameterName);
                        break;
                    }
                }
            } else {
                result = Parameter.getSourceParameter(this.method.getParameters(), parameterName);
            }
            return result;
        }

        private void reportErrorOnNoMatch(Parameter parameter, String[] propertyNames, List<PropertyEntry> entries) {
            if (parameter != null) {
                this.reportMappingError(Message.PROPERTYMAPPING_NO_PROPERTY_IN_PARAMETER, parameter.getName(), Strings.join(Arrays.asList(propertyNames), "."));
            } else {
                int notFoundPropertyIndex = 0;
                Type sourceType = this.method.getParameters().get(0).getType();
                if (!entries.isEmpty()) {
                    notFoundPropertyIndex = entries.size();
                    sourceType = Collections.last(entries).getType();
                }
                String mostSimilarWord = Strings.getMostSimilarWord(propertyNames[notFoundPropertyIndex], sourceType.getPropertyReadAccessors().keySet());
                ArrayList<String> elements = new ArrayList<String>(Arrays.asList(propertyNames).subList(0, notFoundPropertyIndex));
                elements.add(mostSimilarWord);
                this.reportMappingError(Message.PROPERTYMAPPING_INVALID_PROPERTY_NAME, this.sourceName, Strings.join(elements, "."));
            }
        }

        private List<PropertyEntry> matchWithSourceAccessorTypes(Type type, String[] entryNames) {
            ArrayList<PropertyEntry> sourceEntries = new ArrayList<PropertyEntry>();
            Type newType = type;
            for (int i = 0; i < entryNames.length; ++i) {
                boolean matchFound = false;
                Map<String, Accessor> sourceReadAccessors = newType.getPropertyReadAccessors();
                Map<String, Accessor> sourcePresenceCheckers = newType.getPropertyPresenceCheckers();
                for (Map.Entry<String, Accessor> getter : sourceReadAccessors.entrySet()) {
                    if (!getter.getKey().equals(entryNames[i])) continue;
                    newType = this.typeFactory.getReturnType((DeclaredType)newType.getTypeMirror(), getter.getValue());
                    sourceEntries.add(PropertyEntry.forSourceReference(Arrays.copyOf(entryNames, i + 1), getter.getValue(), sourcePresenceCheckers.get(entryNames[i]), newType));
                    matchFound = true;
                    break;
                }
                if (!matchFound) break;
            }
            return sourceEntries;
        }

        private void reportMappingError(Message msg, Object ... objects) {
            this.messager.printMessage((Element)this.method.getExecutable(), this.annotationMirror, this.sourceAnnotationValue, msg, objects);
        }
    }
}

