/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.mq;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.ozhera.app.api.message.HeraAppInfoModifyMessage;
import org.apache.ozhera.app.api.message.HeraAppModifyType;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.dao.HeraAppRoleDao;
import org.apache.ozhera.app.dao.HeraBaseInfoDao;
import org.apache.ozhera.app.model.HeraAppBaseInfo;
import org.apache.ozhera.app.model.HeraAppRole;
import org.apache.ozhera.app.service.impl.HeraAppBaseInfoService;
import org.apache.ozhera.app.service.mq.RocketMqHeraAppProducer;
import org.apache.ozhera.app.service.mq.model.HeraAppMessage;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rocketMqConsumerHera")
public class RocketMqHeraAppConsumer {
    private static final Logger log = LoggerFactory.getLogger(RocketMqHeraAppConsumer.class);
    @NacosValue(value="${rocket.mq.hera.app.topic}", autoRefreshed=true)
    private String consumerTopic;
    @NacosValue(value="${rocket.mq.hera.app.tag}", autoRefreshed=true)
    private String consumerTag;
    @NacosValue(value="${rocket.mq.producer.group}", autoRefreshed=true)
    private String consumerGroup;
    @NacosValue(value="${rocket.mq.srvAddr}", autoRefreshed=true)
    private String namesrvAddr;
    @NacosValue(value="${rocketmq.ak}", autoRefreshed=true)
    private String ak;
    @NacosValue(value="${rocketmq.sk}", autoRefreshed=true)
    private String sk;
    private DefaultMQPushConsumer heraAppMQPushConsumer;
    @Autowired
    HeraBaseInfoDao heraBaseInfoDao;
    @Autowired
    HeraAppRoleDao heraAppRoleDao;
    @Autowired
    RocketMqHeraAppProducer mqHeraAppProducer;
    @Autowired
    HeraAppBaseInfoService heraBaseInfoService;
    private AtomicBoolean rocketMqStartedStatus = new AtomicBoolean(false);

    @PostConstruct
    public void start() throws MQClientException {
        try {
            boolean b = this.rocketMqStartedStatus.compareAndSet(false, true);
            if (!b) {
                log.error("RocketMqHeraAppConsumer.heraAppMQPushConsumer start failed, it has started!!");
                return;
            }
            log.info("RocketMqHeraAppConsumer.heraAppMQPushConsumer init start!!");
            if (StringUtils.isNotEmpty((String)this.ak) && StringUtils.isNotEmpty((String)this.sk)) {
                SessionCredentials credentials = new SessionCredentials(this.ak, this.sk);
                AclClientRPCHook rpcHook = new AclClientRPCHook(credentials);
                this.heraAppMQPushConsumer = new DefaultMQPushConsumer(this.consumerGroup, (RPCHook)rpcHook, (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely());
            } else {
                this.heraAppMQPushConsumer = new DefaultMQPushConsumer(this.consumerGroup);
            }
            this.heraAppMQPushConsumer.setNamesrvAddr(this.namesrvAddr);
            this.heraAppMQPushConsumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
            this.heraAppMQPushConsumer.subscribe(this.consumerTopic, this.consumerTag);
            log.info("HeraApp#RocketMqHeraAppConsumer consumerTopic:{},consumerTag:{},consumerGroup:{}", new Object[]{this.consumerTopic, this.consumerTag, this.consumerGroup});
            this.heraAppMQPushConsumer.registerMessageListener((list, consumeOrderlyContext) -> {
                try {
                    list.stream().forEach(it -> {
                        log.info("RocketMqHeraAppConsumer# heraAppMQPushConsumer received message : MsgId: {}, Topic: {} Tags:{}", new Object[]{it.getMsgId(), it.getTopic(), it.getTags()});
                        this.consumeMessage((MessageExt)it);
                    });
                }
                catch (Exception e) {
                    log.info("RocketMqHeraAppConsumer# heraAppMQPushConsumer message error: {}", (Object)e.getMessage(), (Object)e);
                }
                return ConsumeOrderlyStatus.SUCCESS;
            });
            log.info("RocketMqHeraAppConsumer# heraAppMQPushConsumer init end!!");
            this.heraAppMQPushConsumer.start();
            log.info("RocketMqHeraAppConsumer# heraAppMQPushConsumer has started!!");
        }
        catch (MQClientException e) {
            log.error("RocketMqHeraAppConsumer# heraAppMQPushConsumer start error: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private void consumeMessage(MessageExt message) {
        log.info("RocketMqHeraAppConsumer# consumeMessage: {} {}", (Object)message.getMsgId(), (Object)new String(message.getBody()));
        try {
            byte[] body = message.getBody();
            HeraAppMessage heraAppMessage = (HeraAppMessage)new Gson().fromJson(new String(body), HeraAppMessage.class);
            log.info("RocketMqHeraAppConsumer# consumeMessage convert heraAppMessage : {}", (Object)heraAppMessage.toString());
            HeraAppBaseInfo changeHeraApp = heraAppMessage.baseInfo();
            HeraAppBaseInfo origHeraApp = this.matchExistHeraApp(heraAppMessage.baseInfo());
            if (heraAppMessage.getDelete() != null && heraAppMessage.getDelete() == 1) {
                if (origHeraApp == null) {
                    log.info("RocketMqHeraAppConsumer# delete hera app, no db data found! heraAppMessage : {}", (Object)heraAppMessage.toString());
                    return;
                }
                this.heraBaseInfoService.delById(origHeraApp.getId());
                log.info("RocketMqHeraAppConsumer# delete hera app info record:{}", (Object)heraAppMessage.toString());
                this.sendHeraAppModify(heraAppMessage.baseInfo(), origHeraApp, HeraAppModifyType.delete);
                return;
            }
            if (origHeraApp == null) {
                int create = this.heraBaseInfoService.create(changeHeraApp);
                String result = create == 1 ? "success!" : "fail!";
                log.info("RocketMqHeraAppConsumer#create heraAppBaseInfo : {}, result:{}", (Object)changeHeraApp.toString(), (Object)result);
            } else {
                changeHeraApp.setId(origHeraApp.getId());
                changeHeraApp.setStatus(0);
                int update = this.heraBaseInfoService.update(changeHeraApp);
                String result = update == 1 ? "success!" : "fail!";
                log.info("RocketMqHeraAppConsumer#update heraAppBaseInfo : {}, result:{}", (Object)changeHeraApp.toString(), (Object)result);
            }
            this.saveOrUpdateHeraAppRole(heraAppMessage.getJoinedMembers(), heraAppMessage.getId(), heraAppMessage.getPlatformType());
            this.sendHeraAppModify(heraAppMessage.baseInfo(), origHeraApp, origHeraApp == null ? HeraAppModifyType.create : HeraAppModifyType.update);
        }
        catch (Throwable ex) {
            log.error("RocketMqHeraAppConsumer#consumeMessage error:" + ex.getMessage(), ex);
        }
    }

    private HeraAppBaseInfo matchExistHeraApp(HeraAppBaseInfo heraAppBaseInfo) {
        HeraAppBaseInfoModel queryInfo = new HeraAppBaseInfoModel();
        queryInfo.setBindId(heraAppBaseInfo.getBindId());
        queryInfo.setPlatformType(heraAppBaseInfo.getPlatformType());
        queryInfo.setStatus(Integer.valueOf(0));
        List<HeraAppBaseInfo> query = this.heraBaseInfoService.query(queryInfo, null, null);
        if (CollectionUtils.isEmpty(query)) {
            return null;
        }
        if (query.size() > 1) {
            log.error("matchExistHeraApp#duplicate heraBaseInfo : {}", (Object)new Gson().toJson(query));
        }
        return query.get(0);
    }

    private void saveOrUpdateHeraAppRole(List<String> members, String appId, Integer platFormType) {
        log.info("RocketMqHeraAppConsumer#saveOrUpdateHeraAppRole appId:{},platFormType:{},members:{}", new Object[]{appId, platFormType, members});
        if (CollectionUtils.isEmpty(members)) {
            return;
        }
        HeraAppRole role = new HeraAppRole();
        role.setRole(0);
        role.setAppId(appId);
        role.setAppPlatform(platFormType);
        role.setStatus(0);
        List<HeraAppRole> query = this.heraAppRoleDao.query(role, null, 2000);
        if (CollectionUtils.isEmpty(query)) {
            List<HeraAppRole> roles = members.stream().filter(a -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)a)).map(t -> {
                HeraAppRole r = new HeraAppRole();
                r.setRole(0);
                r.setAppId(appId);
                r.setAppPlatform(platFormType);
                r.setStatus(0);
                r.setUser((String)t);
                return r;
            }).collect(Collectors.toList());
            this.heraAppRoleDao.batchCreate(roles);
            return;
        }
        List<HeraAppRole> delRoles = query.stream().filter(t -> !members.contains(t.getUser())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(delRoles)) {
            delRoles.forEach(t -> this.heraAppRoleDao.delById(t.getId()));
        }
        members.removeAll(query.stream().map(t -> t.getUser()).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(members)) {
            members.forEach(t -> {
                if (!StringUtils.isBlank((CharSequence)t)) {
                    HeraAppRole roleAdd = new HeraAppRole();
                    roleAdd.setRole(0);
                    roleAdd.setAppId(appId);
                    roleAdd.setAppPlatform(platFormType);
                    roleAdd.setStatus(0);
                    roleAdd.setUser((String)t);
                    this.heraAppRoleDao.create(roleAdd);
                }
            });
        }
    }

    private void sendHeraAppModify(HeraAppBaseInfo changeInfo, HeraAppBaseInfo origInfo, HeraAppModifyType modifyType) {
        HeraAppInfoModifyMessage modifyMsg = new HeraAppInfoModifyMessage();
        modifyMsg.setModifyType(modifyType);
        BeanUtils.copyProperties((Object)changeInfo, (Object)modifyMsg);
        modifyMsg.setAppId(Integer.valueOf(changeInfo.getBindId()));
        if (origInfo != null) {
            modifyMsg.setId(origInfo.getId());
        }
        if (HeraAppModifyType.update.equals((Object)modifyType)) {
            modifyMsg.setIsNameChange(Boolean.valueOf(!changeInfo.getAppName().equals(origInfo.getAppName())));
            modifyMsg.setIsIamTreeIdChange(Boolean.valueOf(!changeInfo.getIamTreeId().equals(origInfo.getIamTreeId())));
            modifyMsg.setIsIamTreeTypeChange(Boolean.valueOf(changeInfo.getIamTreeType() != null && !changeInfo.getIamTreeType().equals(origInfo.getIamTreeType())));
            modifyMsg.setIsPlatChange(Boolean.valueOf(!changeInfo.getPlatformType().equals(origInfo.getPlatformType())));
        }
        this.mqHeraAppProducer.pushHeraAppMsg(modifyMsg);
    }
}

