/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.alarmContact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.result.alertManager.AlertManagerFireResult;
import org.apache.ozhera.prometheus.agent.result.alertManager.Alerts;
import org.apache.ozhera.prometheus.agent.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAlertContact {
    private static final Logger log = LoggerFactory.getLogger(BaseAlertContact.class);
    Map<String, String> NAME_MAP = new HashMap<String, String>(){
        {
            this.put("application", "\u5e94\u7528");
            this.put("calert", "\u62a5\u8b66\u4e2d\u6587\u540d\u79f0");
            this.put("send_interval", "\u53d1\u9001\u95f4\u9694");
            this.put("container", "\u5bb9\u5668");
            this.put("namespace", "\u547d\u540d\u7a7a\u95f4");
            this.put("restartCounts", "\u91cd\u542f\u6b21\u6570");
            this.put("alert_key", "\u5173\u952e\u8bcd");
            this.put("startTime", "\u5f00\u59cb\u65f6\u95f4");
        }
    };
    String[] ALERT_INVISIBLE_LIST = new String[]{"system", "exceptViewLables", "app_iam_id", "metrics_flag", "group_key", "job", "image"};

    void Reach(AlertManagerFireResult fireResult) {
    }

    void filterName(Map<String, Object> map) {
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            for (String s : this.ALERT_INVISIBLE_LIST) {
                if (!StringUtils.containsIgnoreCase((CharSequence)key, (CharSequence)s)) continue;
                map.remove(key);
            }
        }
    }

    Map<String, Object> transferNames(Map<String, Object> map) {
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (!this.NAME_MAP.containsKey(key)) continue;
            Object value = entry.getValue();
            String newKey = this.NAME_MAP.get(key);
            map.remove(key);
            map.put(newKey, value);
        }
        return map;
    }

    String GenerateAlarmUrl(String prefix, Alerts alerts) {
        String metric_flag;
        Alerts fixAlerts = this.StringNull2Null(alerts);
        log.info("BaseAlertContact.GenerateAlarmUrl after fix alerts:{}", (Object)fixAlerts);
        String startsAt = alerts.getStartsAt();
        long alertTime = DateUtil.ISO8601UTCTOTimeStamp((String)startsAt);
        if (alertTime == -1L) {
            return "";
        }
        String startTime = String.valueOf(alertTime - 600000L);
        String endTime = String.valueOf(alertTime + 600000L);
        StringBuilder sb = new StringBuilder();
        String ip = fixAlerts.getLabels().getIp() == null ? "ip" : fixAlerts.getLabels().getIp();
        String serverIp = fixAlerts.getLabels().getServerIp() == null ? "serverIp" : fixAlerts.getLabels().getServerIp();
        String pod = fixAlerts.getLabels().getPod() == null ? "pod" : fixAlerts.getLabels().getPod();
        String serverEnv = fixAlerts.getLabels().getServerEnv() == null ? "serverEnv" : fixAlerts.getLabels().getServerEnv();
        String metric = fixAlerts.getLabels().getMetrics() == null ? "metric" : fixAlerts.getLabels().getMetrics();
        String string = metric_flag = fixAlerts.getLabels().getMetrics_flag() == null ? "metric_flag" : fixAlerts.getLabels().getMetrics_flag();
        if (!"metric_flag".equals(metric_flag)) {
            metric_flag = activeTab.getMessageByCode(Integer.parseInt(metric_flag));
        }
        sb.append(prefix).append("&var-Node=").append(ip).append("&ip=").append(serverIp).append("&var-pod=").append(pod).append("&var-instance=").append(serverIp).append("&serverEnv=").append(serverEnv).append("&heraEnv=").append(serverEnv).append("&startTime=").append(startTime).append("&endTime=").append(endTime).append("&from=").append(startTime).append("&to=").append(endTime).append("&metric=").append(metric).append("&activeTab=").append(metric_flag).append("&orgId=1").append("&refresh=10s");
        return sb.toString();
    }

    private Alerts StringNull2Null(Alerts alerts) {
        alerts.getLabels().setIp(Objects.equals(alerts.getLabels().getIp(), "null") ? null : alerts.getLabels().getIp());
        alerts.getLabels().setServerIp(Objects.equals(alerts.getLabels().getServerIp(), "null") ? null : alerts.getLabels().getServerIp());
        alerts.getLabels().setPod(Objects.equals(alerts.getLabels().getPod(), "null") ? null : alerts.getLabels().getPod());
        alerts.getLabels().setServerEnv(Objects.equals(alerts.getLabels().getServerEnv(), "null") ? null : alerts.getLabels().getServerEnv());
        alerts.getLabels().setMetrics(Objects.equals(alerts.getLabels().getMetrics(), "null") ? null : alerts.getLabels().getMetrics());
        alerts.getLabels().setMetrics_flag(Objects.equals(alerts.getLabels().getMetrics_flag(), "null") ? null : alerts.getLabels().getMetrics_flag());
        return alerts;
    }

    static enum activeTab {
        exception(1, "exception"),
        slowQuery(2, "slowQuery"),
        resource(4, "resource");

        private int code;
        private String message;

        private activeTab(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public static String getMessageByCode(int code) {
            for (activeTab tab : activeTab.values()) {
                if (tab.code != code) continue;
                return tab.message;
            }
            return null;
        }
    }
}

