/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.nutz.aop.AopCallback;
import org.nutz.aop.asm.AopInvokeAdpter;
import org.nutz.aop.asm.AopMethodAdapter;
import org.nutz.aop.asm.ChangeToChildConstructorMethodAdapter;
import org.nutz.conf.NutConf;
import org.nutz.repo.org.objectweb.asm.ClassWriter;
import org.nutz.repo.org.objectweb.asm.MethodVisitor;
import org.nutz.repo.org.objectweb.asm.Opcodes;
import org.nutz.repo.org.objectweb.asm.Type;

class ClassY
implements Opcodes {
    ClassWriter cw;
    String myName;
    String enhancedSuperName;
    Method[] methodArray;
    Constructor<?>[] constructors;
    private Class<?> superClass;

    ClassY(Class<?> klass, String myName, Method[] methodArray, Constructor<?>[] constructors) {
        this.myName = myName.replace('.', '/');
        this.enhancedSuperName = klass.getName().replace('.', '/');
        this.cw = new ClassWriter(2);
        this.cw.visit(NutConf.AOP_CLASS_LEVEL, 1, this.myName, null, this.enhancedSuperName, this.getParentInterfaces(klass));
        this.methodArray = methodArray;
        this.constructors = constructors;
        this.superClass = klass;
    }

    String[] getParentInterfaces(Class<?> xClass) {
        Class<?>[] its = xClass.getInterfaces();
        if (its == null || its.length == 0) {
            return new String[]{AopCallback.class.getName().replace('.', '/')};
        }
        String[] iii = new String[its.length + 1];
        for (int i = 0; i < its.length; ++i) {
            iii[i] = its[i].getName().replace('.', '/');
        }
        iii[its.length] = AopCallback.class.getName().replace('.', '/');
        return iii;
    }

    String[] convertExp(Class<?>[] expClasses) {
        if (expClasses.length == 0) {
            return null;
        }
        String[] results = new String[expClasses.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = expClasses[i].getName().replace('.', '/');
        }
        return results;
    }

    int getAccess(int modify) {
        if (Modifier.isProtected(modify)) {
            return 4;
        }
        if (Modifier.isPublic(modify)) {
            return 1;
        }
        return 0;
    }

    static int findMethodIndex(String name, String desc, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Type.getMethodDescriptor(method).equals(desc) || !method.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    void addConstructors() {
        for (Constructor<?> constructor : this.constructors) {
            String[] expClasses = this.convertExp(constructor.getExceptionTypes());
            String desc = Type.getConstructorDescriptor(constructor);
            int access = this.getAccess(constructor.getModifiers());
            MethodVisitor mv = this.cw.visitMethod(access, "<init>", desc, null, expClasses);
            new ChangeToChildConstructorMethodAdapter(mv, desc, access, this.enhancedSuperName).visitCode();
        }
    }

    byte[] toByteArray() {
        this.addField();
        this.addConstructors();
        this.addAopMethods();
        this.enhandMethod();
        this.cw.visitSource(this.superClass.getSimpleName() + ".java", null);
        return this.cw.toByteArray();
    }

    private void enhandMethod() {
        for (Method method : this.methodArray) {
            String methodName = method.getName();
            String methodDesc = Type.getMethodDescriptor(method);
            int methodAccess = this.getAccess(method.getModifiers());
            MethodVisitor mv = this.cw.visitMethod(methodAccess, methodName, methodDesc, null, this.convertExp(method.getExceptionTypes()));
            int methodIndex = ClassY.findMethodIndex(methodName, methodDesc, this.methodArray);
            AopMethodAdapter adapter = new AopMethodAdapter(mv, methodAccess, methodName, methodDesc, methodIndex, this.myName, this.enhancedSuperName);
            adapter.visitCode();
            adapter.visitAttribute();
        }
    }

    private void addAopMethods() {
        new AopInvokeAdpter(this.methodArray, this.cw.visitMethod(1, "_aop_invoke", "(I[Ljava/lang/Object;)Ljava/lang/Object;", null, null), 1, "invoke", "(I[Ljava/lang/Object;)Ljava/lang/Object;", 0, this.myName, this.enhancedSuperName).visitCode();
    }

    private void addField() {
        this.cw.visitField(10, "_$$Nut_methodArray", "[Ljava/lang/reflect/Method;", null, null).visitEnd();
        this.cw.visitField(10, "_$$Nut_methodInterceptorList", "[Ljava/util/List;", "[Ljava/util/List<Lorg/nutz/aop/MethodInterceptor;>;", null).visitEnd();
    }

    static <T> byte[] enhandClass(Class<T> kclass, String myName, Method[] methodArray, Constructor<?>[] constructors) {
        return new ClassY(kclass, myName, methodArray, constructors).toByteArray();
    }
}

