/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.cri;

import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.util.cri.AbstractSqlExpression;
import org.nutz.lang.Strings;

public class SqlValueRange
extends AbstractSqlExpression {
    private static final long serialVersionUID = 6899168558668898529L;
    protected String sql;
    protected Object[] values;
    protected int size;

    protected SqlValueRange(String name, String sql, Object ... values) {
        super(name);
        this.sql = sql;
        this.values = values;
        this.size = values.length;
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        if (this.size == 0) {
            return;
        }
        if (this.not) {
            sb.append(" NOT ");
        }
        sb.append(this._fmtcol(en));
        String tmp = Strings.dup("?,", this.size);
        sb.append(" IN (");
        sb.append(String.format(this.sql, tmp.substring(0, tmp.length() - 1)));
        sb.append(")");
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        if (this.size == 0) {
            return off;
        }
        MappingField mf = this._field(en);
        ValueAdaptor adaptor = null;
        if (mf == null) {
            for (Object object : this.values) {
                if (object == null) continue;
                adaptor = Jdbcs.getAdaptorBy(object);
                break;
            }
            if (adaptor == null) {
                adaptor = Jdbcs.Adaptor.asNull;
            }
        } else {
            adaptor = mf.getAdaptor();
        }
        for (int i = off; i < off + this.size; ++i) {
            adaptors[i] = adaptor;
        }
        return 0;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        for (int i = off; i < off + this.size; ++i) {
            params[i] = this.values[i];
        }
        return off + this.size;
    }

    @Override
    public int paramCount(Entity<?> en) {
        return this.size;
    }
}

