/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.lang.reflect.FastClass;
import org.nutz.lang.reflect.FastClassImpl;
import org.nutz.lang.reflect.FastMethod;
import org.nutz.lang.reflect.FastMethodFactory;
import org.nutz.repo.org.objectweb.asm.Opcodes;
import org.nutz.repo.org.objectweb.asm.Type;

public final class FastClassFactory
implements Opcodes {
    public static Map<String, FastClass> cache = new ConcurrentHashMap<String, FastClass>();
    private static final Object lock = new Object();
    protected static boolean useCache = true;

    public static boolean isUseCache() {
        return useCache;
    }

    public static void setUseCache(boolean useCache) {
        FastClassFactory.useCache = useCache;
    }

    public static void clearCache() {
        cache.clear();
        FastMethodFactory.cache.clear();
    }

    public static FastClass get(Class<?> klass) {
        String cacheKey = klass.getName() + "_" + klass.getClassLoader();
        FastClass fastClass = cache.get(cacheKey);
        if (fastClass != null) {
            return fastClass;
        }
        Object object = lock;
        synchronized (object) {
            fastClass = cache.get(cacheKey);
            if (fastClass != null) {
                return fastClass;
            }
            try {
                fastClass = FastClassFactory.create(klass);
                if (useCache) {
                    cache.put(cacheKey, fastClass);
                }
                return fastClass;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Fail to create FastClass for " + cacheKey, e);
            }
        }
    }

    public static FastMethod get(Method method) {
        return FastClassFactory.get(method.getDeclaringClass()).fast(method);
    }

    public static FastMethod get(Constructor<?> constructor) {
        return FastClassFactory.get(constructor.getDeclaringClass()).fast(constructor);
    }

    protected static synchronized FastClass create(Class<?> klass) {
        FastMethod fm;
        String key;
        HashMap<String, FastMethod> constructors = new HashMap<String, FastMethod>();
        HashMap<String, FastMethod> methods = new HashMap<String, FastMethod>();
        HashMap<String, FastMethod> fields = new HashMap<String, FastMethod>();
        for (Constructor<?> constructor : klass.getConstructors()) {
            key = Type.getConstructorDescriptor(constructor);
            fm = FastMethodFactory.make(constructor);
            constructors.put(key, fm);
        }
        for (Executable executable : klass.getMethods()) {
            if (((Method)executable).getName().contains("$")) continue;
            key = ((Method)executable).getName() + "$" + Type.getMethodDescriptor((Method)executable);
            fm = FastMethodFactory.make((Method)executable);
            methods.put(key, fm);
        }
        return new FastClassImpl(klass, constructors, methods, fields);
    }
}

