/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.all.client;

import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ozhera.prometheus.all.client.MetricsManager;
import org.apache.ozhera.prometheus.all.client.PrometheusCounter;
import org.apache.ozhera.prometheus.all.client.PrometheusGauge;
import org.apache.ozhera.prometheus.all.client.PrometheusHistogram;
import org.apache.ozhera.prometheus.all.client.XmCounter;
import org.apache.ozhera.prometheus.all.client.XmGauge;
import org.apache.ozhera.prometheus.all.client.XmHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Prometheus
implements MetricsManager {
    private static final Logger log = LoggerFactory.getLogger(Prometheus.class);
    public static final int CONST_LABELS_NUM = 2;
    public static final PrometheusMeterRegistry REGISTRY = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
    public static Map<String, String> constLabels;
    public Map<String, Object> prometheusMetrics;
    public Map<String, Object> prometheusTypeMetrics;
    private ReentrantLock lock = new ReentrantLock();
    private ReentrantLock typeLock = new ReentrantLock();

    public Prometheus() {
        this.prometheusMetrics = new ConcurrentHashMap<String, Object>();
        this.prometheusTypeMetrics = new ConcurrentHashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmCounter newCounter(String metricName, String ... labelName) {
        if (this.prometheusTypeMetrics.containsKey(metricName)) {
            return (XmCounter)this.prometheusTypeMetrics.get(metricName);
        }
        this.typeLock.lock();
        try {
            PrometheusCounter prometheusCounter = new PrometheusCounter(this.getCounter(metricName, labelName), labelName, null);
            this.prometheusTypeMetrics.put(metricName, prometheusCounter);
            PrometheusCounter prometheusCounter2 = prometheusCounter;
            return prometheusCounter2;
        }
        finally {
            this.typeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmGauge newGauge(String metricName, String ... labelName) {
        if (this.prometheusTypeMetrics.containsKey(metricName)) {
            return (XmGauge)this.prometheusTypeMetrics.get(metricName);
        }
        this.typeLock.lock();
        try {
            PrometheusGauge prometheusGauge = new PrometheusGauge(this.getGauge(metricName, labelName), labelName, null);
            this.prometheusTypeMetrics.put(metricName, prometheusGauge);
            PrometheusGauge prometheusGauge2 = prometheusGauge;
            return prometheusGauge2;
        }
        finally {
            this.typeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmHistogram newHistogram(String metricName, double[] bucket, String ... labelNames) {
        if (this.prometheusTypeMetrics.containsKey(metricName)) {
            return (XmHistogram)this.prometheusTypeMetrics.get(metricName);
        }
        this.typeLock.lock();
        try {
            PrometheusHistogram prometheusHistogram = new PrometheusHistogram(this.getHistogram(metricName, bucket, labelNames), labelNames, null);
            this.prometheusTypeMetrics.put(metricName, prometheusHistogram);
            PrometheusHistogram prometheusHistogram2 = prometheusHistogram;
            return prometheusHistogram2;
        }
        finally {
            this.typeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter getCounter(String metricName, String ... labelName) {
        if (constLabels.size() != 2) {
            return null;
        }
        if (this.prometheusMetrics.containsKey(metricName)) {
            return (Counter)this.prometheusMetrics.get(metricName);
        }
        this.lock.lock();
        try {
            ArrayList<String> mylist = new ArrayList<String>(Arrays.asList(labelName));
            mylist.add("application");
            String[] finalValue = mylist.toArray(new String[mylist.size()]);
            Counter newCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(metricName)).namespace(constLabels.get("group") + "_" + constLabels.get("service"))).labelNames(finalValue)).help(metricName)).register();
            this.prometheusMetrics.put(metricName, newCounter);
            Counter counter = newCounter;
            this.lock.unlock();
            return counter;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (Throwable throwable2) {
                log.warn(throwable2.getMessage());
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gauge getGauge(String metricName, String ... labelName) {
        if (constLabels.size() != 2) {
            return null;
        }
        if (this.prometheusMetrics.containsKey(metricName)) {
            return (Gauge)this.prometheusMetrics.get(metricName);
        }
        this.lock.lock();
        try {
            ArrayList<String> mylist = new ArrayList<String>(Arrays.asList(labelName));
            mylist.add("application");
            String[] finalValue = mylist.toArray(new String[mylist.size()]);
            Gauge newGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(metricName)).namespace(constLabels.get("group") + "_" + constLabels.get("service"))).labelNames(finalValue)).help(metricName)).register();
            this.prometheusMetrics.put(metricName, newGauge);
            Gauge gauge = newGauge;
            this.lock.unlock();
            return gauge;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (Throwable throwable2) {
                log.warn(throwable2.getMessage());
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Histogram getHistogram(String metricName, double[] buckets, String ... labelNames) {
        if (constLabels.size() != 2) {
            return null;
        }
        if (this.prometheusMetrics.containsKey(metricName)) {
            return (Histogram)this.prometheusMetrics.get(metricName);
        }
        this.lock.lock();
        try {
            ArrayList<String> mylist = new ArrayList<String>(Arrays.asList(labelNames));
            mylist.add("application");
            String[] finalValue = mylist.toArray(new String[mylist.size()]);
            Histogram newHistogram = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(buckets).name(metricName)).namespace(constLabels.get("group") + "_" + constLabels.get("service"))).labelNames(finalValue)).help(metricName)).register();
            this.prometheusMetrics.put(metricName, newHistogram);
            Histogram histogram = newHistogram;
            this.lock.unlock();
            return histogram;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (Throwable throwable2) {
                log.warn(throwable2.getMessage());
                return null;
            }
        }
    }
}

