/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.all.client.binder;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.function.ToLongFunction;

@NonNullApi
@NonNullFields
public class JvmMemoryMetricsReduced
implements MeterBinder {
    private final Iterable<Tag> tags;

    public JvmMemoryMetricsReduced() {
        this(Collections.emptyList());
    }

    public JvmMemoryMetricsReduced(Iterable<Tag> tags) {
        this.tags = tags;
    }

    public void bindTo(MeterRegistry registry) {
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            Tags tagsWithId = Tags.concat(this.tags, (String[])new String[]{"id", bufferPoolBean.getName()});
            Gauge.builder((String)"jvm.buffer.memory.used", (Object)bufferPoolBean, BufferPoolMXBean::getMemoryUsed).tags((Iterable)tagsWithId).description("An estimate of the memory that the Java virtual machine is using for this buffer pool").baseUnit("bytes").register(registry);
            Gauge.builder((String)"jvm.buffer.total.capacity", (Object)bufferPoolBean, BufferPoolMXBean::getTotalCapacity).tags((Iterable)tagsWithId).description("An estimate of the total capacity of the buffers in this pool").baseUnit("bytes").register(registry);
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            String area = MemoryType.HEAP.equals((Object)memoryPoolBean.getType()) ? "heap" : "nonheap";
            Tags tagsWithId = Tags.concat(this.tags, (String[])new String[]{"id", memoryPoolBean.getName(), "area", area});
            Gauge.builder((String)"jvm.memory.used", (Object)memoryPoolBean, mem -> this.getUsageValue((MemoryPoolMXBean)mem, MemoryUsage::getUsed)).tags((Iterable)tagsWithId).description("The amount of used memory").baseUnit("bytes").register(registry);
            Gauge.builder((String)"jvm.memory.committed", (Object)memoryPoolBean, mem -> this.getUsageValue((MemoryPoolMXBean)mem, MemoryUsage::getCommitted)).tags((Iterable)tagsWithId).description("The amount of memory in bytes that is committed for the Java virtual machine to use").baseUnit("bytes").register(registry);
            Gauge.builder((String)"jvm.memory.max", (Object)memoryPoolBean, mem -> this.getUsageValue((MemoryPoolMXBean)mem, MemoryUsage::getMax)).tags((Iterable)tagsWithId).description("The maximum amount of memory in bytes that can be used for memory management").baseUnit("bytes").register(registry);
        }
    }

    private double getUsageValue(MemoryPoolMXBean memoryPoolMXBean, ToLongFunction<MemoryUsage> getter) {
        MemoryUsage usage = this.getUsage(memoryPoolMXBean);
        return usage == null ? Double.NaN : (double)getter.applyAsLong(usage);
    }

    @Nullable
    private MemoryUsage getUsage(MemoryPoolMXBean memoryPoolMXBean) {
        try {
            return memoryPoolMXBean.getUsage();
        }
        catch (InternalError var3) {
            return null;
        }
    }
}

