/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc;

import com.xiaomi.youpin.docean.config.HttpServerConfig;
import com.xiaomi.youpin.docean.mvc.HttpHandlerRead;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpHandler.class);
    private HttpServerConfig config;

    public HttpHandler(HttpServerConfig config) {
        this.config = config;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (this.config.isUseWs() && "/ws".equalsIgnoreCase(request.uri())) {
            ctx.fireChannelRead((Object)request.retain());
            return;
        }
        HttpHandlerRead.read(ctx, (HttpObject)request, this.config);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        DecoderException ex;
        if (cause instanceof DecoderException && (ex = (DecoderException)cause).getMessage().contains("certificate_unknown")) {
            return;
        }
        log.info("remote address:{} error:{}", (Object)ctx.channel().remoteAddress(), (Object)cause.getMessage());
        if (null != ctx.channel() && ctx.channel().isOpen() && ctx.channel().isActive()) {
            ctx.channel().close();
        }
    }
}

