/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.bo.Bean;
import com.xiaomi.youpin.docean.common.ReflectUtils;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Plugin {
    private List<IPlugin> plugins;

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        this.plugins = classSet.stream().filter(it -> ReflectUtils.getAnno((Class)it, (List)Lists.newArrayList((Object[])new Class[]{DOceanPlugin.class})).isPresent()).sorted((a, b) -> {
            DOceanPlugin an = a.getAnnotation(DOceanPlugin.class);
            DOceanPlugin bn = b.getAnnotation(DOceanPlugin.class);
            return an.order() - bn.order();
        }).map(c -> (IPlugin)ReflectUtils.getInstance((Class)c)).filter(it -> !it.disable(ioc)).peek(ins -> ins.init(classSet, ioc)).collect(Collectors.toList());
        this.plugins.stream().forEach(p -> ioc.putBean(p));
    }

    public void after(Ioc ioc) {
        this.plugins.stream().forEach(p -> p.after(ioc));
    }

    public void start(Ioc ioc) {
        this.plugins.stream().forEach(p -> p.start(ioc));
    }

    public void putBean(String name, Bean bean) {
        this.plugins.stream().forEach(p -> p.putBean(name, bean));
    }

    public void destory(Ioc ioc) {
        this.plugins.forEach(it -> it.destory(ioc));
    }

    public static final Plugin ins() {
        return LazyHolder.ins;
    }

    public void initBean(Ioc ioc, Bean bean) {
        this.plugins.stream().forEach(plugin -> plugin.initBean(ioc, bean));
    }

    public String initIoc(Ioc ioc, Class type, Annotation[] anns, Supplier<String> supplier) {
        return this.plugins.stream().map(plugin -> {
            Optional<String> obj = plugin.ioc(ioc, type, anns);
            return obj;
        }).filter(it -> it.isPresent()).map(it -> (String)it.get()).findAny().orElse(supplier.get());
    }

    public List<Class<? extends Annotation>> filterAnnotationList() {
        return this.plugins.stream().map(it -> it.filterAnnotations()).flatMap(l -> l.stream()).collect(Collectors.toList());
    }

    public List<Class<? extends Annotation>> filterResourceAnnotationList() {
        return this.plugins.stream().map(it -> it.filterResourceAnnotations()).flatMap(l -> l.stream()).collect(Collectors.toList());
    }

    public String getInitMethodName(Object obj, Class clazz) {
        return this.plugins.stream().map(it -> it.getInitMethodName(obj, clazz)).filter(it -> !it.equals("init")).findAny().orElse("init");
    }

    public String getDestoryMethodName(Object obj, Class clazz) {
        return this.plugins.stream().map(it -> it.getDestoryMethodName(obj, clazz)).filter(it -> !it.equals("destory")).findAny().orElse("destory");
    }

    public List<IPlugin> getPlugins() {
        return this.plugins;
    }

    private static final class LazyHolder {
        private static final Plugin ins = new Plugin();

        private LazyHolder() {
        }
    }
}

