/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.lookup.SourceLookup;

public interface FetchSubPhase {
    public FetchSubPhaseProcessor getProcessor(FetchContext var1) throws IOException;

    public static class HitContext {
        private final SearchHit hit;
        private final LeafReaderContext readerContext;
        private final int docId;
        private final SourceLookup sourceLookup;
        private final Map<String, Object> cache;

        public HitContext(SearchHit hit, LeafReaderContext context, int docId, SourceLookup sourceLookup, Map<String, Object> cache) {
            this.hit = hit;
            this.readerContext = context;
            this.docId = docId;
            this.sourceLookup = sourceLookup;
            sourceLookup.setSegmentAndDocument(context, docId);
            this.cache = cache;
        }

        public SearchHit hit() {
            return this.hit;
        }

        public LeafReader reader() {
            return this.readerContext.reader();
        }

        public LeafReaderContext readerContext() {
            return this.readerContext;
        }

        public int docId() {
            return this.docId;
        }

        public SourceLookup sourceLookup() {
            return this.sourceLookup;
        }

        public IndexReader topLevelReader() {
            return ReaderUtil.getTopLevelContext((IndexReaderContext)this.readerContext).reader();
        }

        public Map<String, Object> cache() {
            return this.cache;
        }
    }
}

