/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.es.antlr4.impl;

import com.xiaomi.youpin.docean.plugin.es.antlr4.common.context.ValueContext;
import com.xiaomi.youpin.docean.plugin.es.antlr4.common.enums.ValueTypeEnum;
import com.xiaomi.youpin.docean.plugin.es.antlr4.common.util.MergeUtils;
import com.xiaomi.youpin.docean.plugin.es.antlr4.common.util.StrUtils;
import com.xiaomi.youpin.docean.plugin.es.antlr4.query.EsQueryListener;
import com.xiaomi.youpin.docean.plugin.es.antlr4.query.EsQueryParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class EsQueryTransfer
implements EsQueryListener {
    private static final String WAVY_LINE_MARK = "~";
    private static final String DOUBLE_QUOTATION_MARK = "\"";
    private ParseTreeProperty<SearchSourceBuilder> treeProperty = new ParseTreeProperty();
    private ParseTreeProperty<ValueContext> valueProperty = new ParseTreeProperty();

    @Override
    public void enterParse(EsQueryParser.ParseContext ctx) {
    }

    @Override
    public void exitParse(EsQueryParser.ParseContext ctx) {
    }

    @Override
    public void enterOrExpression(EsQueryParser.OrExpressionContext ctx) {
    }

    @Override
    public void exitOrExpression(EsQueryParser.OrExpressionContext ctx) {
        ParseTree expression1 = (ParseTree)ctx.children.get(0);
        ParseTree expression2 = (ParseTree)ctx.children.get(2);
        SearchSourceBuilder sourceBuilder = MergeUtils.MergeOr((SearchSourceBuilder)this.treeProperty.get(expression1), (SearchSourceBuilder)this.treeProperty.get(expression2));
        this.treeProperty.put((ParseTree)ctx, (Object)sourceBuilder);
    }

    @Override
    public void enterAndExpression(EsQueryParser.AndExpressionContext ctx) {
    }

    @Override
    public void exitAndExpression(EsQueryParser.AndExpressionContext ctx) {
        ParseTree expression1 = (ParseTree)ctx.children.get(0);
        ParseTree expression2 = (ParseTree)ctx.children.get(2);
        SearchSourceBuilder sourceBuilder = MergeUtils.MergeAnd((SearchSourceBuilder)this.treeProperty.get(expression1), (SearchSourceBuilder)this.treeProperty.get(expression2));
        this.treeProperty.put((ParseTree)ctx, (Object)sourceBuilder);
    }

    @Override
    public void enterAggreExpression(EsQueryParser.AggreExpressionContext ctx) {
    }

    @Override
    public void exitAggreExpression(EsQueryParser.AggreExpressionContext ctx) {
        this.treeProperty.put((ParseTree)ctx, (Object)((SearchSourceBuilder)this.treeProperty.get(ctx.getChild(0))));
    }

    @Override
    public void enterNotExpression(EsQueryParser.NotExpressionContext ctx) {
    }

    @Override
    public void exitNotExpression(EsQueryParser.NotExpressionContext ctx) {
        if ("not".equals(((ParseTree)ctx.children.get(0)).getText()) || "NOT".equals(((ParseTree)ctx.children.get(0)).getText())) {
            ParseTree tree = (ParseTree)ctx.children.get(1);
            SearchSourceBuilder sourceBuilder = MergeUtils.MergeNot((SearchSourceBuilder)this.treeProperty.get(tree));
            this.treeProperty.put((ParseTree)ctx, (Object)sourceBuilder);
        } else {
            ParseTree tree = (ParseTree)ctx.children.get(2);
            SearchSourceBuilder sourceBuilder = MergeUtils.MergeNot((SearchSourceBuilder)this.treeProperty.get(tree));
            this.treeProperty.put((ParseTree)ctx, (Object)MergeUtils.MergeAnd((SearchSourceBuilder)this.treeProperty.get((ParseTree)ctx.children.get(0)), sourceBuilder));
        }
    }

    @Override
    public void enterParenExpression(EsQueryParser.ParenExpressionContext ctx) {
    }

    @Override
    public void exitParenExpression(EsQueryParser.ParenExpressionContext ctx) {
        ParseTree tree = (ParseTree)ctx.children.get(1);
        this.treeProperty.put((ParseTree)ctx, (Object)((SearchSourceBuilder)this.treeProperty.get(tree)));
    }

    @Override
    public void enterCommonExpression(EsQueryParser.CommonExpressionContext ctx) {
    }

    @Override
    public void exitCommonExpression(EsQueryParser.CommonExpressionContext ctx) {
        ParseTree tree = ctx.getChild(0);
        this.treeProperty.put((ParseTree)ctx, (Object)((SearchSourceBuilder)this.treeProperty.get(tree)));
    }

    @Override
    public void enterLtExpr(EsQueryParser.LtExprContext ctx) {
    }

    @Override
    public void exitLtExpr(EsQueryParser.LtExprContext ctx) {
        String param = ctx.getChild(0).getText();
        ParseTree valueNode = ctx.getChild(2);
        ValueContext value = (ValueContext)this.valueProperty.get(valueNode);
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)new RangeQueryBuilder(param).lt(value.getValue())));
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterGtExpr(EsQueryParser.GtExprContext ctx) {
    }

    @Override
    public void exitGtExpr(EsQueryParser.GtExprContext ctx) {
        String param = ctx.getChild(0).getText();
        ValueContext value = (ValueContext)this.valueProperty.get(ctx.getChild(2));
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)new RangeQueryBuilder(param).gt(value.getValue())));
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterLeExpr(EsQueryParser.LeExprContext ctx) {
    }

    @Override
    public void exitLeExpr(EsQueryParser.LeExprContext ctx) {
        String param = ctx.getChild(0).getText();
        ValueContext value = (ValueContext)this.valueProperty.get(ctx.getChild(2));
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)new RangeQueryBuilder(param).lte(value.getValue())));
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterGeExpr(EsQueryParser.GeExprContext ctx) {
    }

    @Override
    public void exitGeExpr(EsQueryParser.GeExprContext ctx) {
        String param = ctx.getChild(0).getText();
        ValueContext value = (ValueContext)this.valueProperty.get(ctx.getChild(2));
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)new RangeQueryBuilder(param).gte(value.getValue())));
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterNeExpr(EsQueryParser.NeExprContext ctx) {
    }

    @Override
    public void exitNeExpr(EsQueryParser.NeExprContext ctx) {
        String param = ctx.getChild(0).getText();
        ValueContext value = (ValueContext)this.valueProperty.get(ctx.getChild(2));
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().mustNot((QueryBuilder)QueryBuilders.termQuery((String)param, (Object)value.getValue())));
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterEqExpr(EsQueryParser.EqExprContext ctx) {
    }

    @Override
    public void exitEqExpr(EsQueryParser.EqExprContext ctx) {
        String param = ctx.getChild(0).getText();
        ValueContext value = (ValueContext)this.valueProperty.get(ctx.getChild(2));
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (null == value) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.queryStringQuery((String)param));
        } else {
            switch (value.getType()) {
                case IPV4: 
                case IPV6: {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.prefixQuery((String)param, (String)value.getValue().toString()));
                    break;
                }
                default: {
                    if (value.getValue().toString().startsWith(WAVY_LINE_MARK)) {
                        boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)param, (Object)value.getValue().toString().substring(1)));
                        break;
                    }
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)param, (Object)value.getValue()));
                }
            }
        }
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder);
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterLikeExpr(EsQueryParser.LikeExprContext ctx) {
    }

    @Override
    public void exitLikeExpr(EsQueryParser.LikeExprContext ctx) {
        String param = ctx.getChild(0).getText();
        String value = ((ValueContext)this.valueProperty.get(ctx.getChild(2))).getValue().toString();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.fuzzyQuery((String)param, (String)value).fuzziness(Fuzziness.AUTO)));
        this.treeProperty.put((ParseTree)ctx, (Object)sourceBuilder);
    }

    @Override
    public void enterContainExpr(EsQueryParser.ContainExprContext ctx) {
    }

    @Override
    public void exitContainExpr(EsQueryParser.ContainExprContext ctx) {
        String param = ctx.getChild(0).getText();
        ValueContext value = (ValueContext)this.valueProperty.get(ctx.getChild(2));
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.wildcardQuery((String)param, (String)("*" + value.getValue().toString() + "*"))));
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterNotContainExpr(EsQueryParser.NotContainExprContext ctx) {
    }

    @Override
    public void exitNotContainExpr(EsQueryParser.NotContainExprContext ctx) {
        String param = ctx.getChild(0).getText();
        ValueContext value = (ValueContext)this.valueProperty.get(ctx.getChild(2));
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)param, (String)("*" + value.getValue().toString() + "*"))));
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterInExpr(EsQueryParser.InExprContext ctx) {
    }

    @Override
    public void exitInExpr(EsQueryParser.InExprContext ctx) {
        String param = ctx.getChild(0).getText();
        ArrayList value = (ArrayList)((ValueContext)this.valueProperty.get(ctx.getChild(2))).getValue();
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termsQuery((String)param, (Collection)value)));
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterNotInExpr(EsQueryParser.NotInExprContext ctx) {
    }

    @Override
    public void exitNotInExpr(EsQueryParser.NotInExprContext ctx) {
    }

    @Override
    public void enterExistExpr(EsQueryParser.ExistExprContext ctx) {
    }

    @Override
    public void exitExistExpr(EsQueryParser.ExistExprContext ctx) {
        String param = ctx.getChild(0).getText();
        SearchSourceBuilder builder = new SearchSourceBuilder();
        ExistsQueryBuilder existsQuery = QueryBuilders.existsQuery((String)param);
        builder.query((QueryBuilder)existsQuery);
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterNotExistExpr(EsQueryParser.NotExistExprContext ctx) {
    }

    @Override
    public void exitNotExistExpr(EsQueryParser.NotExistExprContext ctx) {
        String param = ctx.getChild(0).getText();
        SearchSourceBuilder builder = new SearchSourceBuilder();
        BoolQueryBuilder existsQuery = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)param));
        builder.query((QueryBuilder)existsQuery);
        this.treeProperty.put((ParseTree)ctx, (Object)builder);
    }

    @Override
    public void enterRegexExpr(EsQueryParser.RegexExprContext ctx) {
    }

    @Override
    public void exitRegexExpr(EsQueryParser.RegexExprContext ctx) {
        String param = ctx.getChild(0).getText();
        String value = ((ValueContext)this.valueProperty.get(ctx.getChild(2))).getValue().toString();
        if (value.startsWith(DOUBLE_QUOTATION_MARK) && value.endsWith(DOUBLE_QUOTATION_MARK)) {
            value = StrUtils.substringBetween(value, DOUBLE_QUOTATION_MARK);
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.regexpQuery((String)param, (String)value)));
        this.treeProperty.put((ParseTree)ctx, (Object)sourceBuilder);
    }

    @Override
    public void enterArray(EsQueryParser.ArrayContext ctx) {
    }

    @Override
    public void exitArray(EsQueryParser.ArrayContext ctx) {
        List children = ctx.children;
        List list = children.stream().filter(x -> x.getChildCount() >= 1).map(x -> ((ValueContext)this.valueProperty.get(x)).getValue()).collect(Collectors.toList());
        this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.ARRAY, list));
    }

    @Override
    public void enterMaxAggExpr(EsQueryParser.MaxAggExprContext ctx) {
    }

    @Override
    public void exitMaxAggExpr(EsQueryParser.MaxAggExprContext ctx) {
    }

    @Override
    public void enterMinAggExpr(EsQueryParser.MinAggExprContext ctx) {
    }

    @Override
    public void exitMinAggExpr(EsQueryParser.MinAggExprContext ctx) {
    }

    @Override
    public void enterAvgAggExpr(EsQueryParser.AvgAggExprContext ctx) {
    }

    @Override
    public void exitAvgAggExpr(EsQueryParser.AvgAggExprContext ctx) {
    }

    @Override
    public void enterGroupAggExpr(EsQueryParser.GroupAggExprContext ctx) {
    }

    @Override
    public void exitGroupAggExpr(EsQueryParser.GroupAggExprContext ctx) {
        String param = ctx.getChild(0).getText();
        if (Objects.isNull(this.treeProperty.get(ctx.getChild(3)))) {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().aggregation((AggregationBuilder)AggregationBuilders.terms((String)param));
            this.treeProperty.put((ParseTree)ctx, (Object)sourceBuilder);
        } else {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().aggregation((AggregationBuilder)AggregationBuilders.terms((String)param));
            sourceBuilder.query(((SearchSourceBuilder)this.treeProperty.get(ctx.getChild(3))).query());
            this.treeProperty.put((ParseTree)ctx, (Object)sourceBuilder);
        }
    }

    @Override
    public void enterParenValve(EsQueryParser.ParenValveContext ctx) {
    }

    @Override
    public void exitParenValve(EsQueryParser.ParenValveContext ctx) {
        if (ctx.getChildCount() < 2) {
            this.treeProperty.put((ParseTree)ctx, null);
        }
        this.valueProperty.put((ParseTree)ctx, (Object)((ValueContext)this.valueProperty.get(ctx.getChild(1))));
    }

    @Override
    public void enterParam(EsQueryParser.ParamContext ctx) {
    }

    @Override
    public void exitParam(EsQueryParser.ParamContext ctx) {
    }

    @Override
    public void enterIpV4Value(EsQueryParser.IpV4ValueContext ctx) {
    }

    @Override
    public void exitIpV4Value(EsQueryParser.IpV4ValueContext ctx) {
        String ip = ctx.getChild(0).getText();
        if (ip.contains("/")) {
            ip = ip.substring(0, ip.indexOf("/"));
        }
        int index = ip.length();
        if (ip.contains("*")) {
            index = Math.min(ip.indexOf("*"), index);
        }
        ip = ip.substring(0, index);
        this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.IPV4, ip));
    }

    @Override
    public void enterStringValue(EsQueryParser.StringValueContext ctx) {
    }

    @Override
    public void exitStringValue(EsQueryParser.StringValueContext ctx) {
        String str = ctx.getChild(0).getText();
        str = str.substring(1, str.length() - 1);
        this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.STRING, str));
    }

    @Override
    public void enterNumberValue(EsQueryParser.NumberValueContext ctx) {
    }

    @Override
    public void exitNumberValue(EsQueryParser.NumberValueContext ctx) {
        long number = Long.parseLong(ctx.getChild(0).getText());
        this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.NUMBER, number));
    }

    @Override
    public void enterTimeValue(EsQueryParser.TimeValueContext ctx) {
    }

    @Override
    public void exitTimeValue(EsQueryParser.TimeValueContext ctx) {
        String time = ctx.getChild(0).getText();
        StringBuilder res = new StringBuilder();
        if (time.length() < 20) {
            for (char c : time.toCharArray()) {
                res.append(c);
            }
            res.append(".000");
        }
        this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.TIME, res.toString()));
    }

    @Override
    public void enterTrueValue(EsQueryParser.TrueValueContext ctx) {
    }

    @Override
    public void exitTrueValue(EsQueryParser.TrueValueContext ctx) {
        this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.TRUE, Boolean.TRUE));
    }

    @Override
    public void enterFalseValue(EsQueryParser.FalseValueContext ctx) {
    }

    @Override
    public void exitFalseValue(EsQueryParser.FalseValueContext ctx) {
        this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.FALSE, Boolean.FALSE));
    }

    @Override
    public void enterNullValue(EsQueryParser.NullValueContext ctx) {
    }

    @Override
    public void exitNullValue(EsQueryParser.NullValueContext ctx) {
        this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.NULL, null));
    }

    @Override
    public void enterIdentifierValue(EsQueryParser.IdentifierValueContext ctx) {
    }

    @Override
    public void exitIdentifierValue(EsQueryParser.IdentifierValueContext ctx) {
        if (ctx.getParent() instanceof EsQueryParser.EqExprContext) {
            this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.EQUAL, ctx.getChild(0).getText()));
        } else if (ctx.getParent() instanceof EsQueryParser.NeExprContext) {
            this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.IDENTIFY, ctx.getChild(0).getText()));
        } else if (ctx.getParent() instanceof EsQueryParser.ArrayContext) {
            this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.STRING, ctx.getChild(0).getText()));
        } else {
            String value = ctx.getChild(0).getText();
            if (null == value) {
                value = ((ValueContext)this.valueProperty.get((ParseTree)ctx.children.get(1))).getValue().toString();
            }
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query((QueryBuilder)QueryBuilders.queryStringQuery((String)value));
            this.treeProperty.put((ParseTree)ctx, (Object)sourceBuilder);
        }
    }

    @Override
    public void enterRegex(EsQueryParser.RegexContext ctx) {
    }

    @Override
    public void exitRegex(EsQueryParser.RegexContext ctx) {
        String value = ctx.getChild(0).getText();
        this.valueProperty.put((ParseTree)ctx, (Object)new ValueContext(ValueTypeEnum.REGEX, value));
    }

    public void visitTerminal(TerminalNode terminalNode) {
    }

    public void visitErrorNode(ErrorNode errorNode) {
    }

    public void enterEveryRule(ParserRuleContext parserRuleContext) {
    }

    public void exitEveryRule(ParserRuleContext parserRuleContext) {
    }

    public SearchSourceBuilder getBuilder(ParseTree tree) {
        return (SearchSourceBuilder)this.treeProperty.get(tree);
    }
}

