/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.comparator;

import org.apache.ozhera.log.agent.channel.comparator.SimilarComparator;
import org.apache.ozhera.log.agent.input.Input;
import org.apache.ozhera.log.common.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputSimilarComparator
implements SimilarComparator<Input> {
    private static final Logger log = LoggerFactory.getLogger(InputSimilarComparator.class);
    private Input oldInput;

    public InputSimilarComparator(Input oldInput) {
        this.oldInput = oldInput;
    }

    @Override
    public boolean compare(Input newInput) {
        if (null == this.oldInput) {
            return false;
        }
        if (this.oldInput == newInput) {
            return true;
        }
        return this.baseSimilarCompare(newInput);
    }

    private boolean baseSimilarCompare(Input newInput) {
        try {
            if (this.oldInput.equals(newInput)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("input compare error:new input:{},oldInput:{}", new Object[]{Constant.GSON.toJson((Object)newInput), Constant.GSON.toJson((Object)this.oldInput), e});
        }
        return false;
    }
}

