/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.file;

import com.google.common.collect.Lists;
import com.xiaomi.mone.file.LogFile;
import com.xiaomi.youpin.docean.anno.Service;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.ozhera.log.agent.channel.file.FileListener;
import org.apache.ozhera.log.agent.channel.file.FileWatcher;
import org.apache.ozhera.log.agent.channel.file.LogFileAlterationObserver;
import org.apache.ozhera.log.common.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class FileMonitor
implements FileWatcher {
    private static final Logger log = LoggerFactory.getLogger(FileMonitor.class);

    @Override
    public void watch(String filePattern, List<FileAlterationMonitor> monitorList, Consumer<String> consumer) {
        ArrayList watchList = Lists.newArrayList((Object[])new String[]{filePattern});
        FileAlterationMonitor monitor = new FileAlterationMonitor(10000L);
        log.info("agent monitor files:{}", (Object)Constant.GSON.toJson((Object)watchList));
        for (String watch : watchList) {
            LogFileAlterationObserver observer = new LogFileAlterationObserver(new File(watch));
            observer.addListener(new FileListener(consumer));
            log.info("## agent monitor file:{}, filePattern:{}", (Object)watch, (Object)filePattern);
            monitor.addObserver((FileAlterationObserver)observer);
        }
        try {
            monitor.start();
            log.info("## agent monitor filePattern:{} started", (Object)filePattern);
            monitorList.add(monitor);
        }
        catch (Exception e) {
            log.error(String.format("agent file monitor start err,monitor filePattern:%s", filePattern), (Throwable)e);
        }
    }

    @Override
    public void watch(LogFile logFile) {
    }

    @Override
    public void onChange() {
    }
}

