/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.file;

import java.util.regex.Pattern;
import org.apache.ozhera.log.api.enums.LogTypeEnum;

public class MonitorFile {
    private String realFilePath;
    private String monitorFileExpress;
    private Pattern filePattern;
    private boolean collectOnce;
    private LogTypeEnum logTypeEnum;

    public MonitorFile(String realFilePath, String monitorFileExpress, LogTypeEnum logTypeEnum, boolean collectOnce) {
        this.realFilePath = realFilePath;
        this.monitorFileExpress = monitorFileExpress;
        this.filePattern = Pattern.compile(monitorFileExpress);
        this.logTypeEnum = logTypeEnum;
        this.collectOnce = collectOnce;
    }

    public static MonitorFile of(String realFilePath, String monitorFileExpress, LogTypeEnum logTypeEnum, boolean collectOnce) {
        return new MonitorFile(realFilePath, monitorFileExpress, logTypeEnum, collectOnce);
    }

    public String getRealFilePath() {
        return this.realFilePath;
    }

    public String getMonitorFileExpress() {
        return this.monitorFileExpress;
    }

    public Pattern getFilePattern() {
        return this.filePattern;
    }

    public boolean isCollectOnce() {
        return this.collectOnce;
    }

    public LogTypeEnum getLogTypeEnum() {
        return this.logTypeEnum;
    }

    public void setRealFilePath(String realFilePath) {
        this.realFilePath = realFilePath;
    }

    public void setMonitorFileExpress(String monitorFileExpress) {
        this.monitorFileExpress = monitorFileExpress;
    }

    public void setFilePattern(Pattern filePattern) {
        this.filePattern = filePattern;
    }

    public void setCollectOnce(boolean collectOnce) {
        this.collectOnce = collectOnce;
    }

    public void setLogTypeEnum(LogTypeEnum logTypeEnum) {
        this.logTypeEnum = logTypeEnum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorFile)) {
            return false;
        }
        MonitorFile other = (MonitorFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCollectOnce() != other.isCollectOnce()) {
            return false;
        }
        String this$realFilePath = this.getRealFilePath();
        String other$realFilePath = other.getRealFilePath();
        if (this$realFilePath == null ? other$realFilePath != null : !this$realFilePath.equals(other$realFilePath)) {
            return false;
        }
        String this$monitorFileExpress = this.getMonitorFileExpress();
        String other$monitorFileExpress = other.getMonitorFileExpress();
        if (this$monitorFileExpress == null ? other$monitorFileExpress != null : !this$monitorFileExpress.equals(other$monitorFileExpress)) {
            return false;
        }
        Pattern this$filePattern = this.getFilePattern();
        Pattern other$filePattern = other.getFilePattern();
        if (this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern)) {
            return false;
        }
        LogTypeEnum this$logTypeEnum = this.getLogTypeEnum();
        LogTypeEnum other$logTypeEnum = other.getLogTypeEnum();
        return !(this$logTypeEnum == null ? other$logTypeEnum != null : !this$logTypeEnum.equals(other$logTypeEnum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitorFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCollectOnce() ? 79 : 97);
        String $realFilePath = this.getRealFilePath();
        result = result * 59 + ($realFilePath == null ? 43 : $realFilePath.hashCode());
        String $monitorFileExpress = this.getMonitorFileExpress();
        result = result * 59 + ($monitorFileExpress == null ? 43 : $monitorFileExpress.hashCode());
        Pattern $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        LogTypeEnum $logTypeEnum = this.getLogTypeEnum();
        result = result * 59 + ($logTypeEnum == null ? 43 : $logTypeEnum.hashCode());
        return result;
    }

    public String toString() {
        return "MonitorFile(realFilePath=" + this.getRealFilePath() + ", monitorFileExpress=" + this.getMonitorFileExpress() + ", filePattern=" + String.valueOf(this.getFilePattern()) + ", collectOnce=" + this.isCollectOnce() + ", logTypeEnum=" + String.valueOf(this.getLogTypeEnum()) + ")";
    }

    public MonitorFile(String realFilePath, String monitorFileExpress, Pattern filePattern, boolean collectOnce, LogTypeEnum logTypeEnum) {
        this.realFilePath = realFilePath;
        this.monitorFileExpress = monitorFileExpress;
        this.filePattern = filePattern;
        this.collectOnce = collectOnce;
        this.logTypeEnum = logTypeEnum;
    }

    public MonitorFile() {
    }
}

