/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.filter.ratelimit;

import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import org.apache.ozhera.log.agent.filter.Invoker;
import org.apache.ozhera.log.agent.filter.MilogFilter;
import org.apache.ozhera.log.api.model.meta.FilterConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatelimitFilter
implements MilogFilter {
    private static final Logger log = LoggerFactory.getLogger(RatelimitFilter.class);
    private RateLimiter rateLimiter;

    @Override
    public void doFilter(Invoker invoker) {
        this.rateLimiter.acquire();
        if (invoker != null) {
            invoker.doInvoker();
        } else {
            log.error("do filter but next invoker is null");
        }
    }

    @Override
    public boolean init(FilterConf conf) {
        Map args = conf.getArgs();
        if (args != null) {
            String ppsStr = (String)args.get("permitsPerSecond");
            try {
                int pps = Integer.parseInt(ppsStr);
                this.rateLimiter = RateLimiter.create((double)pps);
                return true;
            }
            catch (Exception e) {
                log.error("init rateLimit err PERMITSPERSECOND:{},FilterConf:{}", new Object[]{ppsStr, conf, e});
            }
        } else {
            log.warn("wrong rateLimit args FilterConf:{}", (Object)conf);
        }
        return false;
    }
}

