/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.http;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class RestTemplateService {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateService.class);
    @Autowired
    RestTemplate restTemplate;
    @NacosValue(value="${prometheus.header.token:unKnown}")
    private String prometheusHeaderToken;
    @NacosValue(value="${prometheus.cluster.type:local}")
    private String prometheusClusterType;

    public String getHttp(String url, JSONObject param) {
        log.info("RestTemplateService.getHttp url:{}, param:{}", (Object)url, (Object)param);
        String result = null;
        try {
            if (param != null && !param.isEmpty()) {
                url = RestTemplateService.expandURL(url, param);
            }
            result = (String)this.restTemplate.getForObject(url, String.class, (Map)param);
            log.info("RestTemplateService.getHttp url : {}, param : {},result : {} ", new Object[]{url, param, result});
        }
        catch (RestClientException e) {
            log.error("RestTemplateService.getHttp error : {} ", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    public String getHttpM(String url, Map map) {
        log.info("RestTemplateService.getHttp url:{}, map:{}", (Object)url, (Object)map);
        String result = null;
        try {
            if (!CollectionUtils.isEmpty((Map)map)) {
                url = RestTemplateService.expandURLByMap(url, map);
            }
            if (this.prometheusClusterType.equals("ali")) {
                HttpHeaders headers = new HttpHeaders();
                headers.add("Authorization", this.prometheusHeaderToken);
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
                result = (String)response.getBody();
            } else {
                result = (String)this.restTemplate.getForObject(url, String.class, map);
            }
            log.info("RestTemplateService.getHttp url : {}, map : {},result : {} ", new Object[]{url, map, result});
        }
        catch (RestClientException e) {
            log.error("RestTemplateService.getHttp error : {} ", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    public String getHttpMPost(String url, JSONObject param, MediaType mediaType) {
        log.info("RestTemplateService.getHttpMPost url:{},param:{},mediaType:{}", new Object[]{url, param, mediaType});
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        HttpEntity request = new HttpEntity((Object)param, (MultiValueMap)headers);
        String result = null;
        try {
            result = (String)this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
            log.info("RestTemplateService.getHttpMPost url : {}, param : {},result : {} ", new Object[]{url, param, result});
        }
        catch (RestClientException e) {
            log.error("RestTemplateService.getHttpMPost error : {} ", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private static String expandURL(String url, JSONObject jsonObject) {
        StringBuilder sb = new StringBuilder(url);
        sb.append("?");
        Set keys = jsonObject.keySet();
        for (String key : keys) {
            sb.append(key).append("=").append(jsonObject.get((Object)key)).append("&");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static String expandURLByMap(String url, Map map) {
        StringBuilder sb = new StringBuilder(url);
        sb.append("?");
        Set keys = map.entrySet();
        for (Map.Entry entry : keys) {
            sb.append((String)entry.getKey()).append("=").append("{").append((String)entry.getKey()).append("}").append("&");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }
}

