/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ozhera.monitor.bo.AlertGroupInfo;
import org.apache.ozhera.monitor.bo.AlertGroupParam;
import org.apache.ozhera.monitor.bo.UserInfo;
import org.apache.ozhera.monitor.dao.AlertGroupDao;
import org.apache.ozhera.monitor.dao.model.AlertGroup;
import org.apache.ozhera.monitor.dao.model.AlertGroupMember;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.ExceptionCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AlertGroupService;
import org.apache.ozhera.monitor.service.alertmanager.AlertServiceAdapt;
import org.apache.ozhera.monitor.service.helper.AlertHelper;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.user.UserConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AlertGroupServiceImpl
implements AlertGroupService {
    private static final Logger log = LoggerFactory.getLogger(AlertGroupServiceImpl.class);
    @Autowired
    private AlertServiceAdapt alertServiceAdapt;
    @Autowired
    private AlertHelper alertHelper;
    @Autowired
    private AlertGroupDao alertGroupDao;
    @Autowired
    UserConfigService userConfigService;

    @Override
    public Result initAlertGroupData() {
        Result<PageData> pageDataResult = this.alertServiceAdapt.getAlertGroupPageData(null, null, 1, 1000);
        if (pageDataResult == null || pageDataResult.getData() == null || ((PageData)pageDataResult.getData()).getList() == null) {
            return Result.success(null);
        }
        JsonElement ele = (JsonElement)((PageData)pageDataResult.getData()).getList();
        JsonArray arr = ele.getAsJsonArray();
        arr.forEach(subEle -> {
            AlertGroup ag = this.alertHelper.buildAlertGroup(subEle.getAsJsonObject());
            if (this.alertGroupDao.getByRelId("alert", ag.getRelId()) != null) {
                return;
            }
            this.alertGroupDao.insert(ag);
        });
        return Result.success(null);
    }

    @Override
    public Result<PageData<List<UserInfo>>> userSearch(String user, AlertGroupParam param) {
        return this.alertServiceAdapt.searchUser(user, param.getName(), param.getPage(), param.getPageSize());
    }

    @Override
    public Result<PageData<List<AlertGroupInfo>>> alertGroupSearch(String user, AlertGroupParam param) {
        PageData<List<AlertGroupInfo>> pageData = new PageData<List<AlertGroupInfo>>();
        pageData.setPage(param.getPage());
        pageData.setPageSize(param.getPageSize());
        pageData.setTotal(0L);
        boolean admin = this.userConfigService.isAdmin(user);
        PageData<List<AlertGroup>> pageAgList = this.alertGroupDao.searchByCond(admin, user, param.getName(), param.getType(), param.getPage(), param.getPageSize());
        if (pageAgList != null && pageAgList.getList() != null) {
            pageData.setTotal(pageAgList.getTotal());
            pageData.setList(this.alertHelper.buildAlertGroupInfoList(admin, user, pageAgList.getList()));
        }
        return Result.success(pageData);
    }

    @Override
    public Result<List<AlertGroupInfo>> queryByIds(String user, List<Long> ids) {
        List<AlertGroup> agList = this.alertGroupDao.getByIds(ids, true);
        boolean admin = this.userConfigService.isAdmin(user);
        return Result.success(this.alertHelper.buildAlertGroupInfoList(admin, user, agList));
    }

    @Override
    public Result sync(String user, String type) {
        Result<PageData> pageDataResult = this.alertServiceAdapt.getAlertGroupPageData(user, null, 1, 100);
        if (pageDataResult == null || !pageDataResult.isSuccess()) {
            Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        if (pageDataResult.getData() == null || ((PageData)pageDataResult.getData()).getList() == null) {
            return Result.success(null);
        }
        JsonArray list = (JsonArray)((PageData)pageDataResult.getData()).getList();
        if (list.isEmpty()) {
            return Result.success(null);
        }
        HashMap<Long, AlertGroup> relIdMap = new HashMap<Long, AlertGroup>();
        for (int idx = 0; idx < list.size(); ++idx) {
            AlertGroup ag = this.alertHelper.buildAlertGroup((JsonObject)list.get(idx));
            ag.setType(type);
            relIdMap.put(ag.getRelId(), ag);
        }
        List<AlertGroup> dbAgList = this.alertGroupDao.getByRelIds(type, new ArrayList<Long>(relIdMap.keySet()));
        if (!CollectionUtils.isEmpty(dbAgList)) {
            dbAgList.stream().filter(g -> g.getRelId() != null).forEach(g -> relIdMap.remove(g.getRelId()));
        }
        relIdMap.values().forEach(g -> this.alertGroupDao.insert((AlertGroup)g));
        return Result.success(null);
    }

    @Override
    public Result<Map<Long, AlertGroupInfo>> alertGroupSearchByIds(String user, AlertGroupParam param) {
        HashMap<Long, AlertGroupInfo> mapData = new HashMap<Long, AlertGroupInfo>();
        AlertGroupInfo groupInfo = null;
        AlertGroup am = null;
        boolean admin = this.userConfigService.isAdmin(user);
        for (Integer relId : param.getRelIds()) {
            am = this.alertGroupDao.getByRelId(param.getType(), relId.intValue());
            groupInfo = this.alertHelper.buildAlertGroupInfo(admin, user, am);
            if (groupInfo == null) continue;
            mapData.put(relId.longValue(), groupInfo);
        }
        return Result.success(mapData);
    }

    @Override
    public Result<AlertGroupInfo> alertGroupDetailed(String user, AlertGroupParam param) {
        AlertGroup ag = this.alertGroupDao.getById(param.getId());
        boolean isAdmin = this.userConfigService.isAdmin(user);
        return Result.success((Object)this.alertHelper.buildAlertGroupInfo(isAdmin, user, ag));
    }

    @Override
    public Result<AlertGroupInfo> alertGroupCreate(String user, AlertGroupParam param) {
        Result<JsonObject> result = this.alertServiceAdapt.createAlertGroup(user, param.getName(), param.getNote(), param.getChatId(), param.getMemberIds(), param.getDutyInfo());
        if (result == null) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        if (result.getCode() != ErrorCode.success.getCode()) {
            return Result.fail((ExceptionCode)new ExceptionCode(result.getCode(), result.getMessage()));
        }
        param.setId(((JsonObject)result.getData()).get("id").getAsLong());
        Result<JsonObject> resultData = this.alertServiceAdapt.getAlertGroup(user, param.getId());
        if (resultData == null || resultData.getData() == null) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        AlertGroup ag = this.alertHelper.buildAlertGroup((JsonObject)resultData.getData());
        ag.setType(param.getType());
        if (!this.alertGroupDao.insert(ag)) {
            return Result.fail((ErrorCode)ErrorCode.OperFailed);
        }
        boolean isAdmin = this.userConfigService.isAdmin(user);
        return Result.success((Object)this.alertHelper.buildAlertGroupInfo(isAdmin, user, ag));
    }

    @Override
    public Result alertGroupEdit(String user, AlertGroupParam param) {
        AlertGroup ag = this.alertGroupDao.getById(param.getId());
        if (ag == null) {
            return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
        }
        Result<JsonObject> result = this.alertServiceAdapt.editAlertGroup(user, ag.getRelId(), param.getName(), param.getNote(), param.getChatId(), param.getMemberIds(), param.getDutyInfo());
        if (result == null) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        if (result.getCode() != ErrorCode.success.getCode()) {
            return result;
        }
        Result<JsonObject> resultData = this.alertServiceAdapt.getAlertGroup(user, ag.getRelId());
        if (resultData == null || resultData.getData() == null) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        AlertGroup newAg = this.alertHelper.buildAlertGroup((JsonObject)resultData.getData());
        newAg.setId(ag.getId());
        List<AlertGroupMember> addMembers = this.alertHelper.getDiffAgMember(ag.getMembers(), newAg.getMembers());
        List<AlertGroupMember> delMembers = this.alertHelper.getDiffAgMember(newAg.getMembers(), ag.getMembers());
        if (!this.alertGroupDao.updateById(newAg, addMembers, delMembers)) {
            return Result.fail((ErrorCode)ErrorCode.OperFailed);
        }
        return Result.success(null);
    }

    @Override
    public Result alertGroupDelete(String user, AlertGroupParam param) {
        AlertGroup ag = this.alertGroupDao.getById(param.getId());
        if (ag == null) {
            return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
        }
        Result<JsonObject> resultData = this.alertServiceAdapt.getAlertGroup(user, ag.getRelId());
        if (resultData == null || resultData.getData() == null) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        if (((JsonObject)resultData.getData()).has("used") && ((JsonObject)resultData.getData()).get("used").getAsInt() != 0) {
            return Result.fail((ErrorCode)ErrorCode.ALERT_GROUP_USED_FAIL);
        }
        Result<JsonObject> result = this.alertServiceAdapt.deleteAlertGroup(user, ag.getRelId());
        if (result == null) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        if (result.getCode() != ErrorCode.success.getCode()) {
            return result;
        }
        this.alertGroupDao.delete(ag);
        return Result.success(null);
    }

    @Override
    public Result dutyInfoList(String user, AlertGroupParam param) {
        Result<JsonElement> result = this.alertServiceAdapt.dutyInfoList(user, param.getId(), param.getStart(), param.getEnd());
        if (result.isSuccess() && result.getData() != null) {
            JsonArray asJsonArray = ((JsonElement)result.getData()).getAsJsonArray();
            List list = JSONObject.parseArray((String)new Gson().toJson((JsonElement)asJsonArray), Map.class);
            return Result.success((Object)list);
        }
        log.info("dutyInfoList param:{}, result:{}", (Object)param.toString(), (Object)new Gson().toJson(result));
        return result;
    }
}

