/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.prometheus;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.AppScrapeJobDao;
import org.apache.ozhera.monitor.dao.model.AppScrapeJob;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.alertmanager.AlertServiceAdapt;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.scrapeJob.ScrapeJobAdapt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JobService {
    private static final Logger log = LoggerFactory.getLogger(JobService.class);
    @Value(value="${alarm.domain:}")
    private String alarmDomain;
    @Value(value="${prometheus.alarm.env:staging}")
    private String prometheusAlarmEnv;
    @Autowired
    AlertServiceAdapt alarmService;
    @Autowired
    AppScrapeJobDao appScrapeJobDao;
    @Autowired
    ScrapeJobAdapt scrapeJobAdapt;
    public static final byte CREATE_JOB_FAIL = 0;
    public static final byte CREATE_JOB_SUCCESS = 1;
    public static final byte DELETED_JOB = 2;
    private final Gson gson = new Gson();

    public Result createJob(Integer iamId, String user, String jobJson, String jobDesc) {
        String checkResult;
        if (iamId == null) {
            iamId = this.alarmService.getDefaultIamId();
        }
        if (!"ok".equals(checkResult = this.checkJobJson(jobJson))) {
            log.error("AlarmService.createjob request jobJson invalid :{}", (Object)checkResult);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        try {
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(jobJson, JsonObject.class);
            Result result = this.scrapeJobAdapt.addScrapeJob(jsonObject, String.valueOf(iamId), user);
            String data = String.valueOf(result.getData());
            String jobName = jsonObject.get("job_name").getAsString();
            AppScrapeJob appScrapeJob = new AppScrapeJob();
            appScrapeJob.setJobName(jobName);
            appScrapeJob.setJobJson(jobJson);
            appScrapeJob.setIamId(iamId);
            appScrapeJob.setUser(user);
            appScrapeJob.setMessage(result.getMessage());
            if (result.getCode() == 0 && result.getMessage().equals("success")) {
                appScrapeJob.setStatus((byte)1);
                appScrapeJob.setData(data);
                appScrapeJob.setJobDesc(jobDesc);
            } else {
                appScrapeJob.setStatus((byte)0);
                appScrapeJob.setData("fail");
            }
            int dbResult = this.appScrapeJobDao.insertScrapeJob(appScrapeJob);
            log.info("AlarmService.createJob response:{},dbResult: {}", (Object)new Gson().toJson((Object)result).toString(), (Object)dbResult);
            return Result.success((Object)new Gson().toJson((Object)data));
        }
        catch (Exception e) {
            log.error("AlarmService.createJob error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    public Result searchJob(Integer iamId, String user, int scrapeConfigId) {
        if (iamId == null) {
            iamId = this.alarmService.getDefaultIamId();
        }
        AppScrapeJob job = this.appScrapeJobDao.searchScrapeJob(scrapeConfigId);
        Result result = this.scrapeJobAdapt.queryScrapeJob(Integer.parseInt(job.getData()), String.valueOf(iamId), user);
        String data = String.valueOf(result.getData());
        log.info("JobService.searchJob,response:{}", (Object)new Gson().toJson((Object)result).toString());
        return Result.success((Object)job);
    }

    public Result searchJobByName(Integer iamId, String user, String scrapeConfigName) {
        if (iamId == null) {
            iamId = this.alarmService.getDefaultIamId();
        }
        try {
            Result result = this.scrapeJobAdapt.queryScrapeJobByName(scrapeConfigName, String.valueOf(iamId), user);
            String data = String.valueOf(result.getData());
            log.info("JobService.searchJob,response:{}", (Object)new Gson().toJson((Object)result).toString());
            return Result.success((Object)data);
        }
        catch (Exception e) {
            log.error("searchJobByName error :{}", (Object)e.getMessage());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    public Result updateJob(Integer iamId, String user, String jobJson, int primaryId, String jobDesc) {
        String checkResult;
        if (iamId == null) {
            iamId = this.alarmService.getDefaultIamId();
        }
        if (!"ok".equals(checkResult = this.checkJobJson(jobJson))) {
            log.error("JobService.updateJob request jobJson invalid :{}", (Object)checkResult);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AppScrapeJob appScrapeJob = this.appScrapeJobDao.searchScrapeJob(primaryId);
        if (appScrapeJob == null) {
            return Result.fail((ErrorCode)ErrorCode.CannotUpdateANonExistingJob);
        }
        if (appScrapeJob.getStatus() != 1) {
            return Result.fail((ErrorCode)ErrorCode.OnlyJobsThatHaveBeenCreatedSuccessfullyCanBeUpdated);
        }
        String scrapeConfigId = appScrapeJob.getData();
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(jobJson, JsonObject.class);
        Result result = this.scrapeJobAdapt.editScrapeJob(Integer.parseInt(scrapeConfigId), jsonObject, String.valueOf(iamId), user);
        log.info("JobService.updateJob response:{}", (Object)new Gson().toJson((Object)result).toString());
        if (result.getCode() != 0 || !result.getMessage().equals("success")) {
            return Result.fail((ErrorCode)ErrorCode.UpdateJobFail);
        }
        String jobName = jsonObject.get("job_name").getAsString();
        appScrapeJob.setJobName(jobName);
        appScrapeJob.setJobJson(jobJson);
        appScrapeJob.setJobDesc(jobDesc);
        this.appScrapeJobDao.updateScrapeJob(appScrapeJob);
        return Result.success((Object)new Gson().toJson(result.getData()).toString());
    }

    public Result deleteJob(Integer iamId, String user, int primaryId) {
        if (iamId == null) {
            iamId = this.alarmService.getDefaultIamId();
        }
        try {
            AppScrapeJob appScrapeJob = this.appScrapeJobDao.searchScrapeJob(primaryId);
            if (appScrapeJob == null) {
                return Result.fail((ErrorCode)ErrorCode.nonExistentScrapeId);
            }
            String scrapeTaskId = appScrapeJob.getData();
            if (StringUtils.isEmpty((CharSequence)scrapeTaskId)) {
                return Result.fail((ErrorCode)ErrorCode.nonExistentScrapeId);
            }
            if (appScrapeJob.getStatus() == 2) {
                return Result.fail((ErrorCode)ErrorCode.CannotDeleteADeletedJob);
            }
            Result result = this.scrapeJobAdapt.delScrapeJob(Integer.parseInt(scrapeTaskId), String.valueOf(iamId), user);
            String data = String.valueOf(result.getData());
            log.info("JobService.deleteJob response:{}", (Object)new Gson().toJson((Object)result).toString());
            if (result.getCode() != 0 || !result.getMessage().equals("success")) {
                return Result.fail((ErrorCode)ErrorCode.DeleteJobFail);
            }
            appScrapeJob.setStatus((byte)2);
            this.appScrapeJobDao.updateScrapeJob(appScrapeJob);
            return Result.success((Object)new Gson().toJson((Object)data).toString());
        }
        catch (Exception e) {
            log.error("JobService.deleteJob fail error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.DeleteJobFail);
        }
    }

    public Result searchJobList(Integer iamId, String user, Integer pageSize, Integer pageNo) {
        if (iamId == null) {
            iamId = this.alarmService.getDefaultIamId();
        }
        PageData<List<AppScrapeJob>> pd = new PageData<List<AppScrapeJob>>();
        pd.setPage(pageNo);
        pd.setPageSize(pageSize);
        pd.setTotal(this.appScrapeJobDao.getJobSuccessTotal());
        pd.setList(this.appScrapeJobDao.searchScrapeJobList(pageSize, pageNo));
        return Result.success(pd);
    }

    private String checkJobJson(String jobJson) {
        try {
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(jobJson, JsonObject.class);
            String jobName = jsonObject.get("job_name").getAsString();
            String region = jsonObject.get("region").getAsString();
            String zone = jsonObject.get("zone").getAsString();
            String env = jsonObject.get("env").getAsString();
            if (StringUtils.isEmpty((CharSequence)jobName) || StringUtils.isEmpty((CharSequence)region) || StringUtils.isEmpty((CharSequence)zone) || StringUtils.isEmpty((CharSequence)env)) {
                return "Missing some request parameters";
            }
            return "ok";
        }
        catch (Exception e) {
            String errStr = "prometheus job json not right, error is: " + String.valueOf(e);
            log.error(errStr);
            return errStr;
        }
    }
}

