/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.db2.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2CreateTableStatement;
import com.alibaba.druid.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class DB2CreateTableParser
extends SQLCreateTableParser {
    public DB2CreateTableParser(String sql) {
        super(new DB2ExprParser(sql));
    }

    public DB2CreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement stmt) {
        DB2CreateTableStatement createTable = (DB2CreateTableStatement)stmt;
        while (true) {
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.DATA)) {
                this.acceptIdentifier("CAPTURE");
                if (this.lexer.identifierEquals(FnvHash.Constants.NONE)) {
                    this.lexer.nextToken();
                    createTable.setDataCaptureNone(true);
                    continue;
                }
                throw new ParserException("TODO " + this.lexer.info());
            }
            if (this.lexer.nextIf(Token.IN)) {
                if (this.lexer.nextIf(Token.DATABASE)) {
                    SQLName database = this.exprParser.name();
                    createTable.setDatabase(database);
                    continue;
                }
                if (this.lexer.identifierEquals("tablespace")) {
                    throw new ParserException("TODO " + this.lexer.info());
                }
                SQLName tablespace = this.exprParser.name();
                createTable.setTablespace(tablespace);
                continue;
            }
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.PARTITIONING)) {
                SQLPartitionByHash partitionBy = new SQLPartitionByHash();
                this.accept(Token.KEY);
                this.accept(Token.LPAREN);
                this.exprParser.exprList(partitionBy.getColumns(), partitionBy);
                this.accept(Token.RPAREN);
                this.accept(Token.USING);
                this.acceptIdentifier("HASHING");
                createTable.setPartitionBy(partitionBy);
                continue;
            }
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.VALIDPROC)) {
                SQLName validproc = this.exprParser.name();
                createTable.setValidproc(validproc);
                continue;
            }
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.COMPRESS)) {
                createTable.setCompress(true);
                this.lexer.nextIfIdentifier(FnvHash.Constants.YES);
                continue;
            }
            if (!this.lexer.nextIf(Token.INDEX)) break;
            this.accept(Token.IN);
            SQLName indexIn = this.exprParser.name();
            createTable.setIndexIn(indexIn);
        }
    }

    @Override
    protected DB2CreateTableStatement newCreateStatement() {
        return new DB2CreateTableStatement();
    }
}

