/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCurrentTimeExpr;
import com.alibaba.druid.sql.ast.SQLCurrentUserExpr;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateTimeExpr;
import com.alibaba.druid.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.hive.parser.HiveLexer;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.parser.EOFParserException;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class HiveExprParser
extends SQLExprParser {
    private static final String[] AGGREGATE_FUNCTIONS;
    private static final long[] AGGREGATE_FUNCTIONS_CODES;

    public HiveExprParser(String sql) {
        this(new HiveLexer(sql));
        this.lexer.nextToken();
    }

    public HiveExprParser(String sql, SQLParserFeature ... features) {
        this(new HiveLexer(sql, features));
        this.lexer.nextToken();
    }

    public HiveExprParser(Lexer lexer) {
        this(lexer, DbType.hive);
    }

    public HiveExprParser(Lexer lexer, DbType dbType) {
        super(lexer, dbType);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    @Override
    protected SQLExpr primaryCommon(SQLExpr sqlExpr) {
        sqlExpr = new SQLIdentifierExpr(this.lexer.stringVal());
        this.lexer.nextToken();
        return sqlExpr;
    }

    @Override
    protected String doRestSpecific(SQLExpr expr) {
        String name = null;
        if (this.lexer.token() == Token.LITERAL_INT || this.lexer.token() == Token.LITERAL_FLOAT) {
            name = this.lexer.numberString();
            this.lexer.nextToken();
        }
        return name;
    }

    @Override
    protected SQLExpr relationalRestEqeq(SQLExpr expr) {
        SQLExpr rightExp;
        Lexer.SavePoint mark = this.lexer.mark();
        this.lexer.nextToken();
        try {
            if (this.lexer.token() == Token.SEMI) {
                this.lexer.reset(mark);
                return expr;
            }
            rightExp = this.bitOr();
        }
        catch (EOFParserException e) {
            throw new ParserException("EOF, " + expr + "=", e);
        }
        if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
            SQLExpr colonExpr = this.expr();
            rightExp = new SQLBinaryOpExpr(rightExp, SQLBinaryOperator.Assignment, colonExpr, this.dbType);
        }
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.Equality, rightExp, this.dbType);
    }

    @Override
    protected SQLExpr parseAssignItemOnColon(SQLExpr sqlExpr) {
        if (this.lexer.token() == Token.COLON) {
            this.lexer.nextToken();
            String str = sqlExpr.toString() + ':';
            str = str + this.lexer.numberString();
            this.lexer.nextToken();
            sqlExpr = new SQLIdentifierExpr(str);
        }
        return sqlExpr;
    }

    @Override
    protected SQLExpr parseSelectItemRest(String ident, long hash_lower) {
        SQLExprImpl expr = null;
        if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE) && this.lexer.stringVal().charAt(0) != '`') {
            this.lexer.nextToken();
            String collate = this.lexer.stringVal();
            this.lexer.nextToken();
            SQLBinaryOpExpr binaryExpr = new SQLBinaryOpExpr(new SQLIdentifierExpr(ident), SQLBinaryOperator.COLLATE, new SQLIdentifierExpr(collate), this.dbType);
            expr = binaryExpr;
        } else if (FnvHash.Constants.TIMESTAMP == hash_lower && this.lexer.stringVal().charAt(0) != '`' && this.lexer.token() == Token.LITERAL_CHARS) {
            String literal = this.lexer.stringVal();
            this.lexer.nextToken();
            SQLTimestampExpr ts = new SQLTimestampExpr(literal);
            expr = ts;
            if (this.lexer.identifierEquals(FnvHash.Constants.AT)) {
                Lexer.SavePoint mark = this.lexer.mark();
                this.lexer.nextToken();
                String timeZone = null;
                if (this.lexer.identifierEquals(FnvHash.Constants.TIME)) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(FnvHash.Constants.ZONE)) {
                        this.lexer.nextToken();
                        timeZone = this.lexer.stringVal();
                        this.lexer.nextToken();
                    }
                }
                if (timeZone == null) {
                    this.lexer.reset(mark);
                } else {
                    ts.setTimeZone(timeZone);
                }
            }
        } else if (FnvHash.Constants.DATETIME == hash_lower && this.lexer.stringVal().charAt(0) != '`' && this.lexer.token() == Token.LITERAL_CHARS) {
            String literal = this.lexer.stringVal();
            this.lexer.nextToken();
            SQLDateTimeExpr ts = new SQLDateTimeExpr(literal);
            expr = ts;
        } else if (FnvHash.Constants.CURRENT_DATE == hash_lower && ident.charAt(0) != '`' && this.lexer.token() != Token.LPAREN) {
            expr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURRENT_DATE);
        } else if (FnvHash.Constants.CURRENT_TIMESTAMP == hash_lower && ident.charAt(0) != '`' && this.lexer.token() != Token.LPAREN) {
            expr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURRENT_TIMESTAMP);
        } else if (FnvHash.Constants.CURRENT_TIME == hash_lower && ident.charAt(0) != '`' && this.lexer.token() != Token.LPAREN) {
            expr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURRENT_TIME);
        } else if (FnvHash.Constants.CURDATE == hash_lower && ident.charAt(0) != '`' && this.lexer.token() != Token.LPAREN) {
            expr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURDATE);
        } else if (FnvHash.Constants.LOCALTIME == hash_lower && ident.charAt(0) != '`' && this.lexer.token() != Token.LPAREN) {
            expr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.LOCALTIME);
        } else if (FnvHash.Constants.LOCALTIMESTAMP == hash_lower && ident.charAt(0) != '`' && this.lexer.token() != Token.LPAREN) {
            expr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.LOCALTIMESTAMP);
        }
        return expr;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.COLON) {
            this.lexer.nextToken();
            expr = this.dotRest(expr);
            if (expr instanceof SQLPropertyExpr) {
                SQLPropertyExpr spe = (SQLPropertyExpr)expr;
                spe.setSplitString(":");
            }
            return expr;
        }
        switch (this.lexer.token()) {
            case LBRACKET: {
                SQLArrayExpr array = new SQLArrayExpr();
                array.setExpr(expr);
                this.lexer.nextToken();
                this.exprList(array.getValues(), array);
                this.accept(Token.RBRACKET);
                return this.primaryRest(array);
            }
            case LITERAL_CHARS: {
                if (!(expr instanceof SQLCharExpr)) break;
                StringBuilder text2 = new StringBuilder(((SQLCharExpr)expr).getText());
                do {
                    String chars = this.lexer.stringVal();
                    text2.append(chars);
                    this.lexer.nextToken();
                } while (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS);
                expr = new SQLCharExpr(text2.toString());
                break;
            }
            case IDENTIFIER: {
                if (!this.lexer.identifierEquals(FnvHash.Constants.BD) || !(expr instanceof SQLNumericLiteralExpr)) break;
                this.lexer.nextToken();
                Number num = ((SQLNumericLiteralExpr)expr).getNumber();
                expr = new SQLDecimalExpr(num.toString());
                break;
            }
        }
        return super.primaryRest(expr);
    }

    @Override
    public SQLExpr primary() {
        Token tok = this.lexer.token();
        switch (tok) {
            case WITH: {
                return this.primaryRest(new SQLQueryExpr(this.createSelectParser().select()));
            }
            case IDENTIFIER: {
                long hash_lower = this.lexer.hashLCase();
                if (hash_lower == FnvHash.Constants.OUTLINE) {
                    this.lexer.nextToken();
                    SQLExpr file = this.primary();
                    MySqlOutFileExpr expr = new MySqlOutFileExpr(file);
                    return this.primaryRest(expr);
                }
                SQLCurrentTimeExpr currentTimeExpr = null;
                if (hash_lower == FnvHash.Constants.CURRENT_TIMESTAMP) {
                    currentTimeExpr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURRENT_TIMESTAMP);
                } else if (hash_lower == FnvHash.Constants.CURRENT_DATE) {
                    currentTimeExpr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURRENT_DATE);
                } else if (hash_lower == FnvHash.Constants.CURRENT_USER && this.isEnabled(SQLParserFeature.EnableCurrentUserExpr)) {
                    this.lexer.nextToken();
                    return this.primaryRest(new SQLCurrentUserExpr());
                }
                if (currentTimeExpr == null) break;
                String methodName = this.lexer.stringVal();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LPAREN) {
                        this.lexer.nextToken();
                    } else {
                        return this.primaryRest(this.methodRest(new SQLIdentifierExpr(methodName), false));
                    }
                }
                return this.primaryRest(currentTimeExpr);
            }
        }
        return super.primary();
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        String chars = alias.substring(1, alias.length() - 1);
        StringBuilder buf = null;
        for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            if (ch == '\\' && i < chars.length() - 1) {
                char next = chars.charAt(i + 1);
                if (next == '\\') {
                    if (buf == null) {
                        buf = new StringBuilder();
                        buf.append(chars.substring(0, i));
                    }
                    buf.append('\\');
                    ++i;
                    continue;
                }
                if (next == '\"') {
                    if (buf == null) {
                        buf = new StringBuilder();
                        buf.append(chars.substring(0, i));
                    }
                    buf.append('\"');
                    ++i;
                    continue;
                }
                if (buf == null) continue;
                buf.append(ch);
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            chars = buf.toString();
        }
        return new SQLCharExpr(chars);
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.identifierEquals(FnvHash.Constants.MAPPED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.parseAssignItem(column.getMappedBy(), (SQLObject)column);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COLPROPERTIES)) {
            this.lexer.nextToken();
            this.parseAssignItem(column.getColProperties(), (SQLObject)column);
        }
        return super.parseColumnRest(column);
    }

    @Override
    protected SQLExpr parseInterval() {
        String str = this.lexer.stringVal();
        this.accept(Token.INTERVAL);
        if (this.lexer.token() == Token.AS || this.lexer.token() == Token.RPAREN) {
            return new SQLIdentifierExpr(str);
        }
        SQLExpr value = this.expr();
        if (value instanceof SQLIntervalExpr) {
            return value;
        }
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("Syntax error. " + this.lexer.info());
        }
        String unit = this.lexer.stringVal();
        this.lexer.nextToken();
        SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
        intervalExpr.setValue(value);
        SQLIntervalUnit intervalUnit = SQLIntervalUnit.of(unit.toUpperCase());
        if (intervalUnit == SQLIntervalUnit.YEAR && this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            this.acceptIdentifier("MONTH");
            intervalUnit = SQLIntervalUnit.YEAR_TO_MONTH;
        }
        if (intervalUnit == SQLIntervalUnit.YEAR && this.lexer.nextIf(Token.TO)) {
            this.acceptIdentifier(FnvHash.Constants.MONTH);
            intervalUnit = SQLIntervalUnit.YEAR_TO_MONTH;
        } else if (intervalUnit == SQLIntervalUnit.DAY && this.lexer.nextIf(Token.TO)) {
            this.acceptIdentifier(FnvHash.Constants.SECOND);
            intervalUnit = SQLIntervalUnit.DAY_HOUR;
        } else if (intervalUnit == SQLIntervalUnit.HOUR && this.lexer.nextIf(Token.TO)) {
            this.acceptIdentifier(FnvHash.Constants.SECOND);
            intervalUnit = SQLIntervalUnit.HOUR_SECOND;
        }
        intervalExpr.setUnit(intervalUnit);
        return intervalExpr;
    }

    @Override
    protected SQLExpr primaryIdentifierRest(long hash_lower, String ident) {
        if (ident.length() > 3 && ident.charAt(0) == '`' && ident.charAt(ident.length() - 1) == '`' && ident.indexOf(46) != -1) {
            return this.topPropertyExpr(ident);
        }
        return super.primaryIdentifierRest(hash_lower, ident);
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "ROWNUMBER"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            HiveExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

